/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.conf;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.ChannelException;
import com.gemstone.org.jgroups.conf.ClassMap;
import com.gemstone.org.jgroups.conf.MagicNumberReader;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Util;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class ClassConfigurator {
    static ClassConfigurator instance = null;
    private final Map classMap = new HashMap();
    private final Map magicMap = new HashMap();
    private final Map streamMapId = new HashMap();
    private final Map streamMapClass = new HashMap();
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());

    private ClassConfigurator() {
    }

    public void init() throws ChannelException {
        try {
            ClassMap[] mapping = MagicNumberReader.readMagicNumberMappingFromText();
            if (mapping != null) {
                ClassMap currentMap = null;
                for (int i = 0; i < mapping.length; ++i) {
                    currentMap = mapping[i];
                    Integer m = currentMap.getMagicNumber();
                    try {
                        Class clazz = currentMap.getClassForMap();
                        ObjectStreamClass objStreamClass = ObjectStreamClass.lookup(clazz);
                        if (objStreamClass == null) {
                            throw new ChannelException("ObjectStreamClass for " + clazz + " not found");
                        }
                        if (this.magicMap.containsKey(m)) {
                            throw new ChannelException("magic key " + m + " (" + clazz.getName() + ')' + " is already in map; please make sure that " + "all magic keys are unique");
                        }
                        this.magicMap.put(m, clazz);
                        this.classMap.put(clazz, m);
                        this.streamMapId.put(m, objStreamClass);
                        this.streamMapClass.put(objStreamClass, m);
                        continue;
                    }
                    catch (ClassNotFoundException cnf) {
                        throw new ChannelException("failed loading class " + currentMap.getClassName(), cnf);
                    }
                }
            }
        }
        catch (ChannelException ex) {
            throw ex;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable x) {
            SystemFailure.checkFailure();
            throw new ChannelException("failed reading the magic number mapping file", x);
        }
    }

    public static ClassConfigurator getInstance(boolean init) throws ChannelException {
        if (instance == null) {
            instance = new ClassConfigurator();
            if (init) {
                instance.init();
            }
        }
        return instance;
    }

    public Class get(int magic) {
        return (Class)this.magicMap.get(magic);
    }

    public Class get(String clazzname) {
        try {
            return Util.loadClass(clazzname, this.getClass());
        }
        catch (Exception x) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.ClassConfigurator_FAILED_LOADING_CLASS__0, clazzname, (Throwable)x);
            }
            return null;
        }
    }

    public int getMagicNumber(Class clazz) {
        Integer i = (Integer)this.classMap.get(clazz);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public int getMagicNumberFromObjectStreamClass(ObjectStreamClass objStream) {
        Integer i = (Integer)this.streamMapClass.get(objStream);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public ObjectStreamClass getObjectStreamClassFromMagicNumber(int magic_number) {
        ObjectStreamClass retval = null;
        retval = (ObjectStreamClass)this.streamMapId.get(magic_number);
        return retval;
    }

    public String toString() {
        return this.printMagicMap();
    }

    public String printMagicMap() {
        StringBuffer sb = new StringBuffer();
        TreeSet keys = new TreeSet(this.magicMap.keySet());
        for (Integer key2 : keys) {
            sb.append(key2).append(":\t").append(this.magicMap.get(key2)).append('\n');
        }
        return sb.toString();
    }

    public String printClassMap() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : this.classMap.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }
}

