/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.org.jgroups.Address;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Xid
implements Externalizable {
    protected Address creator = null;
    protected long id = 0L;
    protected int mode = 1;
    static transient long next_id = 0L;
    public static final String XID = "xid";
    public static final int DIRTY_READS = 1;
    public static final int READ_COMMITTED = 2;
    public static final int REPEATABLE_READ = 3;
    public static final int SERIALIZABLE = 4;

    public Xid() {
    }

    private Xid(Address creator, long id) {
        this.creator = creator;
        this.id = id;
    }

    private Xid(Address creator, long id, int mode) {
        this.creator = creator;
        this.id = id;
        this.mode = mode;
    }

    public Address getCreator() {
        return this.creator;
    }

    public long getId() {
        return this.id;
    }

    public long getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xid create(Address creator) throws Exception {
        if (creator == null) {
            throw new Exception("Xid.create(): creator == null");
        }
        Class<Xid> clazz = Xid.class;
        synchronized (Xid.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new Xid(creator, ++next_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xid create(Address creator, int mode) throws Exception {
        if (creator == null) {
            throw new Exception("Xid.create(): creator == null");
        }
        Class<Xid> clazz = Xid.class;
        synchronized (Xid.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new Xid(creator, ++next_id, mode);
        }
    }

    public static String modeToString(int m) {
        switch (m) {
            case 1: {
                return "DIRTY_READS";
            }
            case 2: {
                return "READ_COMMITTED";
            }
            case 3: {
                return "REPEATABLE_READ";
            }
            case 4: {
                return "SERIALIZABLE";
            }
        }
        return "<unknown>";
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Xid)) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        return this.creator.hashCode() + (int)this.id;
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof Xid)) {
            throw new ClassCastException("Xid.compareTo(): comparison between different classes");
        }
        Xid other = (Xid)o;
        int comp = this.creator.compareTo(other.getCreator());
        if (comp != 0) {
            return comp;
        }
        if (this.id < other.getId()) {
            return -1;
        }
        if (this.id > other.getId()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('<').append(this.creator).append(">:").append(this.id);
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.creator);
        out.writeLong(this.id);
        out.writeInt(this.mode);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.creator = (Address)in.readObject();
        this.id = in.readLong();
        this.mode = in.readInt();
    }
}

