/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Channel;
import com.gemstone.org.jgroups.ChannelListener;
import com.gemstone.org.jgroups.MembershipListener;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.MessageListener;
import com.gemstone.org.jgroups.SuspectedException;
import com.gemstone.org.jgroups.TimeoutException;
import com.gemstone.org.jgroups.Transport;
import com.gemstone.org.jgroups.blocks.MessageDispatcher;
import com.gemstone.org.jgroups.blocks.MethodCall;
import com.gemstone.org.jgroups.blocks.MethodLookup;
import com.gemstone.org.jgroups.blocks.PullPushAdapter;
import com.gemstone.org.jgroups.util.RspList;
import com.gemstone.org.jgroups.util.Util;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class RpcDispatcher
extends MessageDispatcher
implements ChannelListener {
    protected Object server_obj = null;
    protected Marshaller marshaller = null;
    protected List additionalChannelListeners = null;
    protected MethodLookup method_lookup = null;

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj) {
        super(channel, l, l2);
        channel.addChannelListener(this);
        this.server_obj = server_obj;
        this.additionalChannelListeners = new ArrayList();
    }

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj, boolean deadlock_detection) {
        super(channel, l, l2, deadlock_detection);
        channel.addChannelListener(this);
        this.server_obj = server_obj;
        this.additionalChannelListeners = new ArrayList();
    }

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj, boolean deadlock_detection, boolean concurrent_processing) {
        super(channel, l, l2, deadlock_detection, concurrent_processing);
        channel.addChannelListener(this);
        this.server_obj = server_obj;
        this.additionalChannelListeners = new ArrayList();
    }

    public RpcDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, Object server_obj) {
        super(adapter, id, l, l2);
        Transport t;
        if (this.adapter != null && (t = this.adapter.getTransport()) != null && t instanceof Channel) {
            ((Channel)t).addChannelListener(this);
        }
        this.server_obj = server_obj;
        this.additionalChannelListeners = new ArrayList();
    }

    public String getName() {
        return "RpcDispatcher";
    }

    public void setMarshaller(Marshaller m) {
        this.marshaller = m;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public Object getServerObject() {
        return this.server_obj;
    }

    public MethodLookup getMethodLookup() {
        return this.method_lookup;
    }

    public void setMethodLookup(MethodLookup method_lookup) {
        this.method_lookup = method_lookup;
    }

    @Override
    public RspList castMessage(Vector dests, Message msg, int mode, long timeout) {
        if (this.log.isErrorEnabled()) {
            this.log.error("this method should not be used with RpcDispatcher, but MessageDispatcher. Returning null");
        }
        return null;
    }

    @Override
    public Object sendMessage(Message msg, int mode, long timeout) throws TimeoutException, SuspectedException {
        if (this.log.isErrorEnabled()) {
            this.log.error("this method should not be used with RpcDispatcher, but MessageDispatcher. Returning null");
        }
        return null;
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, Class[] types, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, String[] signature, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout) {
        byte[] buf;
        if (dests != null && dests.size() == 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(new StringBuffer("destination list of ").append(method_call.getName()).append("() is empty: no need to send message"));
            }
            return new RspList();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuffer("dests=").append(dests).append(", method_call=").append(method_call).append(", mode=").append(mode).append(", timeout=").append(timeout));
        }
        try {
            buf = this.marshaller != null ? this.marshaller.objectToByteBuffer(method_call) : Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.RpcDispatcher_EXCEPTION_0, (Throwable)e);
            }
            return null;
        }
        Message msg = new Message(null, null, buf);
        RspList retval = super.castMessage(dests, msg, mode, timeout);
        if (this.log.isTraceEnabled()) {
            this.log.trace("responses: " + retval);
        }
        return retval;
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, Class[] types, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, String[] signature, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, MethodCall method_call, int mode, long timeout) throws TimeoutException, SuspectedException {
        byte[] buf = null;
        Message msg = null;
        Object retval = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=" + dest + ", method_call=" + method_call + ", mode=" + mode + ", timeout=" + timeout);
        }
        try {
            buf = this.marshaller != null ? this.marshaller.objectToByteBuffer(method_call) : Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.RpcDispatcher_EXCEPTION_0, (Throwable)e);
            }
            return null;
        }
        msg = new Message(dest, null, buf);
        retval = super.sendMessage(msg, mode, timeout);
        if (this.log.isTraceEnabled()) {
            this.log.trace("retval: " + retval);
        }
        return retval;
    }

    @Override
    public Object handle(Message req) {
        Object body = null;
        if (this.server_obj == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.RpcDispatcher_NO_METHOD_HANDLER_IS_REGISTERED_DISCARDING_REQUEST);
            }
            return null;
        }
        if (req == null || req.getLength() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.RpcDispatcher_MESSAGE_OR_MESSAGE_BUFFER_IS_NULL);
            }
            return null;
        }
        try {
            body = (this.marshaller != null ? this.marshaller.objectFromByteBuffer(req.getBuffer()) : req.getObject());
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.RpcDispatcher_EXCEPTION_0, e);
            }
            return e;
        }
        if (body == null || !(body instanceof MethodCall)) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.RpcDispatcher_MESSAGE_DOES_NOT_CONTAIN_A_METHODCALL_OBJECT);
            }
            return null;
        }
        MethodCall method_call = body;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("[sender=" + req.getSrc() + "], method_call: " + method_call);
            }
            if (method_call.getMode() == 5) {
                if (this.method_lookup == null) {
                    throw new Exception("MethodCall uses ID=" + method_call.getId() + ", but method_lookup has not been set");
                }
                Method m = this.method_lookup.findMethod(method_call.getId());
                if (m == null) {
                    throw new Exception("no method foudn for " + method_call.getId());
                }
                method_call.setMethod(m);
            }
            return method_call.invoke(this.server_obj);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable x) {
            SystemFailure.checkFailure();
            this.log.error(JGroupsStrings.RpcDispatcher_FAILED_INVOKING_METHOD, x);
            return x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChannelListener(ChannelListener l) {
        List list = this.additionalChannelListeners;
        synchronized (list) {
            if (this.additionalChannelListeners.contains(l)) {
                return false;
            }
            this.additionalChannelListeners.add(l);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChannelListener(ChannelListener l) {
        List list = this.additionalChannelListeners;
        synchronized (list) {
            return this.additionalChannelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelConnected(Channel channel) {
        List list = this.additionalChannelListeners;
        synchronized (list) {
            for (ChannelListener l : this.additionalChannelListeners) {
                try {
                    l.channelConnected(channel);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    this.log.warn("channel listener failed", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelDisconnected(Channel channel) {
        this.stop();
        List list = this.additionalChannelListeners;
        synchronized (list) {
            for (ChannelListener l : this.additionalChannelListeners) {
                try {
                    l.channelDisconnected(channel);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    this.log.warn("channel listener failed", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelClosed(Channel channel) {
        this.stop();
        List list = this.additionalChannelListeners;
        synchronized (list) {
            for (ChannelListener l : this.additionalChannelListeners) {
                try {
                    l.channelClosed(channel);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    this.log.warn("channel listener failed", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelShunned() {
        List list = this.additionalChannelListeners;
        synchronized (list) {
            for (ChannelListener l : this.additionalChannelListeners) {
                try {
                    l.channelShunned();
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    this.log.warn("channel listener failed", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelReconnected(Address new_addr) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("channel has been rejoined, old local_addr=" + this.local_addr + ", new local_addr=" + new_addr);
        }
        this.local_addr = new_addr;
        this.start();
        List list = this.additionalChannelListeners;
        synchronized (list) {
            for (ChannelListener l : this.additionalChannelListeners) {
                try {
                    l.channelReconnected(new_addr);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    this.log.warn("channel listener failed", t);
                }
            }
        }
    }

    public static interface Marshaller {
        public byte[] objectToByteBuffer(Object var1) throws Exception;

        public Object objectFromByteBuffer(byte[] var1) throws Exception;
    }
}

