/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.Transport;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.blocks.RequestHandler;
import com.gemstone.org.jgroups.blocks.RspCollector;
import com.gemstone.org.jgroups.oswego.concurrent.ConcurrentReaderHashMap;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Scheduler;
import com.gemstone.org.jgroups.util.SchedulerListener;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class RequestCorrelator {
    protected Object transport = null;
    protected final Map requests = new ConcurrentReaderHashMap();
    protected RequestHandler request_handler = null;
    protected String name = null;
    protected Scheduler scheduler = null;
    protected Address local_addr = null;
    protected Stack call_stack = null;
    protected boolean deadlock_detection = false;
    protected CallStackSetter call_stack_setter = null;
    protected boolean concurrent_processing = false;
    protected boolean started = false;
    protected static final GemFireTracer log = GemFireTracer.getLog(RequestCorrelator.class);

    public RequestCorrelator(String name, Object transport, RequestHandler handler) {
        this.name = name;
        this.transport = transport;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, Address local_addr) {
        this.name = name;
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection) {
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection, boolean concurrent_processing) {
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.request_handler = handler;
        this.concurrent_processing = concurrent_processing;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection, Address local_addr) {
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection, Address local_addr, boolean concurrent_processing) {
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.concurrent_processing = concurrent_processing;
        this.start();
    }

    public void setDeadlockDetection(boolean flag) {
        if (this.deadlock_detection != flag) {
            this.deadlock_detection = flag;
            if (this.started) {
                if (this.deadlock_detection) {
                    this.startScheduler();
                } else {
                    this.stopScheduler();
                }
            }
        }
    }

    public void setRequestHandler(RequestHandler handler) {
        this.request_handler = handler;
        this.start();
    }

    public void setConcurrentProcessing(boolean concurrent_processing) {
        this.concurrent_processing = concurrent_processing;
    }

    public void sendRequest(long id, Message msg, RspCollector coll) {
        this.sendRequest(id, null, msg, coll);
    }

    public void sendRequest(long id, List dest_mbrs, Message msg, RspCollector coll) {
        block14: {
            if (this.transport == null) {
                if (log.isWarnEnabled()) {
                    log.warn("transport is not available !");
                }
                return;
            }
            Header hdr = new Header(0, id, coll != null, this.name);
            hdr.dest_mbrs = dest_mbrs;
            if (coll != null) {
                if (this.deadlock_detection) {
                    if (this.local_addr == null) {
                        if (log.isErrorEnabled()) {
                            log.error(JGroupsStrings.RequestCorrelator_LOCAL_ADDRESS_IS_NULL_);
                        }
                        return;
                    }
                    Stack new_call_stack = this.call_stack != null ? (Stack)this.call_stack.clone() : new Stack();
                    new_call_stack.push(this.local_addr);
                    hdr.callStack = new_call_stack;
                }
                this.addEntry(hdr.id, new RequestEntry(coll));
            }
            msg.putHeader(this.name, hdr);
            try {
                if (this.transport instanceof Protocol) {
                    ((Protocol)this.transport).passDown(new Event(1, msg));
                } else if (this.transport instanceof Transport) {
                    ((Transport)this.transport).send(msg);
                } else if (log.isErrorEnabled()) {
                    log.error("transport object has to be either a Transport or a Protocol, however it is a " + this.transport.getClass());
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                SystemFailure.checkFailure();
                if (!log.isWarnEnabled()) break block14;
                log.warn(e.toString());
            }
        }
    }

    public void done(long id) {
        this.removeEntry(id);
    }

    public void receive(Event evt) {
        switch (evt.getType()) {
            case 9: {
                this.receiveSuspect(((SuspectMember)evt.getArg()).suspectedMember);
                break;
            }
            case 6: {
                this.receiveView((View)evt.getArg());
                break;
            }
            case 8: {
                this.setLocalAddress((Address)evt.getArg());
                break;
            }
            case 1: {
                if (this.receiveMessage((Message)evt.getArg())) break;
                return;
            }
        }
        if (this.transport instanceof Protocol) {
            ((Protocol)this.transport).passUp(evt);
        } else if (log.isErrorEnabled()) {
            log.error(JGroupsStrings.RequestCorrelator_WE_DO_NOT_PASS_UP_MESSAGES_VIA_TRANSPORT);
        }
    }

    public void start() {
        if (this.deadlock_detection) {
            this.startScheduler();
        }
        this.started = true;
    }

    public void stop() {
        this.stopScheduler();
        this.started = false;
    }

    void startScheduler() {
        if (this.scheduler == null) {
            this.scheduler = new Scheduler();
            if (this.deadlock_detection && this.call_stack_setter == null) {
                this.call_stack_setter = new CallStackSetter();
                this.scheduler.setListener(this.call_stack_setter);
            }
            if (this.concurrent_processing) {
                this.scheduler.setConcurrentProcessing(this.concurrent_processing);
            }
            this.scheduler.start();
        }
    }

    void stopScheduler() {
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
    }

    public void receiveSuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("suspect=" + mbr);
        }
        ArrayList copy = new ArrayList(this.requests.values());
        for (RequestEntry entry : copy) {
            if (entry.coll == null) continue;
            entry.coll.suspect(mbr);
        }
    }

    public void receiveView(View new_view) {
        ArrayList copy = new ArrayList(this.requests.values());
        for (RequestEntry entry : copy) {
            if (entry.coll == null) continue;
            entry.coll.viewChange(new_view);
        }
    }

    public boolean receiveMessage(Message msg) {
        Object tmpHdr = msg.getHeader(this.name);
        if (tmpHdr == null || !(tmpHdr instanceof Header)) {
            return true;
        }
        Header hdr = (Header)tmpHdr;
        if (hdr.corrName == null || !hdr.corrName.equals(this.name)) {
            if (log.isTraceEnabled()) {
                log.trace(new StringBuffer("name of request correlator header (").append(hdr.corrName).append(") is different from ours (").append(this.name).append("). Msg not accepted, passed up"));
            }
            return true;
        }
        List dests = hdr.dest_mbrs;
        if (dests != null && this.local_addr != null && !dests.contains(this.local_addr)) {
            if (log.isTraceEnabled()) {
                log.trace(new StringBuffer("discarded request from ").append(msg.getSrc()).append(" as we are not part of destination list (local_addr=").append(this.local_addr).append(", hdr=").append(hdr).append(')'));
            }
            return false;
        }
        switch (hdr.type) {
            case 0: {
                if (this.request_handler == null) {
                    if (log.isWarnEnabled()) {
                        log.warn("there is no request handler installed to deliver request !");
                    }
                    return false;
                }
                if (this.deadlock_detection) {
                    if (this.scheduler == null) {
                        log.error("deadlock_detection is true, but scheduler is null: this is not supposed to happen (discarding request)");
                        break;
                    }
                    Request req = new Request(msg);
                    Stack stack = hdr.callStack;
                    if (hdr.rsp_expected && stack != null && this.local_addr != null && stack.contains(this.local_addr)) {
                        if (log.isTraceEnabled()) {
                            log.trace("call stack=" + hdr.callStack + " contains " + this.local_addr + ": adding request to priority queue");
                        }
                        this.scheduler.addPrio(req);
                        break;
                    }
                    this.scheduler.add(req);
                    break;
                }
                this.handleRequest(msg);
                break;
            }
            case 1: {
                msg.removeHeader(this.name);
                RspCollector coll = this.findEntry(hdr.id);
                if (coll == null) break;
                coll.receiveResponse(msg);
                break;
            }
            default: {
                msg.removeHeader(this.name);
                if (!log.isErrorEnabled()) break;
                log.error(JGroupsStrings.RequestCorrelator_HEADERS_TYPE_IS_NEITHER_REQ_NOR_RSP_);
            }
        }
        return false;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public void setLocalAddress(Address local_addr) {
        this.local_addr = local_addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(long id, RequestEntry entry) {
        Long id_obj = id;
        Map map = this.requests;
        synchronized (map) {
            if (!this.requests.containsKey(id_obj)) {
                this.requests.put(id_obj, entry);
            } else if (log.isWarnEnabled()) {
                log.warn("entry " + entry + " for request-id=" + id + " already present !");
            }
        }
    }

    private void removeEntry(long id) {
        Long id_obj = id;
        this.requests.remove(id_obj);
    }

    private RspCollector findEntry(long id) {
        Long id_obj = id;
        RequestEntry entry = (RequestEntry)this.requests.get(id_obj);
        return entry != null ? entry.coll : null;
    }

    protected void handleRequest(Message req) {
        block25: {
            Object retval;
            byte[] rsp_buf = null;
            Header hdr = (Header)req.removeHeader(this.name);
            if (log.isTraceEnabled()) {
                log.trace(new StringBuffer("calling (").append(this.request_handler != null ? this.request_handler.getClass().getName() : "null").append(") with request ").append(hdr.id));
            }
            try {
                retval = this.request_handler.handle(req);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                if (log.isErrorEnabled()) {
                    log.error(JGroupsStrings.RequestCorrelator_ERROR_INVOKING_METHOD, t);
                }
                retval = t;
            }
            if (!hdr.rsp_expected) {
                return;
            }
            if (this.transport == null) {
                if (log.isErrorEnabled()) {
                    log.error(JGroupsStrings.RequestCorrelator_FAILURE_SENDING_RESPONSE_NO_TRANSPORT_AVAILABLE);
                }
                return;
            }
            try {
                rsp_buf = Util.objectToByteBuffer(retval);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                try {
                    rsp_buf = Util.objectToByteBuffer(t);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable tt) {
                    SystemFailure.checkFailure();
                    if (log.isErrorEnabled()) {
                        log.error(JGroupsStrings.RequestCorrelator_FAILED_SENDING_RSP_RETURN_VALUE__0__IS_NOT_SERIALIZABLE, retval);
                    }
                    return;
                }
            }
            Message rsp = req.makeReply();
            if (rsp_buf != null) {
                rsp.setBuffer(rsp_buf);
            }
            Header rsp_hdr = new Header(1, hdr.id, false, this.name);
            rsp.putHeader(this.name, rsp_hdr);
            if (log.isTraceEnabled()) {
                log.trace(new StringBuffer("sending rsp for ").append(rsp_hdr.id).append(" to ").append(rsp.getDest()));
            }
            try {
                if (this.transport instanceof Protocol) {
                    ((Protocol)this.transport).passDown(new Event(1, rsp));
                } else if (this.transport instanceof Transport) {
                    ((Transport)this.transport).send(rsp);
                } else if (log.isErrorEnabled()) {
                    log.error("transport object has to be either a Transport or a Protocol, however it is a " + this.transport.getClass());
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                SystemFailure.checkFailure();
                if (!log.isErrorEnabled()) break block25;
                log.error(JGroupsStrings.RequestCorrelator_FAILED_SENDING_THE_RESPONSE, e);
            }
        }
    }

    private class Request
    implements Runnable {
        public final Message req;

        public Request(Message req) {
            this.req = req;
        }

        @Override
        public void run() {
            RequestCorrelator.this.handleRequest(this.req);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.req != null) {
                sb.append("req=" + this.req + ", headers=" + this.req.printObjectHeaders());
            }
            return sb.toString();
        }
    }

    protected class CallStackSetter
    implements SchedulerListener {
        protected CallStackSetter() {
        }

        @Override
        public void started(Runnable r) {
            this.setCallStack(r);
        }

        @Override
        public void stopped(Runnable r) {
            this.setCallStack(null);
        }

        @Override
        public void suspended(Runnable r) {
            this.setCallStack(null);
        }

        @Override
        public void resumed(Runnable r) {
            this.setCallStack(r);
        }

        void setCallStack(Runnable r) {
            if (r == null) {
                RequestCorrelator.this.call_stack = null;
                return;
            }
            Message req = ((Request)r).req;
            if (req == null) {
                return;
            }
            Object obj = req.getHeader(RequestCorrelator.this.name);
            if (obj == null || !(obj instanceof Header)) {
                return;
            }
            Header hdr = (Header)obj;
            if (!hdr.rsp_expected) {
                return;
            }
            Stack new_stack = hdr.callStack;
            if (new_stack != null) {
                RequestCorrelator.this.call_stack = (Stack)new_stack.clone();
            }
        }
    }

    public static final class Header
    extends com.gemstone.org.jgroups.Header
    implements Streamable {
        public static final byte REQ = 0;
        public static final byte RSP = 1;
        public byte type = 0;
        public long id = 0L;
        public boolean rsp_expected = true;
        public String corrName = null;
        public Stack callStack = null;
        public List dest_mbrs = null;

        public Header() {
        }

        public Header(byte type, long id, boolean rsp_expected, String name) {
            this.type = type;
            this.id = id;
            this.rsp_expected = rsp_expected;
            this.corrName = name;
        }

        @Override
        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append("[Header: name=" + this.corrName + ", type=");
            ret.append(this.type == 0 ? "REQ" : (this.type == 1 ? "RSP" : "<unknown>"));
            ret.append(", id=" + this.id);
            ret.append(", rsp_expected=" + this.rsp_expected + ']');
            if (this.callStack != null) {
                ret.append(", call stack=" + this.callStack);
            }
            if (this.dest_mbrs != null) {
                ret.append(", dest_mbrs=").append(this.dest_mbrs);
            }
            return ret.toString();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.id);
            out.writeBoolean(this.rsp_expected);
            if (this.corrName != null) {
                out.writeBoolean(true);
                out.writeUTF(this.corrName);
            } else {
                out.writeBoolean(false);
            }
            out.writeObject(this.callStack);
            out.writeObject(this.dest_mbrs);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.id = in.readLong();
            this.rsp_expected = in.readBoolean();
            if (in.readBoolean()) {
                this.corrName = in.readUTF();
            }
            this.callStack = (Stack)in.readObject();
            this.dest_mbrs = (List)in.readObject();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.id);
            out.writeBoolean(this.rsp_expected);
            if (this.corrName != null) {
                out.writeBoolean(true);
                out.writeUTF(this.corrName);
            } else {
                out.writeBoolean(false);
            }
            if (this.callStack != null) {
                out.writeBoolean(true);
                out.writeShort(this.callStack.size());
                for (int i = 0; i < this.callStack.size(); ++i) {
                    Address mbr = (Address)this.callStack.elementAt(i);
                    Util.writeAddress(mbr, out);
                }
            } else {
                out.writeBoolean(false);
            }
            Util.writeAddresses(this.dest_mbrs, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.id = in.readLong();
            this.rsp_expected = in.readBoolean();
            boolean present = in.readBoolean();
            if (present) {
                this.corrName = in.readUTF();
            }
            if (present = in.readBoolean()) {
                this.callStack = new Stack();
                short len = in.readShort();
                for (short i = 0; i < len; i = (short)(i + 1)) {
                    Address tmp = Util.readAddress(in);
                    this.callStack.add(tmp);
                }
            }
            this.dest_mbrs = (List)Util.readAddresses(in, LinkedList.class);
        }

        @Override
        public long size(short version) {
            long retval = 10L;
            ++retval;
            if (this.corrName != null) {
                retval += (long)(this.corrName.length() + 2);
            }
            ++retval;
            if (this.callStack != null) {
                retval += 2L;
                if (this.callStack.size() > 0) {
                    Address mbr = (Address)this.callStack.firstElement();
                    retval += (long)(this.callStack.size() * Util.size(mbr, version));
                }
            }
            return retval += Util.size(this.dest_mbrs, version);
        }
    }

    private static class RequestEntry {
        public RspCollector coll = null;

        public RequestEntry(RspCollector coll) {
            this.coll = coll;
        }
    }
}

