/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Channel;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.MembershipListener;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.MessageListener;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.blocks.PullPushAdapter;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Promise;
import com.gemstone.org.jgroups.util.Util;
import java.io.Serializable;
import java.util.Vector;

public class NotificationBus
implements MessageListener,
MembershipListener {
    final Vector members = new Vector();
    JChannel channel = null;
    Address local_addr = null;
    PullPushAdapter ad = null;
    Consumer consumer = null;
    String bus_name = "notification_bus";
    final Promise get_cache_promise = new Promise();
    final Object cache_mutex = new Object();
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());
    String props = null;

    public NotificationBus() throws Exception {
        this(null, null);
    }

    public NotificationBus(String bus_name) throws Exception {
        this(bus_name, null);
    }

    public NotificationBus(String bus_name, String properties) throws Exception {
        if (bus_name != null) {
            this.bus_name = bus_name;
        }
        if (properties != null) {
            this.props = properties;
        }
        this.channel = new JChannel(this.props);
    }

    public void setConsumer(Consumer c) {
        this.consumer = c;
    }

    public Address getLocalAddress() {
        if (this.local_addr != null) {
            return this.local_addr;
        }
        if (this.channel != null) {
            this.local_addr = this.channel.getLocalAddress();
        }
        return this.local_addr;
    }

    public Vector getMembership() {
        return this.members;
    }

    public Channel getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCoordinator() {
        Object first_mbr = null;
        Vector vector = this.members;
        synchronized (vector) {
            Object v0 = first_mbr = this.members.size() > 0 ? this.members.elementAt(0) : null;
            if (first_mbr == null) {
                return true;
            }
        }
        if (this.getLocalAddress() != null) {
            return this.getLocalAddress().equals(first_mbr);
        }
        return false;
    }

    public void start() throws Exception {
        this.channel.connect(this.bus_name);
        this.ad = new PullPushAdapter(this.channel, this, this);
    }

    public void stop() {
        if (this.ad != null) {
            this.ad.stop();
            this.ad = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public void sendNotification(Serializable n) {
        block6: {
            Message msg = null;
            byte[] data = null;
            try {
                if (n == null) {
                    return;
                }
                Info info = new Info(1, n);
                data = Util.objectToByteBuffer(info);
                msg = new Message(null, null, data);
                if (this.channel == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("channel is null.  Won't send notification");
                    }
                    return;
                }
                this.channel.send(msg);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                if (!this.log.isErrorEnabled()) break block6;
                this.log.error(JGroupsStrings.NotificationBus_EXCEPTION_IS__0, ex);
            }
        }
    }

    public Serializable getCacheFromCoordinator(long timeout, int max_tries) {
        return this.getCacheFromMember(null, timeout, max_tries);
    }

    public Serializable getCacheFromMember(Address mbr, long timeout, int max_tries) {
        Serializable cache = null;
        int num_tries = 0;
        Address dst = mbr;
        if (max_tries < 1) {
            max_tries = 1;
        }
        this.get_cache_promise.reset();
        while (num_tries <= max_tries) {
            if (mbr == null && ((dst = this.determineCoordinator()) == null || dst.equals(this.getLocalAddress()))) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("[" + this.getLocalAddress() + "] no coordinator found --> first member (cache is empty)");
                }
                return null;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("[" + this.getLocalAddress() + "] dst=" + dst + ", timeout=" + timeout + ", max_tries=" + max_tries + ", num_tries=" + num_tries);
            }
            Info info = new Info(2);
            Message msg = new Message(dst, null, info);
            this.channel.down(new Event(1, msg));
            long start = System.currentTimeMillis();
            cache = (Serializable)this.get_cache_promise.getResult(timeout);
            long stop = System.currentTimeMillis();
            if (cache != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("got cache from " + dst + ": cache is valid (waited " + (stop - start) + " msecs on get_cache_promise)");
                }
                return cache;
            }
            if (this.log.isErrorEnabled()) {
                this.log.error("received null cache; retrying (waited " + (stop - start) + " msecs on get_cache_promise)");
            }
            try {
                Util.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.log.error(JGroupsStrings.NotificationBus_THREAD_INTERRUPTED);
                break;
            }
            ++num_tries;
        }
        if (this.log.isErrorEnabled()) {
            this.log.error("[" + this.getLocalAddress() + "] cache is null (num_tries=" + num_tries + ')');
        }
        return cache;
    }

    public void notifyConsumer(Serializable n) {
        if (this.consumer != null && n != null) {
            this.consumer.handleNotification(n);
        }
    }

    @Override
    public void receive(Message msg) {
        block13: {
            Info info = null;
            if (msg == null || msg.getLength() == 0) {
                return;
            }
            try {
                Object obj = msg.getObject();
                if (!(obj instanceof Info)) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("expected an instance of Info (received " + obj.getClass().getName() + ')');
                    }
                    return;
                }
                info = (Info)obj;
                switch (info.type) {
                    case 1: {
                        this.notifyConsumer(info.data);
                        break;
                    }
                    case 2: {
                        this.handleCacheRequest(msg.getSrc());
                        break;
                    }
                    case 3: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("[GET_CACHE_RSP] cache was received from " + msg.getSrc());
                        }
                        this.get_cache_promise.setResult(info.data);
                        break;
                    }
                    default: {
                        if (this.log.isErrorEnabled()) {
                            this.log.error(JGroupsStrings.NotificationBus_TYPE__0__UNKNOWN, info.type);
                        }
                        break;
                    }
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                if (!this.log.isErrorEnabled()) break block13;
                this.log.error(JGroupsStrings.NotificationBus_EXCEPTION_0, ex);
            }
        }
    }

    @Override
    public byte[] getState() {
        return null;
    }

    @Override
    public void setState(byte[] state) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void viewAccepted(View new_view) {
        Vector left_mbrs;
        Vector joined_mbrs;
        if (new_view == null) {
            return;
        }
        Vector tmp = new_view.getMembers();
        Vector vector = this.members;
        synchronized (vector) {
            Object tmp_mbr;
            int i;
            joined_mbrs = new Vector();
            for (i = 0; i < tmp.size(); ++i) {
                tmp_mbr = tmp.elementAt(i);
                if (this.members.contains(tmp_mbr)) continue;
                joined_mbrs.addElement(tmp_mbr);
            }
            left_mbrs = new Vector();
            for (i = 0; i < this.members.size(); ++i) {
                tmp_mbr = this.members.elementAt(i);
                if (tmp.contains(tmp_mbr)) continue;
                left_mbrs.addElement(tmp_mbr);
            }
            this.members.removeAllElements();
            this.members.addAll(tmp);
        }
        if (this.consumer != null) {
            if (joined_mbrs.size() > 0) {
                for (int i = 0; i < joined_mbrs.size(); ++i) {
                    this.consumer.memberJoined((Address)joined_mbrs.elementAt(i));
                }
            }
            if (left_mbrs.size() > 0) {
                for (int i = 0; i < left_mbrs.size(); ++i) {
                    this.consumer.memberLeft((Address)left_mbrs.elementAt(i));
                }
            }
        }
    }

    @Override
    public void suspect(SuspectMember suspected_mbr) {
    }

    @Override
    public void block() {
    }

    @Override
    public void channelClosing(Channel c, Exception e) {
    }

    Address determineCoordinator() {
        Vector v = this.channel != null ? this.channel.getView().getMembers() : null;
        return v != null ? (Address)v.elementAt(0) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleCacheRequest(Address sender) {
        Serializable cache = null;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.NotificationBus_SENDER_IS_NULL);
            }
            return;
        }
        Object object = this.cache_mutex;
        synchronized (object) {
            cache = this.getCache();
            Info info = new Info(3, cache);
            Message msg = new Message(sender, null, info);
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.NotificationBus__0__RETURNING_CACHE_TO__1, new Object[]{this.getLocalAddress(), sender});
            }
            this.channel.down(new Event(1, msg));
        }
    }

    public Serializable getCache() {
        return this.consumer != null ? this.consumer.getCache() : null;
    }

    private static class Info
    implements Serializable {
        private static final long serialVersionUID = -2247826108262348005L;
        public static final int NOTIFICATION = 1;
        public static final int GET_CACHE_REQ = 2;
        public static final int GET_CACHE_RSP = 3;
        int type = 0;
        Serializable data = null;

        public Info(int type) {
            this.type = type;
        }

        public Info(int type, Serializable data) {
            this.type = type;
            this.data = data;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("type= ");
            if (this.type == 1) {
                sb.append("NOTIFICATION");
            } else if (this.type == 2) {
                sb.append("GET_CACHE_REQ");
            } else if (this.type == 3) {
                sb.append("GET_CACHE_RSP");
            } else {
                sb.append("<unknown>");
            }
            if (this.data != null) {
                if (this.type == 1) {
                    sb.append(", notification=" + this.data);
                } else if (this.type == 3) {
                    sb.append(", cache=" + this.data);
                }
            }
            return sb.toString();
        }
    }

    public static interface Consumer {
        public void handleNotification(Serializable var1);

        public Serializable getCache();

        public void memberJoined(Address var1);

        public void memberLeft(Address var1);
    }
}

