/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MethodCall
implements Externalizable {
    static final long serialVersionUID = 7873471327078957662L;
    protected String method_name = null;
    protected short method_id = (short)-1;
    protected Object[] args = null;
    protected Class[] types = null;
    protected String[] signature = null;
    protected Method method = null;
    protected Map payload = null;
    protected static final GemFireTracer log = GemFireTracer.getLog(MethodCall.class);
    protected short mode = 1;
    protected static final short OLD = 1;
    protected static final short METHOD = 2;
    protected static final short TYPES = 3;
    protected static final short SIGNATURE = 4;
    protected static final short ID = 5;

    public MethodCall() {
    }

    public MethodCall(Method method) {
        this(method, null);
    }

    public MethodCall(Method method, Object[] arguments) {
        this.init(method);
        if (arguments != null) {
            this.args = arguments;
        }
    }

    @Deprecated
    public MethodCall(String method_name, Object[] args) {
        this.method_name = method_name;
        this.mode = 1;
        this.args = args;
    }

    public MethodCall(short method_id, Object[] args) {
        this.method_id = method_id;
        this.mode = (short)5;
        this.args = args;
    }

    public MethodCall(String method_name, Object[] args, Class[] types) {
        this.method_name = method_name;
        this.args = args;
        this.types = types;
        this.mode = (short)3;
    }

    public MethodCall(String method_name, Object[] args, String[] signature) {
        this.method_name = method_name;
        this.args = args;
        this.signature = signature;
        this.mode = (short)4;
    }

    private void init(Method method) {
        this.method = method;
        this.mode = (short)2;
        this.method_name = method.getName();
    }

    public int getMode() {
        return this.mode;
    }

    public String getName() {
        return this.method_name;
    }

    public void setName(String n) {
        this.method_name = n;
    }

    public short getId() {
        return this.method_id;
    }

    public void setId(short method_id) {
        this.method_id = method_id;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object[] args) {
        if (args != null) {
            this.args = args;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method m) {
        this.init(m);
    }

    public synchronized Object put(Object key2, Object value2) {
        if (this.payload == null) {
            this.payload = new HashMap();
        }
        return this.payload.put(key2, value2);
    }

    public synchronized Object get(Object key2) {
        return this.payload != null ? this.payload.get(key2) : null;
    }

    Method findMethod(Class target_class) throws Exception {
        int len = this.args != null ? this.args.length : 0;
        Method[] methods = this.getAllMethods(target_class);
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(this.method_name) || m.getParameterTypes().length != len) continue;
            return m;
        }
        return null;
    }

    Method[] getAllMethods(Class target) {
        ArrayList<Method[]> methods = new ArrayList<Method[]>();
        int size2 = 0;
        for (Class superclass = target; superclass != null; superclass = superclass.getSuperclass()) {
            Method[] m = superclass.getDeclaredMethods();
            methods.add(m);
            size2 += m.length;
        }
        Method[] result = new Method[size2];
        int index2 = 0;
        for (Method[] m : methods) {
            System.arraycopy(m, 0, result, index2, m.length);
            index2 += m.length;
        }
        return result;
    }

    Method getMethod(Class target, String methodName, Class[] types) {
        if (types == null) {
            types = new Class[]{};
        }
        Method[] methods = this.getAllMethods(target);
        block0: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] parameters;
            Method m = methods[i];
            if (!methodName.equals(m.getName()) || types.length != (parameters = m.getParameterTypes()).length) continue;
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equals(parameters[j])) continue block0;
            }
            return m;
        }
        return null;
    }

    public Object invoke(Object target) throws Throwable {
        Method meth = null;
        Object retval = null;
        if (this.method_name == null || target == null) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.MethodCall_METHOD_NAME_OR_TARGET_IS_NULL);
            }
            return null;
        }
        Class<?> cl = target.getClass();
        try {
            switch (this.mode) {
                case 1: {
                    meth = this.findMethod(cl);
                    break;
                }
                case 2: {
                    if (this.method == null) break;
                    meth = this.method;
                    break;
                }
                case 3: {
                    meth = this.getMethod(cl, this.method_name, this.types);
                    break;
                }
                case 4: {
                    Class[] mytypes = null;
                    if (this.signature != null) {
                        mytypes = this.getTypesFromString(cl, this.signature);
                    }
                    meth = this.getMethod(cl, this.method_name, mytypes);
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    if (!log.isErrorEnabled()) break;
                    log.error(JGroupsStrings.MethodCall_MODE__0__IS_INVALID, this.mode);
                }
            }
            if (meth != null) {
                retval = meth.invoke(target, this.args);
            } else if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.MethodCall_METHOD__0__NOT_FOUND, this.method_name);
            }
            return retval;
        }
        catch (InvocationTargetException inv_ex) {
            throw inv_ex.getTargetException();
        }
        catch (NoSuchMethodException no) {
            StringBuffer sb = new StringBuffer();
            sb.append("found no method called ").append(this.method_name).append(" in class ");
            sb.append(cl.getName()).append(" with (");
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.args[i] != null ? this.args[i].getClass().getName() : "null");
                }
            }
            sb.append(") formal parameters");
            log.error(sb.toString());
            throw no;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.MethodCall_EXCEPTION_IN_INVOKE, e);
            }
            throw e;
        }
    }

    public Object invoke(Object target, Object[] args) throws Throwable {
        if (args != null) {
            this.args = args;
        }
        return this.invoke(target);
    }

    Class[] getTypesFromString(Class cl, String[] signature) throws Exception {
        Class[] mytypes = new Class[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            String name = signature[i];
            Class<Constable> parameter = "long".equals(name) ? Long.TYPE : ("int".equals(name) ? Integer.TYPE : ("short".equals(name) ? Short.TYPE : ("char".equals(name) ? Character.TYPE : ("byte".equals(name) ? Byte.TYPE : ("float".equals(name) ? Float.TYPE : ("double".equals(name) ? Double.TYPE : ("boolean".equals(name) ? Boolean.TYPE : ClassPathLoader.getLatest().forName(name))))))));
            mytypes[i] = parameter;
        }
        return mytypes;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        boolean first = true;
        if (this.method_name != null) {
            ret.append(this.method_name);
        } else {
            ret.append(this.method_id);
        }
        ret.append('(');
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    ret.append(", ");
                }
                ret.append(this.args[i]);
            }
        }
        ret.append(')');
        return ret.toString();
    }

    public String toStringDetails() {
        StringBuffer ret = new StringBuffer();
        ret.append("MethodCall ");
        if (this.method_name != null) {
            ret.append("name=").append(this.method_name);
        } else {
            ret.append("id=").append(this.method_id);
        }
        ret.append(", number of args=").append(this.args != null ? this.args.length : 0).append(')');
        if (this.args != null) {
            ret.append("\nArgs:");
            for (int i = 0; i < this.args.length; ++i) {
                ret.append("\n[").append(this.args[i]).append(" (").append(this.args[i] != null ? this.args[i].getClass().getName() : "null").append(")]");
            }
        }
        return ret.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.method_name != null) {
            out.writeBoolean(true);
            out.writeUTF(this.method_name);
        } else {
            out.writeBoolean(false);
            out.writeShort(this.method_id);
        }
        out.writeObject(this.args);
        out.writeShort(this.mode);
        switch (this.mode) {
            case 1: {
                break;
            }
            case 2: {
                out.writeObject(this.method.getParameterTypes());
                out.writeObject(this.method.getDeclaringClass());
                break;
            }
            case 3: {
                out.writeObject(this.types);
                break;
            }
            case 4: {
                out.writeObject(this.signature);
                break;
            }
            case 5: {
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error(JGroupsStrings.MethodCall_MODE__0__IS_INVALID, this.mode);
            }
        }
        if (this.payload != null) {
            out.writeBoolean(true);
            out.writeObject(this.payload);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean name_available = in.readBoolean();
        if (name_available) {
            this.method_name = in.readUTF();
        } else {
            this.method_id = in.readShort();
        }
        this.args = (Object[])in.readObject();
        this.mode = in.readShort();
        switch (this.mode) {
            case 1: {
                break;
            }
            case 2: {
                Class[] parametertypes = (Class[])in.readObject();
                Class declaringclass = (Class)in.readObject();
                try {
                    this.method = declaringclass.getDeclaredMethod(this.method_name, parametertypes);
                    break;
                }
                catch (NoSuchMethodException e) {
                    throw new IOException(e.toString());
                }
            }
            case 3: {
                this.types = (Class[])in.readObject();
                break;
            }
            case 4: {
                this.signature = (String[])in.readObject();
                break;
            }
            case 5: {
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error(JGroupsStrings.MethodCall_MODE__0__IS_INVALID, this.mode);
            }
        }
        boolean payload_available = in.readBoolean();
        if (payload_available) {
            this.payload = (Map)in.readObject();
        }
    }
}

