/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.MessageListener;
import java.util.HashSet;

public class MessageListenerAdapter
implements MessageListener {
    protected MessageListener stateListener;
    protected final HashSet messageListeners = new HashSet();
    protected MessageListener[] messageListenersCache = new MessageListener[0];

    public MessageListenerAdapter() {
        this(null);
    }

    public MessageListenerAdapter(MessageListener mainListener) {
        if (mainListener != null) {
            this.stateListener = mainListener;
            this.addMessageListener(mainListener);
        }
    }

    @Override
    public byte[] getState() {
        if (this.stateListener != null) {
            return this.stateListener.getState();
        }
        return null;
    }

    @Override
    public void receive(Message msg) {
        for (int i = 0; i < this.messageListenersCache.length; ++i) {
            this.messageListenersCache[i].receive(msg);
        }
    }

    @Override
    public void setState(byte[] state) {
        if (this.stateListener != null) {
            this.stateListener.setState(state);
        }
    }

    public synchronized void addMessageListener(MessageListener listener) {
        if (this.messageListeners.add(listener)) {
            this.messageListenersCache = this.messageListeners.toArray(new MessageListener[this.messageListeners.size()]);
        }
    }

    public synchronized void removeMessageListener(MessageListener listener) {
        if (this.messageListeners.remove(listener)) {
            this.messageListenersCache = this.messageListeners.toArray(new MessageListener[this.messageListeners.size()]);
        }
    }

    public void setStateListener(MessageListener listener) {
        this.stateListener = listener;
    }
}

