/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.TimedWriter;
import com.gemstone.org.jgroups.util.Util;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

@SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="GemFire does not use this class")
public class Link
implements Runnable {
    String local_addr = null;
    String remote_addr = null;
    InetAddress local = null;
    InetAddress remote = null;
    int local_port = 0;
    int remote_port = 0;
    ServerSocket srv_sock = null;
    Socket outgoing = null;
    Socket incoming = null;
    DataOutputStream outstream = null;
    DataInputStream instream = null;
    boolean established = false;
    boolean trace = false;
    Thread receiver_thread = null;
    static final long receiver_thread_join_timeout = 2000L;
    Receiver receiver = null;
    static final int HB_PACKET = -99;
    Heartbeat hb = null;
    long timeout = 10000L;
    long hb_interval = 3000L;
    final Object outgoing_mutex = new Object();
    TimedWriter writer = null;
    GemFireTracer log = GemFireTracer.getLog(this.getClass());

    public Link(String local_addr, int local_port, String remote_addr, int remote_port) {
        this.local_addr = local_addr;
        this.local_port = local_port;
        this.remote_addr = remote_addr;
        this.remote_port = remote_port;
        this.hb = new Heartbeat(this.timeout, this.hb_interval);
    }

    public Link(String local_addr, int local_port, String remote_addr, int remote_port, Receiver r) {
        this(local_addr, local_port, remote_addr, remote_port);
        this.setReceiver(r);
    }

    public Link(String local_addr, int local_port, String remote_addr, int remote_port, long timeout, long hb_interval, Receiver r) {
        this.local_addr = local_addr;
        this.local_port = local_port;
        this.remote_addr = remote_addr;
        this.remote_port = remote_port;
        this.timeout = timeout;
        this.hb_interval = hb_interval;
        this.hb = new Heartbeat(timeout, hb_interval);
        this.setReceiver(r);
    }

    public void setTrace(boolean t) {
        this.trace = t;
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public boolean established() {
        return this.established;
    }

    public InetAddress getLocalAddress() {
        return this.local;
    }

    public InetAddress getRemoteAddress() {
        return this.remote;
    }

    public int getLocalPort() {
        return this.local_port;
    }

    public int getRemotePort() {
        return this.remote_port;
    }

    public void start() throws Exception {
        this.local = InetAddress.getByName(this.local_addr);
        this.remote = InetAddress.getByName(this.remote_addr);
        this.srv_sock = new ServerSocket(this.local_port, 1, this.local);
        this.createOutgoingConnection(this.hb_interval);
        this.startReceiverThread();
        this.hb.start();
    }

    public void stop() {
        this.stopReceiverThread();
        this.hb.stop();
        try {
            this.srv_sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.established = false;
    }

    public boolean send(byte[] buf) {
        if (buf == null || buf.length == 0) {
            if (this.trace) {
                System.err.println("Link.send(): buffer is null or does not contain any data !");
            }
            return false;
        }
        if (!this.established) {
            if (this.trace) {
                this.log.error(JGroupsStrings.Link_LINKSEND_CONNECTION_NOT_ESTABLISHED_DISCARDING_MESSAGE);
            }
            return false;
        }
        try {
            this.outstream.writeInt(buf.length);
            this.outstream.write(buf);
            return true;
        }
        catch (Exception ex) {
            if (this.trace) {
                this.log.error(JGroupsStrings.Link_LINKSEND1_SENDING_FAILED_RETRYING);
            }
            return this.retry(buf);
        }
    }

    boolean retry(byte[] buf) {
        this.closeOutgoingConnection();
        if (!this.createOutgoingConnection()) {
            this.closeOutgoingConnection();
            return false;
        }
        try {
            this.outstream.writeInt(buf.length);
            this.outstream.write(buf);
            return true;
        }
        catch (Exception e) {
            if (this.trace) {
                System.out.println("Link.send2(): failed, closing connection");
            }
            this.closeOutgoingConnection();
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("Link <" + this.local_addr + ':' + this.local_port + " --> " + this.remote_addr + ':' + this.remote_port + '>');
        ret.append(this.established ? " (established)" : " (not established)");
        return ret.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Link)) {
            return false;
        }
        Link o = (Link)other;
        return this.local_addr.equals(o.local_addr) && this.remote_addr.equals(o.remote_addr) && this.local_port == o.local_port && this.remote_port == o.remote_port;
    }

    public int hashCode() {
        return this.local_addr.hashCode() + this.remote_addr.hashCode() + this.local_port + this.remote_port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startReceiverThread() {
        Link link = this;
        synchronized (link) {
            this.stopReceiverThread();
            this.receiver_thread = new Thread((Runnable)this, "Link.ReceiverThreadThread");
            this.receiver_thread.setDaemon(true);
            this.receiver_thread.start();
        }
    }

    synchronized void stopReceiverThread() {
        Thread t = this.receiver_thread;
        if (t != null && t.isAlive()) {
            this.closeIncomingConnection();
            t.interrupt();
            try {
                t.join(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.receiver_thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createOutgoingConnection() {
        Object object = this.outgoing_mutex;
        synchronized (object) {
            if (this.established) {
                return true;
            }
            try {
                this.outgoing = new Socket(this.remote, this.remote_port, this.local, 0);
                this.outgoing.setSoLinger(true, 1);
                this.outstream = new DataOutputStream(this.outgoing.getOutputStream());
                if (this.receiver != null) {
                    this.receiver.linkUp(this.local, this.local_port, this.remote, this.remote_port);
                }
                this.established = true;
                if (this.trace) {
                    System.out.println("-- CREATE: outgoing is " + this.printSocket(this.outgoing));
                }
                return true;
            }
            catch (Exception e) {
                this.established = false;
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createOutgoingConnection(long timeout) {
        Object object = this.outgoing_mutex;
        synchronized (object) {
            if (this.established) {
                return true;
            }
            try {
                if (this.writer == null) {
                    this.writer = new TimedWriter();
                }
                this.outgoing = this.writer.createSocket(this.local, this.remote, this.remote_port, timeout);
                this.outgoing.setSoLinger(true, 1);
                this.outstream = new DataOutputStream(this.outgoing.getOutputStream());
                if (this.receiver != null) {
                    this.receiver.linkUp(this.local, this.local_port, this.remote, this.remote_port);
                }
                this.established = true;
                if (this.trace) {
                    System.out.println("-- CREATE: outgoing is " + this.printSocket(this.outgoing));
                }
                return true;
            }
            catch (Exception e) {
                this.established = false;
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeOutgoingConnection() {
        Object object = this.outgoing_mutex;
        synchronized (object) {
            if (!this.established) {
                return;
            }
            if (this.outstream != null) {
                if (this.trace) {
                    System.out.println("-- CLOSE: outgoing is " + this.printSocket(this.outgoing));
                }
                try {
                    this.outstream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.outstream = null;
            }
            if (this.outgoing != null) {
                try {
                    this.outgoing.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.outgoing = null;
            }
            this.established = false;
            if (this.receiver != null) {
                this.receiver.linkDown(this.local, this.local_port, this.remote, this.remote_port);
            }
        }
    }

    synchronized void closeIncomingConnection() {
        if (this.instream != null) {
            if (this.trace) {
                System.out.println("-- CLOSE: incoming is " + this.printSocket(this.incoming));
            }
            try {
                this.instream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.instream = null;
        }
        if (this.incoming != null) {
            try {
                this.incoming.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.incoming = null;
        }
    }

    synchronized void closeConnections() {
        this.closeOutgoingConnection();
        this.closeIncomingConnection();
    }

    String printSocket(Socket s) {
        if (s == null) {
            return "<null>";
        }
        StringBuffer ret = new StringBuffer();
        ret.append(s.getLocalAddress().getHostName());
        ret.append(':');
        ret.append(s.getLocalPort());
        ret.append(" --> ");
        ret.append(s.getInetAddress().getHostName());
        ret.append(':');
        ret.append(s.getPort());
        return ret.toString();
    }

    protected static class MyReceiver
    implements Receiver {
        protected MyReceiver() {
        }

        @Override
        public void receive(byte[] msg) {
            System.out.println("<-- " + new String(msg));
        }

        @Override
        public void linkDown(InetAddress l, int lp, InetAddress r, int rp) {
            System.out.println("** linkDown(): " + r + ':' + rp);
        }

        @Override
        public void linkUp(InetAddress l, int lp, InetAddress r, int rp) {
            System.out.println("** linkUp(): " + r + ':' + rp);
        }

        @Override
        public void missedHeartbeat(InetAddress l, int lp, InetAddress r, int rp, int num) {
            System.out.println("** missedHeartbeat(): " + r + ':' + rp);
        }

        @Override
        public void receivedHeartbeatAgain(InetAddress l, int lp, InetAddress r, int rp) {
            System.out.println("** receivedHeartbeatAgain(): " + r + ':' + rp);
        }
    }

    class Heartbeat
    implements Runnable {
        Thread thread = null;
        long hb_timeout = 10000L;
        long interval = 3000L;
        long last_hb = System.currentTimeMillis();
        boolean missed_hb = false;
        final TimedWriter timed_writer = new TimedWriter();

        public Heartbeat(long timeout, long hb_interval) {
            this.hb_timeout = timeout;
            this.interval = hb_interval;
        }

        public synchronized void start() {
            this.stop();
            this.missed_hb = false;
            this.last_hb = System.currentTimeMillis();
            this.thread = new Thread((Runnable)this, "HeartbeatThread");
            this.thread.setDaemon(true);
            this.thread.start();
        }

        public synchronized void interrupt() {
            this.thread.interrupt();
        }

        public synchronized void stop() {
            if (this.thread != null && this.thread.isAlive()) {
                this.missed_hb = false;
                this.thread.interrupt();
                try {
                    this.thread.join(this.hb_timeout + 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.thread = null;
            }
        }

        public void receivedMessage() {
            this.last_hb = System.currentTimeMillis();
            if (this.missed_hb) {
                if (Link.this.receiver != null) {
                    Link.this.receiver.receivedHeartbeatAgain(Link.this.local, Link.this.local_port, Link.this.remote, Link.this.remote_port);
                }
                this.missed_hb = false;
            }
        }

        public void receivedHeartbeat() {
            this.last_hb = System.currentTimeMillis();
            if (this.missed_hb) {
                if (Link.this.receiver != null) {
                    Link.this.receiver.receivedHeartbeatAgain(Link.this.local, Link.this.local_port, Link.this.remote, Link.this.remote_port);
                }
                this.missed_hb = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long diff = 0L;
            long curr_time = 0L;
            long num_missed_hbs = 0L;
            if (Link.this.trace) {
                System.out.println("heartbeat to " + Link.this.remote + ':' + Link.this.remote_port + " started");
            }
            while (true) {
                SystemFailure.checkFailure();
                if (Link.this.established) {
                    block22: {
                        if (Link.this.outstream != null) {
                            try {
                                this.timed_writer.write((OutputStream)Link.this.outstream, -99, 1500L);
                                Thread.sleep(this.interval);
                                break block22;
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                            catch (Exception io_ex) {
                                Link.this.closeOutgoingConnection();
                                continue;
                            }
                        }
                        Link.this.established = false;
                        continue;
                    }
                    curr_time = System.currentTimeMillis();
                    diff = curr_time - this.last_hb;
                    if (curr_time - this.last_hb > this.interval) {
                        num_missed_hbs = (curr_time - this.last_hb) / this.interval;
                        if (Link.this.receiver != null) {
                            Link.this.receiver.missedHeartbeat(Link.this.local, Link.this.local_port, Link.this.remote, Link.this.remote_port, (int)num_missed_hbs);
                        }
                        this.missed_hb = true;
                    }
                    if (diff < this.hb_timeout) continue;
                    if (Link.this.trace) {
                        System.out.println("###### Link.Heartbeat.run(): no heartbeat receveived for " + diff + " msecs. Closing connections. #####");
                    }
                    Link.this.closeConnections();
                    continue;
                }
                Object object = Link.this.outgoing_mutex;
                synchronized (object) {
                    if (Link.this.established) {
                        continue;
                    }
                    try {
                        Link.this.outgoing = this.timed_writer.createSocket(Link.this.local, Link.this.remote, Link.this.remote_port, this.interval);
                        Link.this.outstream = new DataOutputStream(Link.this.outgoing.getOutputStream());
                        if (Link.this.receiver != null) {
                            Link.this.receiver.linkUp(Link.this.local, Link.this.local_port, Link.this.remote, Link.this.remote_port);
                        }
                        Link.this.established = true;
                        if (Link.this.trace) {
                            System.out.println("-- CREATE (CE): " + Link.this.printSocket(Link.this.outgoing));
                        }
                    }
                    catch (InterruptedException interrupted_ex) {
                        break;
                    }
                    catch (Exception ex) {
                        try {
                            Util.sleep(this.interval);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
            }
            if (Link.this.trace) {
                System.out.println("heartbeat to " + Link.this.remote + ':' + Link.this.remote_port + " stopped");
            }
            this.thread = null;
        }
    }

    public static interface Receiver {
        public void receive(byte[] var1);

        public void linkDown(InetAddress var1, int var2, InetAddress var3, int var4);

        public void linkUp(InetAddress var1, int var2, InetAddress var3, int var4);

        public void missedHeartbeat(InetAddress var1, int var2, InetAddress var3, int var4, int var5);

        public void receivedHeartbeatAgain(InetAddress var1, int var2, InetAddress var3, int var4);
    }
}

