/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.Transport;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.blocks.RequestCorrelator;
import com.gemstone.org.jgroups.blocks.RspCollector;
import com.gemstone.org.jgroups.util.Command;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Rsp;
import com.gemstone.org.jgroups.util.RspList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public class GroupRequest
implements RspCollector,
Command {
    public static final int GET_FIRST = 1;
    public static final int GET_ALL = 2;
    public static final int GET_MAJORITY = 3;
    public static final int GET_ABS_MAJORITY = 4;
    public static final int GET_N = 5;
    public static final int GET_NONE = 6;
    private Address caller = null;
    private final Map requests = new HashMap();
    private final Vector suspects = new Vector();
    private final Collection members = new TreeSet();
    private final int max_suspects = 40;
    protected Message request_msg = null;
    protected RequestCorrelator corr = null;
    protected Transport transport = null;
    protected int rsp_mode = 2;
    protected boolean done = false;
    protected long timeout = 0L;
    protected int expected_mbrs = 0;
    private static final GemFireTracer log = GemFireTracer.getLog(GroupRequest.class);
    private static long last_req_id = 1L;
    private long req_id = -1L;

    public GroupRequest(Message m, RequestCorrelator corr, Vector members, int rsp_mode) {
        this.request_msg = m;
        this.corr = corr;
        this.rsp_mode = rsp_mode;
        this.reset(members);
    }

    public GroupRequest(Message m, RequestCorrelator corr, Vector members, int rsp_mode, long timeout, int expected_mbrs) {
        this(m, corr, members, rsp_mode);
        if (timeout > 0L) {
            this.timeout = timeout;
        }
        this.expected_mbrs = expected_mbrs;
    }

    public GroupRequest(Message m, Transport transport, Vector members, int rsp_mode) {
        this.request_msg = m;
        this.transport = transport;
        this.rsp_mode = rsp_mode;
        this.reset(members);
    }

    public GroupRequest(Message m, Transport transport, Vector members, int rsp_mode, long timeout, int expected_mbrs) {
        this(m, transport, members, rsp_mode);
        if (timeout > 0L) {
            this.timeout = timeout;
        }
        this.expected_mbrs = expected_mbrs;
    }

    public Address getCaller() {
        return this.caller;
    }

    public void setCaller(Address caller) {
        this.caller = caller;
    }

    @Override
    public boolean execute() {
        if (this.corr == null && this.transport == null) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.GroupRequest_BOTH_CORR_AND_TRANSPORT_ARE_NULL_CANNOT_SEND_GROUP_REQUEST);
            }
            return false;
        }
        this.done = false;
        boolean retval = this.doExecute(this.timeout);
        if (!retval && log.isTraceEnabled()) {
            log.trace("call did not execute correctly, request is " + this.toString());
        }
        this.done = true;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Vector mbrs) {
        if (mbrs != null) {
            Object object = this.requests;
            synchronized (object) {
                this.requests.clear();
                for (int i = 0; i < mbrs.size(); ++i) {
                    Address mbr = (Address)mbrs.elementAt(i);
                    this.requests.put(mbr, new Rsp(mbr));
                }
            }
            object = this.members;
            synchronized (object) {
                this.members.clear();
                this.members.addAll(mbrs);
            }
        }
        Map map = this.requests;
        synchronized (map) {
            for (Rsp rsp : this.requests.values()) {
                rsp.setReceived(false);
                rsp.setValue(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveResponse(Message m) {
        Object val;
        Address sender;
        block12: {
            sender = m.getSrc();
            val = null;
            if (this.done) {
                if (log.isWarnEnabled()) {
                    log.warn("command is done; cannot add response !");
                }
                return;
            }
            if (this.suspects != null && this.suspects.size() > 0 && this.suspects.contains(sender)) {
                if (log.isWarnEnabled()) {
                    log.warn("received response from suspected member " + sender + "; discarding");
                }
                return;
            }
            if (m.getLength() > 0) {
                try {
                    val = m.getObject();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block12;
                    log.error(JGroupsStrings.GroupRequest_EXCEPTION_0, (Throwable)e);
                }
            }
        }
        Map map = this.requests;
        synchronized (map) {
            Rsp rsp = (Rsp)this.requests.get(sender);
            if (rsp != null && !rsp.wasReceived()) {
                rsp.setValue(val);
                rsp.setReceived(true);
                if (log.isTraceEnabled()) {
                    log.trace(new StringBuffer("received response for request ").append(this.req_id).append(", sender=").append(sender).append(", val=").append((Object)val));
                }
                this.requests.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspect(Address suspected_member) {
        if (suspected_member == null) {
            return;
        }
        this.addSuspect(suspected_member);
        Map map = this.requests;
        synchronized (map) {
            Rsp rsp = (Rsp)this.requests.get(suspected_member);
            if (rsp != null) {
                rsp.setSuspected(true);
                rsp.setValue(null);
                this.requests.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChange(View new_view) {
        Vector mbrs;
        Vector vector = mbrs = new_view != null ? new_view.getMembers() : null;
        if (this.requests == null || this.requests.size() == 0 || mbrs == null) {
            return;
        }
        Collection collection = this.members;
        synchronized (collection) {
            this.members.clear();
            this.members.addAll(mbrs);
        }
        boolean modified = false;
        Map map = this.requests;
        synchronized (map) {
            for (Map.Entry entry : this.requests.entrySet()) {
                Address mbr = (Address)entry.getKey();
                if (mbrs.contains(mbr)) continue;
                this.addSuspect(mbr);
                Rsp rsp = (Rsp)entry.getValue();
                rsp.setValue(null);
                rsp.setSuspected(true);
                modified = true;
            }
            if (modified) {
                this.requests.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RspList getResults() {
        Map map = this.requests;
        synchronized (map) {
            Collection rsps = this.requests.values();
            RspList retval = new RspList(rsps);
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer ret = new StringBuffer(128);
        ret.append("[GroupRequest:\n");
        ret.append("req_id=").append(this.req_id).append('\n');
        if (this.caller != null) {
            ret.append("caller=").append(this.caller).append("\n");
        }
        Map map = this.requests;
        synchronized (map) {
            for (Map.Entry entry : this.requests.entrySet()) {
                Address mbr = (Address)entry.getKey();
                Rsp rsp = (Rsp)entry.getValue();
                ret.append(mbr).append(": ").append(rsp).append("\n");
            }
        }
        if (this.suspects.size() > 0) {
            ret.append("\nsuspects: ").append(this.suspects);
        }
        ret.append("\nrequest_msg: ").append(this.request_msg);
        ret.append("\nrsp_mode: ").append(this.modeToString(this.rsp_mode));
        ret.append("\ndone: ").append(this.done);
        ret.append("\ntimeout: ").append(this.timeout);
        ret.append("\nexpected_mbrs: ").append(this.expected_mbrs);
        ret.append("\n]");
        return ret.toString();
    }

    public int getNumSuspects() {
        return this.suspects.size();
    }

    public Vector getSuspects() {
        return this.suspects;
    }

    public boolean isDone() {
        return this.done;
    }

    private int determineMajority(int i) {
        return i < 2 ? i : i / 2 + 1;
    }

    private static synchronized long getRequestId() {
        long result = System.currentTimeMillis();
        if (result <= last_req_id) {
            result = last_req_id + 1L;
        }
        last_req_id = result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExecute(long timeout) {
        long start_time = 0L;
        this.req_id = GroupRequest.getRequestId();
        this.reset(null);
        Map map = this.requests;
        synchronized (map) {
            for (int i = 0; i < this.suspects.size(); ++i) {
                Address suspect = (Address)this.suspects.elementAt(i);
                Rsp rsp = (Rsp)this.requests.get(suspect);
                if (rsp == null) continue;
                rsp.setSuspected(true);
                break;
            }
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace(new StringBuffer("sending request (id=").append(this.req_id).append(')'));
            }
            if (this.corr != null) {
                Vector tmp = new Vector(this.members);
                this.corr.sendRequest(this.req_id, tmp, this.request_msg, this.rsp_mode == 6 ? null : this);
            } else {
                this.transport.send(this.request_msg);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            log.error(JGroupsStrings.GroupRequest_EXCEPTION_0, e);
            if (this.corr != null) {
                this.corr.done(this.req_id);
            }
            return false;
        }
        map = this.requests;
        synchronized (map) {
            if (timeout <= 0L) {
                while (true) {
                    this.adjustMembership();
                    if (this.responsesComplete()) {
                        if (this.corr != null) {
                            this.corr.done(this.req_id);
                        }
                        if (log.isTraceEnabled()) {
                            log.trace("received all responses: " + this.toString());
                        }
                        return true;
                    }
                    try {
                        this.requests.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return false;
                    }
                }
            }
            start_time = System.currentTimeMillis();
            while (timeout > 0L) {
                if (this.responsesComplete()) {
                    if (this.corr != null) {
                        this.corr.done(this.req_id);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("received all responses: " + this.toString());
                    }
                    return true;
                }
                if ((timeout -= System.currentTimeMillis() - start_time) <= 0L) continue;
                try {
                    this.requests.wait(timeout);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (this.corr != null) {
                this.corr.done(this.req_id);
            }
            return false;
        }
    }

    private boolean responsesComplete() {
        int num_received = 0;
        int num_not_received = 0;
        int num_suspected = 0;
        int num_total = this.requests.size();
        int majority = this.determineMajority(num_total);
        for (Rsp rsp : this.requests.values()) {
            if (rsp.wasReceived()) {
                ++num_received;
                continue;
            }
            if (rsp.wasSuspected()) {
                ++num_suspected;
                continue;
            }
            ++num_not_received;
        }
        switch (this.rsp_mode) {
            case 1: {
                if (num_received > 0) {
                    return true;
                }
                if (num_suspected < num_total) break;
                return true;
            }
            case 2: {
                return num_not_received <= 0;
            }
            case 3: {
                if (num_received + num_suspected < majority) break;
                return true;
            }
            case 4: {
                if (num_received < majority) break;
                return true;
            }
            case 5: {
                if (this.expected_mbrs >= num_total) {
                    this.rsp_mode = 2;
                    return this.responsesComplete();
                }
                if (num_received >= this.expected_mbrs) {
                    return true;
                }
                if (num_received + num_not_received < this.expected_mbrs) {
                    return num_received + num_suspected >= this.expected_mbrs;
                }
                return false;
            }
            case 6: {
                return true;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error(JGroupsStrings.GroupRequest_RSP_MODE__0__UNKNOWN_, this.rsp_mode);
            }
        }
        return false;
    }

    private void adjustMembership() {
        if (this.requests.size() == 0) {
            return;
        }
        for (Map.Entry entry : this.requests.entrySet()) {
            Address mbr = (Address)entry.getKey();
            if (this.members.contains(mbr) && !this.suspects.contains(mbr)) continue;
            this.addSuspect(mbr);
            Rsp rsp = (Rsp)entry.getValue();
            rsp.setValue(null);
            rsp.setSuspected(true);
        }
    }

    private void addSuspect(Address suspected_mbr) {
        if (!this.suspects.contains(suspected_mbr)) {
            this.suspects.addElement(suspected_mbr);
            while (this.suspects.size() >= 40 && this.suspects.size() > 0) {
                this.suspects.remove(0);
            }
        }
    }

    private String modeToString(int m) {
        switch (m) {
            case 1: {
                return "GET_FIRST";
            }
            case 2: {
                return "GET_ALL";
            }
            case 3: {
                return "GET_MAJORITY";
            }
            case 4: {
                return "GET_ABS_MAJORITY";
            }
            case 5: {
                return "GET_N";
            }
            case 6: {
                return "GET_NONE";
            }
        }
        return "<unknown> (" + m + ")";
    }
}

