/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Channel;
import com.gemstone.org.jgroups.ChannelClosedException;
import com.gemstone.org.jgroups.ChannelException;
import com.gemstone.org.jgroups.ChannelFactory;
import com.gemstone.org.jgroups.ChannelNotConnectedException;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.MembershipListener;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.MessageListener;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.blocks.PullPushAdapter;
import com.gemstone.org.jgroups.blocks.RpcDispatcher;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.RspList;
import com.gemstone.org.jgroups.util.Util;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Vector;

public class DistributedQueue
implements MessageListener,
MembershipListener,
Cloneable {
    protected GemFireTracer logger = GemFireTracer.getLog(this.getClass());
    private long internal_timeout = 10000L;
    protected Object mutex = new Object();
    protected transient boolean stopped = false;
    protected LinkedList internalQueue;
    protected transient Channel channel;
    protected transient RpcDispatcher disp = null;
    protected transient String groupname = null;
    protected transient Vector notifs = new Vector();
    protected transient Vector members = new Vector();
    private transient Class[] add_signature = null;
    private transient Class[] addAtHead_signature = null;
    private transient Class[] addAll_signature = null;
    private transient Class[] reset_signature = null;
    private transient Class[] remove_signature = null;

    public DistributedQueue(String groupname, ChannelFactory factory, String properties, long state_timeout) throws ChannelException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DistributedQueue(" + groupname + ',' + properties + ',' + state_timeout);
        }
        this.groupname = groupname;
        this.initSignatures();
        this.internalQueue = new LinkedList();
        this.channel = factory != null ? factory.createChannel(properties) : new JChannel(properties);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.disp.setDeadlockDetection(false);
        this.channel.setOpt(4, Boolean.TRUE);
        this.channel.connect(groupname);
        this.start(state_timeout);
    }

    public DistributedQueue(JChannel channel) {
        this.groupname = channel.getChannelName();
        this.channel = channel;
        this.init();
    }

    public DistributedQueue(PullPushAdapter adapter, Serializable id) {
        this.channel = (Channel)adapter.getTransport();
        this.groupname = this.channel.getChannelName();
        this.initSignatures();
        this.internalQueue = new LinkedList();
        this.channel.setOpt(4, Boolean.TRUE);
        this.disp = new RpcDispatcher(adapter, id, (MessageListener)this, (MembershipListener)this, this);
        this.disp.setDeadlockDetection(false);
    }

    protected void init() {
        this.initSignatures();
        this.internalQueue = new LinkedList();
        this.channel.setOpt(4, Boolean.TRUE);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.disp.setDeadlockDetection(false);
    }

    public void start(long state_timeout) throws ChannelClosedException, ChannelNotConnectedException {
        this.logger.debug("DistributedQueue.initState(" + this.groupname + "): starting state retrieval");
        boolean rc = this.channel.getState(null, state_timeout);
        if (rc) {
            this.logger.info(JGroupsStrings.DistributedQueue_DISTRIBUTEDQUEUEINITSTATE_0__STATE_WAS_RETRIEVED_SUCCESSFULLY, this.groupname);
        } else {
            this.logger.info(JGroupsStrings.DistributedQueue_DISTRIBUTEDQUEUEINITSTATE_0__STATE_COULD_NOT_BE_RETRIEVED_FIRST_MEMBER, this.groupname);
        }
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void addNotifier(Notification n) {
        if (n != null && !this.notifs.contains(n)) {
            this.notifs.addElement(n);
        }
    }

    public void removeNotifier(Notification n) {
        this.notifs.removeElement(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.clear();
            if (this.disp != null) {
                this.disp.stop();
                this.disp = null;
            }
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            this.stopped = true;
        }
    }

    public void add(Object value2) {
        try {
            Object retval = null;
            RspList rsp = this.disp.callRemoteMethods(null, "_add", new Object[]{value2}, this.add_signature, 2, 0L);
            Vector results = rsp.getResults();
            if (results.size() > 0) {
                retval = results.elementAt(0);
                if (this.logger.isDebugEnabled()) {
                    this.checkResult(rsp, retval);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(JGroupsStrings.DistributedQueue_UNABLE_TO_ADD_VALUE__0, value2, (Throwable)e);
        }
    }

    public void addAtHead(Object value2) {
        try {
            this.disp.callRemoteMethods(null, "_addAtHead", new Object[]{value2}, this.addAtHead_signature, 2, 0L);
        }
        catch (Exception e) {
            this.logger.error(JGroupsStrings.DistributedQueue_UNABLE_TO_ADDATHEAD_VALUE__0, value2, (Throwable)e);
        }
    }

    public void addAll(Collection values) {
        try {
            this.disp.callRemoteMethods(null, "_addAll", new Object[]{values}, this.addAll_signature, 2, 0L);
        }
        catch (Exception e) {
            this.logger.error(JGroupsStrings.DistributedQueue_UNABLE_TO_ADDALL_VALUE__0, values, (Throwable)e);
        }
    }

    public Vector getContents() {
        Vector result = new Vector();
        Iterator e = this.internalQueue.iterator();
        while (e.hasNext()) {
            result.add(e.next());
        }
        return result;
    }

    public int size() {
        return this.internalQueue.size();
    }

    public Object peek() {
        Object retval = null;
        try {
            retval = this.internalQueue.getFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return retval;
    }

    public void reset() {
        try {
            this.disp.callRemoteMethods(null, "_reset", null, this.reset_signature, 2, 0L);
        }
        catch (Exception e) {
            this.logger.error(JGroupsStrings.DistributedQueue_DISTRIBUTEDQUEUERESET_0, this.groupname, (Throwable)e);
        }
    }

    protected void checkResult(RspList rsp, Object retval) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Value updated from " + this.groupname + " :" + retval);
        }
        Vector results = rsp.getResults();
        for (int i = 0; i < results.size(); ++i) {
            Object data = results.elementAt(i);
            if (data.equals(retval)) continue;
            this.logger.error(JGroupsStrings.DistributedQueue_REFERENCE_VALUE_DIFFERS_FROM_RETURNED_VALUE__0____1, new Object[]{retval, data});
        }
    }

    public Object remove() {
        Object retval = null;
        RspList rsp = this.disp.callRemoteMethods(null, "_remove", null, this.remove_signature, 2, this.internal_timeout);
        Vector results = rsp.getResults();
        if (results.size() > 0) {
            retval = results.elementAt(0);
            if (this.logger.isDebugEnabled()) {
                this.checkResult(rsp, retval);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long timeout) {
        Object retval = null;
        long start = System.currentTimeMillis();
        if (timeout <= 0L) {
            while (!this.stopped && retval == null) {
                RspList rsp = this.disp.callRemoteMethods(null, "_remove", null, this.remove_signature, 2, this.internal_timeout);
                Vector results = rsp.getResults();
                if (results.size() > 0) {
                    retval = results.elementAt(0);
                    if (this.logger.isDebugEnabled()) {
                        this.checkResult(rsp, retval);
                    }
                }
                if (retval != null) continue;
                try {
                    Object object = this.mutex;
                    synchronized (object) {
                        this.mutex.wait();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
        } else {
            while (System.currentTimeMillis() - start < timeout && !this.stopped && retval == null) {
                RspList rsp = this.disp.callRemoteMethods(null, "_remove", null, this.remove_signature, 2, this.internal_timeout);
                Vector results = rsp.getResults();
                if (results.size() > 0) {
                    retval = results.elementAt(0);
                    if (this.logger.isDebugEnabled()) {
                        this.checkResult(rsp, retval);
                    }
                }
                if (retval != null) continue;
                try {
                    long delay = timeout - (System.currentTimeMillis() - start);
                    Object object = this.mutex;
                    synchronized (object) {
                        if (delay > 0L) {
                            this.mutex.wait(delay);
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        return retval;
    }

    public String toString() {
        return this.internalQueue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _add(Object value2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.groupname + '@' + this.getLocalAddress() + " _add(" + value2 + ')');
        }
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.add(value2);
            this.mutex.notifyAll();
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).entryAdd(value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _addAtHead(Object value2) {
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.addFirst(value2);
            this.mutex.notifyAll();
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).entryAdd(value2);
        }
    }

    public void _reset() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.groupname + '@' + this.getLocalAddress() + " _reset()");
        }
        this._private_reset();
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).contentsCleared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _private_reset() {
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.clear();
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object _remove() {
        Object retval = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                retval = this.internalQueue.removeFirst();
                this.mutex.notifyAll();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.groupname + '@' + this.getLocalAddress() + "_remove(" + retval + ')');
            }
            for (int i = 0; i < this.notifs.size(); ++i) {
                ((Notification)this.notifs.elementAt(i)).entryRemoved(retval);
            }
        }
        catch (NoSuchElementException e) {
            this.logger.debug(this.groupname + '@' + this.getLocalAddress() + "_remove(): nothing to remove");
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _addAll(Collection c) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.groupname + '@' + this.getLocalAddress() + " _addAll(" + c + ')');
        }
        Object object = this.mutex;
        synchronized (object) {
            this.internalQueue.addAll(c);
            this.mutex.notifyAll();
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).contentsSet(c);
        }
    }

    @Override
    public void receive(Message msg) {
    }

    @Override
    public byte[] getState() {
        Vector copy = (Vector)this.getContents().clone();
        try {
            return Util.objectToByteBuffer(copy);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            this.logger.error(JGroupsStrings.DistributedQueue_DISTRIBUTEDQUEUEGETSTATE_EXCEPTION_MARSHALLING_STATE, ex);
            return null;
        }
    }

    @Override
    public void setState(byte[] new_state) {
        Vector new_copy;
        try {
            new_copy = (Vector)Util.objectFromByteBuffer(new_state);
            if (new_copy == null) {
                return;
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            this.logger.error(JGroupsStrings.DistributedQueue_DISTRIBUTEDQUEUESETSTATE_EXCEPTION_UNMARSHALLING_STATE, ex);
            return;
        }
        this._private_reset();
        this._addAll(new_copy);
    }

    @Override
    public void viewAccepted(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_mbrs, this.members);
            this.members.removeAllElements();
            for (int i = 0; i < new_mbrs.size(); ++i) {
                this.members.addElement(new_mbrs.elementAt(i));
            }
        }
    }

    @Override
    public void suspect(SuspectMember suspected_mbr) {
    }

    @Override
    public void block() {
    }

    @Override
    public void channelClosing(Channel c, Exception e) {
    }

    void sendViewChangeNotifications(Vector new_mbrs, Vector old_mbrs) {
        Object mbr;
        int i;
        if (this.notifs.size() == 0 || old_mbrs == null || new_mbrs == null || old_mbrs.size() == 0 || new_mbrs.size() == 0) {
            return;
        }
        Vector joined = new Vector();
        for (i = 0; i < new_mbrs.size(); ++i) {
            mbr = new_mbrs.elementAt(i);
            if (old_mbrs.contains(mbr)) continue;
            joined.addElement(mbr);
        }
        Vector left = new Vector();
        for (i = 0; i < old_mbrs.size(); ++i) {
            mbr = old_mbrs.elementAt(i);
            if (new_mbrs.contains(mbr)) continue;
            left.addElement(mbr);
        }
        for (i = 0; i < this.notifs.size(); ++i) {
            Notification n = (Notification)this.notifs.elementAt(i);
            n.viewChange(joined, left);
        }
    }

    void initSignatures() {
        try {
            if (this.add_signature == null) {
                this.add_signature = new Class[]{Object.class};
            }
            if (this.addAtHead_signature == null) {
                this.addAtHead_signature = new Class[]{Object.class};
            }
            if (this.addAll_signature == null) {
                this.addAll_signature = new Class[]{Collection.class};
            }
            if (this.reset_signature == null) {
                this.reset_signature = new Class[0];
            }
            if (this.remove_signature == null) {
                this.remove_signature = new Class[0];
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            this.logger.error(JGroupsStrings.DistributedQueue_DISTRIBUTEDQUEUEINITMETHODS, ex);
        }
    }

    public static interface Notification {
        public void entryAdd(Object var1);

        public void entryRemoved(Object var1);

        public void viewChange(Vector var1, Vector var2);

        public void contentsCleared();

        public void contentsSet(Collection var1);
    }
}

