/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.JGroupsVersion;
import com.gemstone.org.jgroups.blocks.ConnectionTable;
import com.gemstone.org.jgroups.oswego.concurrent.BoundedBuffer;
import com.gemstone.org.jgroups.oswego.concurrent.DirectExecutor;
import com.gemstone.org.jgroups.oswego.concurrent.Executor;
import com.gemstone.org.jgroups.oswego.concurrent.FutureResult;
import com.gemstone.org.jgroups.oswego.concurrent.LinkedQueue;
import com.gemstone.org.jgroups.oswego.concurrent.PooledExecutor;
import com.gemstone.org.jgroups.protocols.TCP_NIO;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class ConnectionTableNIO
extends ConnectionTable
implements Runnable {
    private ServerSocketChannel m_serverSocketChannel;
    private Selector m_acceptSelector;
    protected static final GemFireTracer LOG = GemFireTracer.getLog(ConnectionTableNIO.class);
    private WriteHandler[] m_writeHandlers;
    private int m_nextWriteHandler = 0;
    private Object m_lockNextWriteHandler = new Object();
    private ReadHandler[] m_readHandlers;
    private int m_nextReadHandler = 0;
    private Object m_lockNextReadHandler = new Object();
    protected Executor m_requestProcessors;

    public ConnectionTableNIO(int srv_port) throws Exception {
        super(srv_port);
    }

    public ConnectionTableNIO(int srv_port, long reaper_interval, long conn_expire_time) throws Exception {
        super(srv_port, reaper_interval, conn_expire_time);
    }

    public ConnectionTableNIO(ConnectionTable.Receiver r, InetAddress bind_addr, InetAddress external_addr, int srv_port, int max_port) throws Exception {
        super(r, bind_addr, external_addr, srv_port, max_port);
    }

    public ConnectionTableNIO(ConnectionTable.Receiver r, InetAddress bind_addr, InetAddress external_addr, int srv_port, int max_port, long reaper_interval, long conn_expire_time) throws Exception {
        super(r, bind_addr, external_addr, srv_port, max_port, reaper_interval, conn_expire_time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ConnectionTable.Connection getConnection(Address dest) throws Exception {
        Connection conn = null;
        HashMap hashMap = this.conns;
        synchronized (hashMap) {
            conn = (Connection)this.conns.get(dest);
            if (conn == null) {
                int idx;
                block25: {
                    SocketChannel sock_ch;
                    block24: {
                        InetSocketAddress destAddress = new InetSocketAddress(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort());
                        sock_ch = SocketChannel.open(destAddress);
                        conn = new Connection(sock_ch, dest);
                        conn.sendLocalAddress(this.local_addr);
                        conn.getReadState().setHandShakingStatus(99);
                        try {
                            sock_ch.configureBlocking(false);
                        }
                        catch (IOException e) {
                            conn.destroy();
                            throw e;
                        }
                        try {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("About to change new connection send buff size from " + sock_ch.socket().getSendBufferSize() + " bytes");
                            }
                            sock_ch.socket().setSendBufferSize(this.send_buf_size);
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Changed new connection send buff size to " + sock_ch.socket().getSendBufferSize() + " bytes");
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            if (!this.log.isErrorEnabled()) break block24;
                            this.log.error("exception setting send buffer size to " + this.send_buf_size + " bytes: " + ex);
                        }
                    }
                    try {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("About to change new connection receive buff size from " + sock_ch.socket().getReceiveBufferSize() + " bytes");
                        }
                        sock_ch.socket().setReceiveBufferSize(this.recv_buf_size);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Changed new connection receive buff size to " + sock_ch.socket().getReceiveBufferSize() + " bytes");
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        if (!this.log.isErrorEnabled()) break block25;
                        this.log.error("exception setting receive buffer size to " + this.send_buf_size + " bytes: " + ex);
                    }
                }
                Object object = this.m_lockNextWriteHandler;
                synchronized (object) {
                    idx = this.m_nextWriteHandler = (this.m_nextWriteHandler + 1) % this.m_writeHandlers.length;
                }
                conn.setupWriteHandler(this.m_writeHandlers[idx]);
                try {
                    object = this.m_lockNextReadHandler;
                    synchronized (object) {
                        idx = this.m_nextReadHandler = (this.m_nextReadHandler + 1) % this.m_readHandlers.length;
                    }
                    this.m_readHandlers[idx].add(conn);
                }
                catch (InterruptedException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Thread (" + Thread.currentThread().getName() + ") was interrupted, closing connection", e);
                    }
                    conn.destroy();
                    throw e;
                }
                this.addConnection(dest, conn);
                this.notifyConnectionOpened(dest);
                if (LOG.isInfoEnabled()) {
                    LOG.info(JGroupsStrings.ConnectionTableNIO_CREATED_SOCKET_TO__0, dest);
                }
            }
            return conn;
        }
    }

    @Override
    protected void init() throws Exception {
        TCP_NIO NIOreceiver = (TCP_NIO)this.receiver;
        if (NIOreceiver.getProcessorMaxThreads() <= 0) {
            this.m_requestProcessors = new DirectExecutor();
        } else {
            PooledExecutor requestProcessors = new PooledExecutor(new BoundedBuffer(NIOreceiver.getProcessorQueueSize()), NIOreceiver.getProcessorMaxThreads());
            requestProcessors.setMinimumPoolSize(NIOreceiver.getProcessorMinThreads());
            requestProcessors.setKeepAliveTime(NIOreceiver.getProcessorKeepAliveTime());
            requestProcessors.waitWhenBlocked();
            requestProcessors.createThreads(NIOreceiver.getProcessorThreads());
            this.m_requestProcessors = requestProcessors;
        }
        this.m_writeHandlers = WriteHandler.create(NIOreceiver.getWriterThreads());
        this.m_readHandlers = new ReadHandler[NIOreceiver.getReaderThreads()];
        for (int i = 0; i < this.m_readHandlers.length; ++i) {
            this.m_readHandlers[i] = new ReadHandler();
        }
    }

    @Override
    public void stop() {
        int i;
        if (this.m_serverSocketChannel.isOpen()) {
            try {
                this.m_serverSocketChannel.close();
            }
            catch (Exception eat) {
                // empty catch block
            }
        }
        this.m_acceptSelector.wakeup();
        for (i = 0; i < this.m_readHandlers.length; ++i) {
            try {
                this.m_readHandlers[i].add(new Shutdown());
                continue;
            }
            catch (InterruptedException e) {
                LOG.error(JGroupsStrings.ConnectionTableNIO_THREAD__0__WAS_INTERRUPTED_FAILED_TO_SHUTDOWN_SELECTOR, Thread.currentThread().getName(), (Throwable)e);
            }
        }
        for (i = 0; i < this.m_writeHandlers.length; ++i) {
            try {
                this.m_writeHandlers[i].QUEUE.put(new Shutdown());
                this.m_writeHandlers[i].m_selector.wakeup();
                continue;
            }
            catch (InterruptedException e) {
                LOG.error(JGroupsStrings.ConnectionTableNIO_THREAD__0__WAS_INTERRUPTED_FAILED_TO_SHUTDOWN_SELECTOR, Thread.currentThread().getName(), (Throwable)e);
            }
        }
        if (this.m_requestProcessors instanceof PooledExecutor) {
            ((PooledExecutor)this.m_requestProcessors).shutdownNow();
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Connection conn = null;
        block21: while (this.m_serverSocketChannel.isOpen()) {
            SystemFailure.checkFailure();
            int num = 0;
            try {
                num = this.m_acceptSelector.select();
            }
            catch (IOException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Select operation on listening socket failed", e);
                continue;
            }
            if (num <= 0) continue;
            Set<SelectionKey> readyKeys = this.m_acceptSelector.selectedKeys();
            Iterator<SelectionKey> i = readyKeys.iterator();
            while (i.hasNext()) {
                int idx;
                Object object;
                SocketChannel client_sock_ch;
                block35: {
                    block34: {
                        SelectionKey key2 = i.next();
                        i.remove();
                        ServerSocketChannel readyChannel = (ServerSocketChannel)key2.channel();
                        client_sock_ch = null;
                        try {
                            client_sock_ch = readyChannel.accept();
                        }
                        catch (IOException e) {
                            if (!LOG.isWarnEnabled()) continue;
                            LOG.warn("Attempt to accept new connection from listening socket failed", e);
                            continue;
                        }
                        if (LOG.isInfoEnabled()) {
                            LOG.info(JGroupsStrings.ConnectionTableNIO_ACCEPTED_CONNECTION_CLIENT_SOCK_0, client_sock_ch.socket());
                        }
                        try {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("About to change new connection send buff size from " + client_sock_ch.socket().getSendBufferSize() + " bytes");
                            }
                            client_sock_ch.socket().setSendBufferSize(this.send_buf_size);
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Changed new connection send buff size to " + client_sock_ch.socket().getSendBufferSize() + " bytes");
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error("exception setting send buffer size to " + this.send_buf_size + " bytes: ", (Throwable)ex);
                            }
                        }
                        catch (SocketException e) {
                            if (!this.log.isErrorEnabled()) break block34;
                            this.log.error("exception setting send buffer size to " + this.send_buf_size + " bytes: ", (Throwable)e);
                        }
                    }
                    try {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("About to change new connection receive buff size from " + client_sock_ch.socket().getReceiveBufferSize() + " bytes");
                        }
                        client_sock_ch.socket().setReceiveBufferSize(this.recv_buf_size);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Changed new connection receive buff size to " + client_sock_ch.socket().getReceiveBufferSize() + " bytes");
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error("exception setting receive buffer size to " + this.send_buf_size + " bytes: ", (Throwable)ex);
                        }
                    }
                    catch (SocketException e) {
                        if (!this.log.isErrorEnabled()) break block35;
                        this.log.error("exception setting receive buffer size to " + this.recv_buf_size + " bytes: ", (Throwable)e);
                    }
                }
                conn = new Connection(client_sock_ch, null);
                try {
                    client_sock_ch.configureBlocking(false);
                    object = this.m_lockNextWriteHandler;
                    synchronized (object) {
                        idx = this.m_nextWriteHandler = (this.m_nextWriteHandler + 1) % this.m_writeHandlers.length;
                    }
                    conn.setupWriteHandler(this.m_writeHandlers[idx]);
                }
                catch (IOException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Attempt to configure accepted connection failed", e);
                    }
                    conn.destroy();
                    continue;
                }
                catch (InterruptedException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Attempt to configure accepted connection was interrupted", e);
                    }
                    conn.destroy();
                    break block21;
                }
                try {
                    object = this.m_lockNextReadHandler;
                    synchronized (object) {
                        idx = this.m_nextReadHandler = (this.m_nextReadHandler + 1) % this.m_readHandlers.length;
                    }
                    this.m_readHandlers[idx].add(conn);
                }
                catch (InterruptedException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Attempt to configure read handler for accepted connection failed", e);
                    }
                    conn.destroy();
                    break block21;
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("acceptor thread terminated");
        }
    }

    @Override
    protected ServerSocket createServerSocket(int start_port, int end_port) throws Exception {
        this.m_acceptSelector = Selector.open();
        this.m_serverSocketChannel = ServerSocketChannel.open();
        this.m_serverSocketChannel.configureBlocking(false);
        while (true) {
            try {
                if (this.bind_addr == null) {
                    this.m_serverSocketChannel.socket().bind(new InetSocketAddress(start_port));
                    break;
                }
                this.m_serverSocketChannel.socket().bind(new InetSocketAddress(this.bind_addr, start_port), 20);
            }
            catch (BindException bind_ex) {
                if (start_port == end_port) {
                    throw (BindException)new BindException("No available port to bind to").initCause(bind_ex);
                }
                ++start_port;
                continue;
            }
            catch (SocketException bind_ex) {
                if (start_port == end_port) {
                    throw (BindException)new BindException("No available port to bind to").initCause(bind_ex);
                }
                ++start_port;
                continue;
            }
            catch (IOException io_ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(JGroupsStrings.ConnectionTableNIO_ATTEMPT_TO_BIND_SERVERSOCKET_FAILED_PORT_0__BIND_ADDR_1, new Object[]{start_port, this.bind_addr}, (Throwable)io_ex);
                }
                throw io_ex;
            }
            break;
        }
        this.srv_port = start_port;
        this.m_serverSocketChannel.register(this.m_acceptSelector, 16);
        return this.m_serverSocketChannel.socket();
    }

    public static class WriteRequest {
        private final SocketChannel m_channel;
        private final ByteBuffer m_buffer;
        private final FutureResult m_callback;
        private final SelectorWriteHandler m_hdlr;

        WriteRequest(SocketChannel channel, ByteBuffer buffer, FutureResult callback, SelectorWriteHandler hdlr) {
            this.m_channel = channel;
            this.m_buffer = buffer;
            this.m_callback = callback;
            this.m_hdlr = hdlr;
        }

        SelectorWriteHandler getHandler() {
            return this.m_hdlr;
        }

        SocketChannel getChannel() {
            return this.m_channel;
        }

        ByteBuffer getBuffer() {
            return this.m_buffer;
        }

        FutureResult getCallback() {
            return this.m_callback;
        }
    }

    public static class SelectorWriteHandler {
        private final LinkedList m_writeRequests = new LinkedList();
        private boolean m_headerSent = false;
        private SocketChannel m_channel;
        private SelectionKey m_key;
        private Selector m_selector;
        private int m_bytesWritten = 0;
        private boolean m_enabled = false;
        private ByteBuffer m_headerBuffer;

        SelectorWriteHandler(SocketChannel channel, Selector selector, ByteBuffer headerBuffer) {
            this.m_channel = channel;
            this.m_selector = selector;
            this.m_headerBuffer = headerBuffer;
        }

        private void register(Selector selector, SocketChannel channel) throws ClosedChannelException {
            this.m_key = channel.register(selector, 0, this);
        }

        private boolean enable() {
            boolean rc = false;
            try {
                if (this.m_key == null) {
                    this.register(this.m_selector, this.m_channel);
                }
            }
            catch (ClosedChannelException e) {
                return rc;
            }
            if (!this.m_enabled) {
                rc = true;
                try {
                    this.m_key.interestOps(4);
                }
                catch (CancelledKeyException e) {
                    return false;
                }
                this.m_enabled = true;
            }
            return rc;
        }

        private void disable() {
            if (this.m_enabled) {
                try {
                    this.m_key.interestOps(0);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    // empty catch block
                }
                this.m_enabled = false;
            }
        }

        protected void cancel() {
            this.m_key.cancel();
        }

        boolean add(WriteRequest entry) {
            this.m_writeRequests.add(entry);
            return this.enable();
        }

        WriteRequest getCurrentRequest() {
            return (WriteRequest)this.m_writeRequests.getFirst();
        }

        SocketChannel getChannel() {
            return this.m_channel;
        }

        ByteBuffer getBuffer() {
            return this.getCurrentRequest().getBuffer();
        }

        FutureResult getCallback() {
            return this.getCurrentRequest().getCallback();
        }

        int getBytesWritten() {
            return this.m_bytesWritten;
        }

        void notifyError(Throwable error) {
            if (this.getCallback() != null) {
                this.getCallback().setException(error);
            }
        }

        void notifyObject(Object result) {
            if (this.getCallback() != null) {
                this.getCallback().set(result);
            }
        }

        boolean next() {
            boolean rc;
            this.m_headerSent = false;
            this.m_bytesWritten = 0;
            this.m_writeRequests.removeFirst();
            boolean bl = rc = !this.m_writeRequests.isEmpty();
            if (!rc) {
                this.disable();
            }
            return rc;
        }

        int write() throws IOException {
            if (!this.m_headerSent) {
                this.m_headerSent = true;
                this.m_headerBuffer.clear();
                this.m_headerBuffer.putInt(this.getBuffer().remaining());
                this.m_headerBuffer.flip();
                do {
                    this.getChannel().write(this.m_headerBuffer);
                } while (this.m_headerBuffer.remaining() > 0);
            }
            this.m_bytesWritten += this.getChannel().write(this.getBuffer());
            return this.getBuffer().remaining();
        }
    }

    private static class WriteHandler
    implements Runnable {
        protected final LinkedQueue QUEUE = new LinkedQueue();
        protected Selector m_selector;
        private int m_pendingChannels;
        private ByteBuffer m_headerBuffer = ByteBuffer.allocate(4);

        private WriteHandler() {
        }

        protected static WriteHandler[] create(int workerThreads) {
            WriteHandler[] handlers = new WriteHandler[workerThreads];
            for (int looper = 0; looper < workerThreads; ++looper) {
                block3: {
                    handlers[looper] = new WriteHandler();
                    try {
                        handlers[looper].m_selector = SelectorProvider.provider().openSelector();
                    }
                    catch (IOException e) {
                        if (!LOG.isErrorEnabled()) break block3;
                        LOG.error(e);
                    }
                }
                Thread thread = new Thread((Runnable)handlers[looper], "nioWriteHandlerThread");
                thread.setDaemon(true);
                thread.start();
            }
            return handlers;
        }

        protected SelectorWriteHandler add(SocketChannel channel) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            SelectorWriteHandler hdlr = new SelectorWriteHandler(channel, this.m_selector, this.m_headerBuffer);
            return hdlr;
        }

        protected void write(SocketChannel channel, ByteBuffer buffer, FutureResult notification, SelectorWriteHandler hdlr) throws InterruptedException {
            this.QUEUE.put(new WriteRequest(channel, buffer, notification, hdlr));
        }

        private void close(SelectorWriteHandler entry) {
            entry.cancel();
        }

        private void handleChannelError(Selector selector, SelectorWriteHandler entry, SelectionKey selKey, Throwable error) {
            do {
                if (error == null) continue;
                entry.notifyError(error);
            } while (entry.next());
            this.close(entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processWrite(Selector selector) {
            Set<SelectionKey> keys = selector.selectedKeys();
            Object[] arr = keys.toArray();
            for (int looper = 0; looper < arr.length; ++looper) {
                SelectionKey key2 = (SelectionKey)arr[looper];
                SelectorWriteHandler entry = (SelectorWriteHandler)key2.attachment();
                boolean needToDecrementPendingChannels = false;
                try {
                    if (0 != entry.write()) continue;
                    entry.notifyObject(entry.getBytesWritten());
                    if (entry.next()) continue;
                    needToDecrementPendingChannels = true;
                    continue;
                }
                catch (IOException e) {
                    needToDecrementPendingChannels = true;
                    this.handleChannelError(selector, entry, key2, e);
                    continue;
                }
                finally {
                    if (needToDecrementPendingChannels) {
                        --this.m_pendingChannels;
                    }
                }
            }
            keys.clear();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (this.m_selector.isOpen()) {
                SystemFailure.checkFailure();
                try {
                    WriteRequest queueEntry;
                    Object o;
                    while (null != (o = this.QUEUE.poll(0L))) {
                        if (o instanceof Shutdown) {
                            return;
                        }
                        queueEntry = (WriteRequest)o;
                        if (queueEntry.getHandler().add(queueEntry)) {
                            ++this.m_pendingChannels;
                        }
                        try {
                            if (this.m_selector.selectNow() <= 0) continue;
                            this.processWrite(this.m_selector);
                        }
                        catch (IOException e) {
                            if (!LOG.isErrorEnabled()) return;
                            LOG.error(JGroupsStrings.ConnectionTableNIO_SELECTNOW_OPERATION_ON_WRITE_SELECTOR_FAILED_DIDNT_EXPECT_THIS_TO_OCCUR_PLEASE_REPORT_THIS, (Throwable)e);
                            return;
                        }
                    }
                    if (this.m_pendingChannels == 0) {
                        o = this.QUEUE.take();
                        if (o instanceof Shutdown) {
                            return;
                        }
                        queueEntry = (WriteRequest)o;
                        if (!queueEntry.getHandler().add(queueEntry)) continue;
                        ++this.m_pendingChannels;
                        continue;
                    }
                    try {
                        if (this.m_selector.select() <= 0) continue;
                        this.processWrite(this.m_selector);
                    }
                    catch (IOException e) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error(JGroupsStrings.ConnectionTableNIO_FAILURE_WHILE_WRITING_TO_SOCKET, (Throwable)e);
                    }
                }
                catch (InterruptedException e) {
                    if (!LOG.isErrorEnabled()) return;
                    LOG.error(JGroupsStrings.ConnectionTableNIO_THREAD__0__WAS_INTERRUPTED, Thread.currentThread().getName(), (Throwable)e);
                    return;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable e) {
                    SystemFailure.checkFailure();
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error(JGroupsStrings.ConnectionTableNIO_THREAD__0__CAUGHT_THROWABLE, Thread.currentThread().getName(), e);
                }
            }
        }
    }

    class Connection
    extends ConnectionTable.Connection {
        protected SocketChannel sock_ch;
        private WriteHandler m_writeHandler;
        private SelectorWriteHandler m_selectorWriteHandler;
        private final ConnectionReadState m_readState;
        private static final int HEADER_SIZE = 4;
        final ByteBuffer headerBuffer;

        Connection(SocketChannel s, Address peer_addr) {
            super(s.socket(), peer_addr);
            this.sock_ch = null;
            this.headerBuffer = ByteBuffer.allocate(4);
            this.sock_ch = s;
            this.m_readState = new ConnectionReadState(this);
            this.m_readState.init();
        }

        protected ConnectionReadState getReadState() {
            return this.m_readState;
        }

        protected void setupWriteHandler(WriteHandler hdlr) throws InterruptedException {
            this.m_writeHandler = hdlr;
            this.m_selectorWriteHandler = hdlr.add(this.sock_ch);
        }

        @Override
        void destroy() {
            this.closeSocket();
        }

        @Override
        void doSend(byte[] buffie, int offset, int length) throws Exception {
            FutureResult result = new FutureResult();
            this.m_writeHandler.write(this.sock_ch, ByteBuffer.wrap(buffie, offset, length), result, this.m_selectorWriteHandler);
            InvocationTargetException ex = result.getException();
            if (ex != null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(JGroupsStrings.ConnectionTableNIO_FAILED_SENDING_MESSAGE, (Throwable)ex);
                }
                if (((Throwable)ex).getCause() instanceof IOException) {
                    throw (IOException)((Throwable)ex).getCause();
                }
                throw ex;
            }
            result.get();
        }

        SocketChannel getSocketChannel() {
            return this.sock_ch;
        }

        @Override
        void closeSocket() {
            if (this.sock_ch != null) {
                try {
                    if (this.sock_ch.isConnected()) {
                        this.sock_ch.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sock_ch = null;
            }
        }
    }

    private class ConnectionReadState {
        private final Connection m_conn;
        private int m_handShakingStatus = 0;
        static final int HANDSHAKINGFIN = 99;
        private final ByteBuffer m_handShakingBufFixed = ByteBuffer.allocate(8);
        private ByteBuffer m_handShakingBufDynamic = null;
        private boolean m_headFinished = false;
        private ByteBuffer m_readBodyBuf = null;
        private final ByteBuffer m_readHeadBuf = ByteBuffer.allocate(4);

        public ConnectionReadState(Connection conn) {
            this.m_conn = conn;
        }

        protected void init() {
            this.m_handShakingBufFixed.clear();
            this.m_handShakingBufFixed.limit(8);
        }

        ByteBuffer getHandShakingBufferFixed() {
            return this.m_handShakingBufFixed;
        }

        ByteBuffer getHandShakingBufferDynamic() {
            return this.m_handShakingBufDynamic;
        }

        ByteBuffer getReadBodyBuffer() {
            return this.m_readBodyBuf;
        }

        ByteBuffer getReadHeadBuffer() {
            return this.m_readHeadBuf;
        }

        void bodyFinished() {
            this.m_headFinished = false;
            this.m_readHeadBuf.clear();
            this.m_readBodyBuf = null;
            this.m_conn.updateLastAccessed();
        }

        int headFinished() {
            this.m_headFinished = true;
            this.m_readHeadBuf.flip();
            int messageSize = this.m_readHeadBuf.getInt();
            this.m_readBodyBuf = ByteBuffer.allocate(messageSize);
            this.m_conn.updateLastAccessed();
            return messageSize;
        }

        boolean isHeadFinished() {
            return this.m_headFinished;
        }

        void handShakingStep1Finished() throws IOException {
            this.m_handShakingStatus = 1;
            InetAddress clientIP = this.m_conn.sock_ch.socket().getInetAddress();
            int clientPort = this.m_conn.sock_ch.socket().getPort();
            this.m_handShakingBufFixed.flip();
            byte[] bytesCookie = new byte[ConnectionTableNIO.this.cookie.length];
            this.m_handShakingBufFixed.get(bytesCookie);
            if (!this.m_conn.matchCookie(bytesCookie)) {
                throw new SocketException("ConnectionTable.Connection.readPeerAddress(): cookie received from " + clientIP + ":" + clientPort + " does not match own cookie; terminating connection");
            }
            short ver = this.m_handShakingBufFixed.getShort();
            if (!JGroupsVersion.compareTo(ver) && LOG.isWarnEnabled()) {
                LOG.warn(new StringBuffer("packet from ").append(clientIP).append(':').append(clientPort).append(" has different version (").append(ver).append(") from ours (").append(22920).append("). This may cause problems"));
            }
            short len = this.m_handShakingBufFixed.getShort();
            this.m_handShakingBufDynamic = ByteBuffer.allocate(len + 4 + 1);
        }

        void handShakingStep2Finished() throws IOException {
            boolean ifAddition;
            this.m_handShakingStatus = 2;
            this.m_handShakingBufDynamic.flip();
            byte[] ip = new byte[this.m_handShakingBufDynamic.remaining() - 4 - 1];
            this.m_handShakingBufDynamic.get(ip);
            InetAddress addr = InetAddress.getByAddress(ip);
            int port = this.m_handShakingBufDynamic.getInt();
            this.m_conn.peer_addr = new IpAddress(addr, port);
            boolean bl = ifAddition = this.m_handShakingBufDynamic.get() != 0;
            if (!ifAddition) {
                this.m_handShakingStatus = 99;
                return;
            }
            this.m_handShakingBufFixed.clear();
            this.m_handShakingBufFixed.limit(4);
        }

        void handShakingStep3Finished() {
            this.m_handShakingStatus = 3;
            this.m_handShakingBufFixed.flip();
            int len = this.m_handShakingBufFixed.getInt();
            if (0 == len) {
                this.m_handShakingStatus = 99;
                return;
            }
            this.m_handShakingBufDynamic = ByteBuffer.allocate(len);
        }

        void handShakingStep4Finished() {
            this.m_handShakingStatus = 99;
            this.m_handShakingBufDynamic.flip();
            byte[] addition = new byte[this.m_handShakingBufDynamic.remaining()];
            this.m_handShakingBufDynamic.get(addition);
            ((IpAddress)this.m_conn.peer_addr).setAdditionalData(addition);
        }

        int getHandShakingStatus() {
            return this.m_handShakingStatus;
        }

        void setHandShakingStatus(int s) {
            this.m_handShakingStatus = s;
        }
    }

    private class ExecuteTask
    implements Runnable {
        Address m_addr = null;
        ByteBuffer m_buf = null;

        public ExecuteTask(Address addr, ByteBuffer buf) {
            this.m_addr = addr;
            this.m_buf = buf;
        }

        @Override
        public void run() {
            ConnectionTableNIO.this.receive(this.m_addr, this.m_buf.array(), this.m_buf.arrayOffset(), this.m_buf.limit());
        }
    }

    private class ReadHandler
    implements Runnable {
        private Selector m_readSelector = null;
        private Thread m_th = null;
        private LinkedQueue m_queueNewConns = new LinkedQueue();

        public ReadHandler() {
            try {
                this.m_readSelector = Selector.open();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalStateException(e.getMessage());
            }
            this.m_th = new Thread(null, this, "nioReadSelectorThread");
            this.m_th.setDaemon(true);
            this.m_th.start();
        }

        protected void add(Object conn) throws InterruptedException {
            this.m_queueNewConns.put(conn);
            this.wakeup();
        }

        private void wakeup() {
            this.m_readSelector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                HashMap hashMap;
                Address peerAddr;
                SystemFailure.checkFailure();
                int events = 0;
                try {
                    events = this.m_readSelector.select();
                }
                catch (IOException e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn("Select operation on socket failed", e);
                    continue;
                }
                catch (ClosedSelectorException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Select operation on socket failed", e);
                    }
                    return;
                }
                if (events > 0) {
                    Set<SelectionKey> readyKeys = this.m_readSelector.selectedKeys();
                    Iterator<SelectionKey> i = readyKeys.iterator();
                    while (i.hasNext()) {
                        SelectionKey key2 = i.next();
                        i.remove();
                        Connection conn = (Connection)key2.attachment();
                        try {
                            if (conn.getSocketChannel().isOpen()) {
                                this.readOnce(conn);
                                continue;
                            }
                            peerAddr = conn.getPeerAddress();
                            hashMap = ConnectionTableNIO.this.conns;
                            synchronized (hashMap) {
                                ConnectionTableNIO.this.conns.remove(peerAddr);
                            }
                            ConnectionTableNIO.this.notifyConnectionClosed(peerAddr);
                        }
                        catch (IOException e) {
                            if (LOG.isInfoEnabled()) {
                                LOG.info(JGroupsStrings.ConnectionTableNIO_READ_OPERATION_ON_SOCKET_FAILED, (Throwable)e);
                            }
                            Address peerAddr2 = conn.getPeerAddress();
                            key2.cancel();
                            conn.destroy();
                            HashMap hashMap2 = ConnectionTableNIO.this.conns;
                            synchronized (hashMap2) {
                                ConnectionTableNIO.this.conns.remove(peerAddr2);
                            }
                            ConnectionTableNIO.this.notifyConnectionClosed(peerAddr2);
                        }
                    }
                }
                Object o = null;
                try {
                    o = this.m_queueNewConns.poll(0L);
                }
                catch (InterruptedException e) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info(JGroupsStrings.ConnectionTableNIO_THREAD__0__WAS_INTERRUPTED_WHILE_POLLING_QUEUE, new Object[]{Thread.currentThread().getName()}, e);
                    }
                    return;
                }
                if (null == o) continue;
                if (o instanceof Shutdown) {
                    return;
                }
                Connection conn = (Connection)o;
                SocketChannel sc = conn.getSocketChannel();
                try {
                    sc.register(this.m_readSelector, 1, conn);
                    continue;
                }
                catch (ClosedChannelException e) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info(JGroupsStrings.ConnectionTableNIO_SOCKET_CHANNEL_WAS_CLOSED_WHILE_WE_WERE_TRYING_TO_REGISTER_IT_TO_SELECTOR, (Throwable)e);
                    }
                    peerAddr = conn.getPeerAddress();
                    conn.destroy();
                    hashMap = ConnectionTableNIO.this.conns;
                    synchronized (hashMap) {
                        ConnectionTableNIO.this.conns.remove(peerAddr);
                    }
                    ConnectionTableNIO.this.notifyConnectionClosed(peerAddr);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void readOnce(Connection conn) throws IOException {
            int size2;
            ConnectionReadState readState = conn.getReadState();
            if (readState.getHandShakingStatus() != 99) {
                if (!this.readForHandShaking(conn)) {
                    return;
                }
                HashMap hashMap = ConnectionTableNIO.this.conns;
                synchronized (hashMap) {
                    if (ConnectionTableNIO.this.conns.containsKey(conn.getPeerAddress())) {
                        if (!conn.getPeerAddress().equals(ConnectionTableNIO.this.getLocalAddress())) {
                            if (!LOG.isWarnEnabled()) throw new IOException(conn.getPeerAddress() + " is already there, terminate");
                            LOG.warn(conn.getPeerAddress() + " is already there, will terminate connection");
                            throw new IOException(conn.getPeerAddress() + " is already there, terminate");
                        }
                        if (LOG.isWarnEnabled()) {
                            LOG.warn(conn.getPeerAddress() + " is myself, not put it in table twice, but still read from it");
                        }
                    } else {
                        ConnectionTableNIO.this.addConnection(conn.getPeerAddress(), conn);
                    }
                }
                ConnectionTableNIO.this.notifyConnectionOpened(conn.getPeerAddress());
            }
            if (!readState.isHeadFinished() && 0 == (size2 = this.readHeader(conn))) {
                return;
            }
            if (this.readBody(conn) > 0) {
                return;
            }
            Address addr = conn.getPeerAddress();
            ByteBuffer buf = readState.getReadBodyBuffer();
            readState.bodyFinished();
            try {
                ConnectionTableNIO.this.m_requestProcessors.execute(new ExecuteTask(addr, buf));
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error(JGroupsStrings.ConnectionTableNIO_THREAD__0__WAS_INTERRUPTED_WHILE_ASSIGNING_EXECUTOR_TO_PROCESS_READ_REQUEST, Thread.currentThread().getName(), (Throwable)e);
            }
        }

        private int read(Connection conn, ByteBuffer buf) throws IOException {
            SocketChannel sc = conn.getSocketChannel();
            int num = sc.read(buf);
            if (-1 == num) {
                throw new IOException("Couldn't read from socket as peer closed the socket");
            }
            return buf.remaining();
        }

        private boolean readForHandShaking(Connection conn) throws IOException {
            ConnectionReadState readState = conn.getReadState();
            int i = readState.getHandShakingStatus();
            switch (i) {
                case 0: {
                    ByteBuffer handBuf = readState.getHandShakingBufferFixed();
                    if (this.read(conn, handBuf) != 0) {
                        return false;
                    }
                    readState.handShakingStep1Finished();
                }
                case 1: {
                    ByteBuffer handBuf = readState.getHandShakingBufferDynamic();
                    if (this.read(conn, handBuf) != 0) {
                        return false;
                    }
                    readState.handShakingStep2Finished();
                }
                case 2: {
                    if (99 == readState.getHandShakingStatus()) {
                        return true;
                    }
                    ByteBuffer handBuf = readState.getHandShakingBufferFixed();
                    if (this.read(conn, handBuf) != 0) {
                        return false;
                    }
                    readState.handShakingStep3Finished();
                }
                case 3: {
                    if (99 == readState.getHandShakingStatus()) {
                        return true;
                    }
                    ByteBuffer handBuf = readState.getHandShakingBufferDynamic();
                    if (this.read(conn, handBuf) != 0) {
                        return false;
                    }
                    readState.handShakingStep4Finished();
                    return true;
                }
            }
            return true;
        }

        private int readHeader(Connection conn) throws IOException {
            ConnectionReadState readState = conn.getReadState();
            ByteBuffer headBuf = readState.getReadHeadBuffer();
            SocketChannel sc = conn.getSocketChannel();
            while (headBuf.remaining() > 0) {
                int num = sc.read(headBuf);
                if (-1 == num) {
                    throw new IOException("Peer closed socket");
                }
                if (0 != num) continue;
                return 0;
            }
            return readState.headFinished();
        }

        private int readBody(Connection conn) throws IOException {
            ByteBuffer bodyBuf = conn.getReadState().getReadBodyBuffer();
            SocketChannel sc = conn.getSocketChannel();
            while (bodyBuf.remaining() > 0) {
                int num = sc.read(bodyBuf);
                if (-1 == num) {
                    throw new IOException("Couldn't read from socket as peer closed the socket");
                }
                if (0 != num) continue;
                return bodyBuf.remaining();
            }
            bodyBuf.flip();
            return 0;
        }
    }

    protected static class Shutdown {
        protected Shutdown() {
        }
    }
}

