/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Membership;
import com.gemstone.org.jgroups.ViewId;
import com.gemstone.org.jgroups.protocols.pbcast.Digest;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.Util;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class View
implements Externalizable,
Cloneable,
Streamable,
DataSerializableFixedID {
    protected ViewId vid;
    protected Vector members;
    private Object additionalData;
    private int additionalDataSize;
    private Set suspectedMembers;
    private Digest messageDigest;

    public View() {
    }

    public View(ViewId vid, Vector members) {
        this.vid = vid;
        this.members = members;
    }

    public View(Address creator, long id, Vector members) {
        this(new ViewId(creator, id), members);
    }

    public View(Address creator, long id, Vector members, Vector suspectedMembers) {
        this(new ViewId(creator, id), members);
        if (suspectedMembers != null) {
            this.suspectedMembers = new HashSet(suspectedMembers);
        }
    }

    public ViewId getVid() {
        return this.vid;
    }

    public Address getCreator() {
        return this.vid != null ? this.vid.getCoordAddress() : null;
    }

    public Address getCoordinator() {
        if (this.members.size() < 1) {
            return null;
        }
        return new Membership(this.members).getCoordinator();
    }

    public Vector getMembers() {
        return this.members;
    }

    public Set getSuspectedMembers() {
        return this.suspectedMembers == null ? Collections.EMPTY_SET : this.suspectedMembers;
    }

    public Object getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Object data) {
        this.additionalData = data;
        try {
            ByteArrayOutputStream bas = new ByteArrayOutputStream(10000);
            ObjectOutputStream oos = new ObjectOutputStream(bas);
            oos.writeObject(data);
            this.additionalDataSize = bas.size();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean containsMember(Address mbr) {
        if (mbr == null || this.members == null) {
            return false;
        }
        return this.members.contains(mbr);
    }

    public void notSuspect(Address mbr) {
        this.suspectedMembers.remove(mbr);
    }

    public Address getMember(Address addr) {
        int sz = this.members.size();
        for (int i = sz - 1; i > 0; --i) {
            Address mbr = (Address)this.members.get(i);
            if (!mbr.equals(addr)) continue;
            return mbr;
        }
        return addr;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.vid != null) {
            if (!(obj instanceof View)) {
                return false;
            }
            int rc = this.vid.compareTo(((View)obj).vid);
            if (rc != 0) {
                return false;
            }
            if (this.members != null && ((View)obj).members != null) {
                return this.members.equals(((View)obj).members);
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        if (this.vid != null) {
            result += this.vid.hashCode();
            if (this.members != null) {
                result += this.members.hashCode();
            }
        }
        return result;
    }

    public int size() {
        return this.members == null ? 0 : this.members.size();
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public Object clone() {
        ViewId vid2 = this.vid != null ? (ViewId)this.vid.clone() : null;
        Vector members2 = this.members != null ? (Vector)this.members.clone() : null;
        View result = new View(vid2, members2);
        if (this.suspectedMembers != null) {
            result.suspectedMembers = new HashSet(this.suspectedMembers);
        }
        if (this.additionalData != null) {
            result.additionalData = this.additionalData;
            result.additionalDataSize = this.additionalDataSize;
        }
        return result;
    }

    public String printDetails() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.vid).append("\n\t");
        if (this.members != null) {
            for (int i = 0; i < this.members.size(); ++i) {
                ret.append(this.members.elementAt(i)).append("\n\t");
            }
            ret.append('\n');
        }
        return ret.toString();
    }

    private String memberName(Address m) {
        if (!(m instanceof IpAddress)) {
            return m.toString();
        }
        IpAddress im = (IpAddress)m;
        StringBuffer sb = new StringBuffer();
        sb.append(im.toString());
        int port = im.getDirectPort();
        if (port > 0) {
            sb.append('/');
            sb.append(port);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(64);
        ret.append(this.vid);
        ret.append(" [");
        Iterator iter = this.members.iterator();
        while (iter.hasNext()) {
            Address member = (Address)iter.next();
            ret.append(this.memberName(member));
            if (!iter.hasNext()) continue;
            ret.append(", ");
        }
        if (this.additionalData != null) {
            ret.append(this.additionalData);
        }
        ret.append("]");
        if (this.suspectedMembers != null && this.suspectedMembers.size() > 0) {
            ret.append(" crashed mbrs: [");
            Iterator it = this.suspectedMembers.iterator();
            while (it.hasNext()) {
                ret.append(this.memberName((Address)it.next()));
                if (!it.hasNext()) continue;
                ret.append(", ");
            }
            ret.append(']');
        }
        return ret.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.vid);
        out.writeObject(this.members);
        out.writeObject(this.suspectedMembers);
        out.writeInt(this.additionalDataSize);
        out.writeObject(this.additionalData);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.vid = (ViewId)in.readObject();
        this.members = (Vector)in.readObject();
        this.suspectedMembers = (Set)in.readObject();
        this.additionalDataSize = in.readInt();
        this.additionalData = in.readObject();
    }

    public Address getLeadMember() {
        for (int i = 0; i < this.members.size(); ++i) {
            Address mbr = (Address)this.members.get(i);
            if (((IpAddress)mbr).getVmKind() != 10) continue;
            return mbr;
        }
        return null;
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        InternalDataSerializer.invokeToData(this, out);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (this.vid != null) {
            out.writeBoolean(true);
            InternalDataSerializer.invokeToData(this.vid, out);
        } else {
            out.writeBoolean(false);
        }
        DataSerializer.writeObject(this.members, out);
        if (this.suspectedMembers == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            DataSerializer.writeObject(this.suspectedMembers, out);
        }
        DataSerializer.writeObject(this.messageDigest, out);
        out.writeInt(this.additionalDataSize);
        DataSerializer.writeObject(this.additionalData, out);
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        try {
            InternalDataSerializer.invokeFromData(this, in);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalAccessException(JGroupsStrings.View_COULD_NOT_READ_ADDITIONAL_DATA_0.toLocalizedString(ex));
        }
    }

    @Override
    public int getDSFID() {
        return 1;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        boolean b = in.readBoolean();
        if (b) {
            this.vid = new ViewId();
            InternalDataSerializer.invokeFromData(this.vid, in);
        }
        this.members = (Vector)DataSerializer.readObject(in);
        if (in.readBoolean()) {
            this.suspectedMembers = (Set)DataSerializer.readObject(in);
        }
        this.messageDigest = (Digest)DataSerializer.readObject(in);
        this.additionalDataSize = in.readInt();
        this.additionalData = DataSerializer.readObject(in);
    }

    public int serializedSize(short version) {
        int retval = 1;
        if (this.vid != null) {
            retval += this.vid.serializedSize(version);
        }
        retval = (int)((long)retval + Util.size(this.members, version));
        if (this.suspectedMembers != null) {
            retval = (int)((long)retval + Util.size(this.suspectedMembers, version));
        }
        if (this.additionalData != null) {
            retval += this.additionalDataSize;
        }
        return retval;
    }

    public void setMessageDigest(Digest messageDigest) {
        this.messageDigest = messageDigest;
    }

    public Digest getMessageDigest() {
        return this.messageDigest;
    }
}

