/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.UnsupportedVersionException;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataInputStream;
import com.gemstone.gemfire.internal.VersionedDataOutputStream;
import com.gemstone.gemfire.internal.VersionedObjectInput;
import com.gemstone.gemfire.internal.VersionedObjectOutput;
import com.gemstone.gemfire.internal.cache.DirectReplyMessage;
import com.gemstone.gemfire.internal.cache.DistributedCacheOperation;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.conf.ClassConfigurator;
import com.gemstone.org.jgroups.oswego.concurrent.ConcurrentReaderHashMap;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;

public class Message
implements Externalizable,
Streamable {
    public static volatile short multicastVersion = Version.GFE_71.ordinal();
    protected Address dest_addr = null;
    protected Address src_addr = null;
    private byte[] buf = null;
    protected transient int offset = 0;
    protected transient int length = 0;
    protected Map headers;
    private short version;
    protected static final GemFireTracer log = GemFireTracer.getLog(Message.class);
    static final long serialVersionUID = -1137364035832847034L;
    static final byte DEST_SET = 1;
    static final byte SRC_SET = 2;
    static final byte BUF_SET = 4;
    static final byte IPADDR_DEST = 16;
    static final byte IPADDR_SRC = 32;
    static final byte SRC_HOST_NULL = 64;
    static final byte CACHE_OP = 1;
    static final byte HIGH_PRIORITY = 8;
    static final HashSet nonStreamableHeaders = new HashSet();
    public transient boolean bundleable;
    public transient long timeStamp;
    public boolean isCacheOperation;
    public boolean isHighPriority;
    public transient boolean isJoinResponse;

    public Message(Address dest, Address src, byte[] buf) {
        this.dest_addr = dest;
        this.src_addr = src;
        this.setBuffer(buf);
        this.headers = this.createHeaders(7);
    }

    public Message(Address dest, Address src, byte[] buf, int offset, int length) {
        this.dest_addr = dest;
        this.src_addr = src;
        this.setBuffer(buf, offset, length);
        this.headers = this.createHeaders(7);
    }

    public void setIsDistributedCacheOperation(boolean flag) {
        this.isCacheOperation = flag;
    }

    public boolean getIsDistributedCacheOperation() {
        return this.isCacheOperation;
    }

    public boolean isHighPriority() {
        return this.isHighPriority;
    }

    public Message(Address dest, Address src, Serializable obj) {
        this.dest_addr = dest;
        this.src_addr = src;
        this.setObject(obj);
        this.headers = this.createHeaders(7);
    }

    public Message(DistributionMessage gfmsg, Address src, short version) {
        if (gfmsg instanceof DirectReplyMessage) {
            ((DirectReplyMessage)((Object)gfmsg)).registerProcessor();
        }
        this.dest_addr = null;
        this.src_addr = src;
        this.version = version;
        this.setGFMessage(gfmsg, Version.fromOrdinalOrCurrent(version));
        this.headers = this.createHeaders(7);
        if (gfmsg instanceof DistributedCacheOperation.CacheOperationMessage) {
            DistributedCacheOperation.CacheOperationMessage cmsg = (DistributedCacheOperation.CacheOperationMessage)gfmsg;
            this.isCacheOperation = true;
            if (cmsg.getProcessorId() == 0 && cmsg.getMulticast()) {
                this.bundleable = true;
            }
        }
        boolean bl = this.isHighPriority = gfmsg.getProcessorType() == 75 || gfmsg instanceof HighPriorityDistributionMessage;
        if (this.isHighPriority) {
            this.bundleable = false;
        }
    }

    public Message() {
        this.headers = this.createHeaders(7);
    }

    public Message(boolean create_headers) {
        if (create_headers) {
            this.headers = this.createHeaders(7);
        }
    }

    public Address getDest() {
        return this.dest_addr;
    }

    public void setDest(Address new_dest) {
        this.dest_addr = Message.canonicalAddress(new_dest);
    }

    public Address getSrc() {
        return this.src_addr;
    }

    public void setSrc(Address new_src) {
        this.src_addr = Message.canonicalAddress(new_src);
    }

    public byte[] getRawBuffer() {
        return this.buf;
    }

    public byte[] getBuffer() {
        if (this.buf == null) {
            return null;
        }
        if (this.offset == 0 && this.length == this.buf.length) {
            return this.buf;
        }
        byte[] retval = new byte[this.length];
        System.arraycopy(this.buf, this.offset, retval, 0, this.length);
        return retval;
    }

    public void setBuffer(byte[] b) {
        this.buf = b;
        if (this.buf != null) {
            this.offset = 0;
            this.length = this.buf.length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
    }

    public void setBuffer(byte[] b, int offset, int length) {
        this.buf = b;
        if (this.buf != null) {
            if (offset < 0 || offset > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            if (offset + length > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset + length);
            }
            this.offset = offset;
            this.length = length;
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Map getHeaders() {
        return this.headers;
    }

    public Version getDestVersion() {
        if (this.version > 0) {
            return Version.fromOrdinalOrCurrent(this.version);
        }
        Version result = Version.CURRENT;
        if (this.dest_addr != null && !this.dest_addr.isMulticastAddress()) {
            if (this.dest_addr.getVersionOrdinal() < Version.CURRENT_ORDINAL) {
                result = Version.fromOrdinalOrCurrent(this.dest_addr.getVersionOrdinal());
            }
        } else {
            result = Version.fromOrdinalOrCurrent(multicastVersion);
        }
        return result;
    }

    public void setObject(Serializable obj) {
        if (obj == null) {
            return;
        }
        try {
            ByteArrayOutputStream out_stream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(out_stream);
            Version destVersion = this.getDestVersion();
            if (destVersion != null && !destVersion.equals(Version.CURRENT)) {
                out = new VersionedDataOutputStream(out, destVersion);
            }
            DataSerializer.writeObject(obj, out);
            this.setBuffer(out_stream.toByteArray());
        }
        catch (IOException ex) {
            IllegalArgumentException ia = new IllegalArgumentException("Error serializing message");
            ia.initCause(ex);
            throw ia;
        }
    }

    public void setGFMessage(DistributionMessage obj, Version version) {
        if (obj == null) {
            return;
        }
        try {
            HeapDataOutputStream out_stream = new HeapDataOutputStream(version);
            DataSerializer.writeObject(obj, out_stream);
            this.setBuffer(out_stream.toByteArray());
        }
        catch (IOException ex) {
            IllegalArgumentException ia = new IllegalArgumentException("Error serializing message");
            ia.initCause(ex);
            throw ia;
        }
    }

    public <T> T getObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            ByteArrayInputStream in_stream = new ByteArrayInputStream(this.buf, this.offset, this.length);
            return DataSerializer.readObject(new DataInputStream(in_stream));
        }
        catch (Exception ex) {
            IllegalArgumentException e = new IllegalArgumentException(ex.toString());
            e.initCause(ex);
            throw e;
        }
    }

    public void reset() {
        this.src_addr = null;
        this.dest_addr = null;
        this.setBuffer(null);
        this.headers.clear();
    }

    public void putHeader(String key2, Header hdr) {
        this.headers.put(key2, hdr);
    }

    public Header removeHeader(String key2) {
        return (Header)this.headers.remove(key2);
    }

    public void removeHeaders() {
        this.headers.clear();
    }

    public <T> T getHeader(String key2) {
        return (T)this.headers.get(key2);
    }

    public Message copy() {
        return this.copy(true);
    }

    public Message copy(boolean copy_buffer) {
        Message retval = new Message(false);
        retval.dest_addr = this.dest_addr;
        retval.src_addr = this.src_addr;
        if (copy_buffer && this.buf != null) {
            retval.setBuffer(this.buf, this.offset, this.length);
        }
        retval.headers = this.createHeaders(this.headers);
        retval.bundleable = this.bundleable;
        retval.timeStamp = this.timeStamp;
        retval.isCacheOperation = this.isCacheOperation;
        retval.isHighPriority = this.isHighPriority;
        retval.version = this.version;
        return retval;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public Message makeReply() {
        return new Message(this.src_addr, null, null);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(64);
        ret.append("[dst: ");
        if (this.dest_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.dest_addr);
        }
        ret.append(", src: ");
        if (this.src_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.src_addr);
        }
        ret.append(", oob=" + this.isHighPriority);
        ret.append(", size=");
        ret.append(String.valueOf(this.size()));
        ret.append(']');
        if (this.headers != null) {
            for (Map.Entry entry : this.headers.entrySet()) {
                ret.append(", ").append(entry.getKey()).append(": ").append(entry.getValue());
            }
        }
        return ret.toString();
    }

    public short getVersion() {
        return this.version;
    }

    public void setVersion(short v) {
        this.version = v;
    }

    public String toStringAsObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            Object obj = this.getObject();
            return obj != null ? obj.toString() : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public long size() {
        long retval = 1 + this.length + (this.buf != null ? 4 : 0);
        short destVersion = this.version;
        if (destVersion == 0) {
            destVersion = Version.CURRENT_ORDINAL;
        }
        if (this.dest_addr != null && 0 < this.dest_addr.getVersionOrdinal() && this.dest_addr.getVersionOrdinal() < destVersion) {
            destVersion = this.dest_addr.getVersionOrdinal();
        }
        if (this.src_addr != null) {
            retval += (long)this.src_addr.size(destVersion);
        }
        retval += 2L;
        for (Map.Entry entry : this.headers.entrySet()) {
            String key2 = (String)entry.getKey();
            retval += (long)(key2.length() + 2);
            Header hdr = (Header)entry.getValue();
            retval += 5L;
            retval += hdr.size(destVersion);
        }
        if (this.dest_addr == null || this.dest_addr.isMulticastAddress()) {
            retval += (long)Version.uncompressedSize();
        }
        return ++retval;
    }

    public String printObjectHeaders() {
        StringBuffer sb = new StringBuffer();
        if (this.headers != null) {
            for (Map.Entry entry : this.headers.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
            }
        }
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException("messages are not externalizable");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("messages are not externalizable");
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        short destVersion;
        int leading = 0;
        short serVersion = Version.CURRENT_ORDINAL;
        if (0 < this.version && this.version < serVersion) {
            serVersion = this.version;
        } else if (this.dest_addr != null && 0 < (destVersion = this.dest_addr.getVersionOrdinal()) && destVersion < Version.CURRENT_ORDINAL) {
            serVersion = destVersion;
        }
        if (0 < serVersion && serVersion < Version.CURRENT_ORDINAL) {
            out = new VersionedDataOutputStream(out, Version.fromOrdinalNoThrow(serVersion, false));
        }
        Version.writeOrdinal(out, serVersion, true);
        if (this.src_addr != null) {
            leading = (byte)(leading + 2);
            if (this.src_addr instanceof IpAddress) {
                leading = (byte)(leading + 32);
                if (((IpAddress)this.src_addr).getIpAddress() == null) {
                    leading = (byte)(leading + 64);
                }
            }
        }
        if (this.buf != null) {
            leading = (byte)(leading + 4);
        }
        out.write(leading);
        if (this.src_addr != null) {
            if (this.src_addr instanceof IpAddress) {
                InternalDataSerializer.invokeToData((IpAddress)this.src_addr, out);
            } else {
                Util.writeAddress(this.src_addr, out);
            }
        }
        int gfFlags = 0;
        if (this.isCacheOperation) {
            gfFlags = (byte)(gfFlags + 1);
        }
        if (this.isHighPriority) {
            gfFlags = (byte)(gfFlags + 8);
        }
        out.write(gfFlags);
        if (this.buf != null) {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
        int size2 = this.headers.size();
        out.writeShort(size2);
        for (Map.Entry entry : this.headers.entrySet()) {
            out.writeUTF((String)entry.getKey());
            ByteArrayOutputStream baos = new ByteArrayOutputStream(50);
            DataOutputStream hdos = 0 < serVersion && serVersion < Version.CURRENT_ORDINAL ? new VersionedDataOutputStream(baos, Version.fromOrdinalNoThrow(serVersion, false)) : new DataOutputStream(baos);
            this.writeHeader((Header)entry.getValue(), hdos);
            hdos.flush();
            byte[] headerBytes = baos.toByteArray();
            out.writeInt(headerBytes.length);
            out.write(headerBytes);
        }
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        int len;
        byte gfFlags;
        byte leading;
        Header hdr = null;
        this.version = Version.readOrdinal(in);
        if (0 < this.version && this.version < Version.CURRENT_ORDINAL) {
            try {
                in = new VersionedDataInputStream(in, Version.fromOrdinal(this.version, false));
            }
            catch (UnsupportedVersionException e) {
                throw new IOException("Unexpected exception during deserialization", e);
            }
        }
        if (((leading = in.readByte()) & 2) == 2) {
            if ((leading & 0x20) == 32) {
                this.src_addr = new IpAddress();
                try {
                    InternalDataSerializer.invokeFromData((IpAddress)this.src_addr, in);
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            } else {
                this.src_addr = Util.readAddress(in);
            }
        }
        if (((gfFlags = in.readByte()) & 1) != 0) {
            this.isCacheOperation = true;
        }
        if ((gfFlags & 8) != 0) {
            this.isHighPriority = true;
        }
        if ((leading & 4) == 4) {
            len = in.readInt();
            try {
                this.buf = new byte[len];
            }
            catch (OutOfMemoryError e) {
                System.err.println("JGroups#Message: unable to allocate buffer of size " + len + "; gfFlags = " + gfFlags + "; src_addr = " + this.src_addr);
                throw e;
            }
            in.readFully(this.buf, 0, len);
            this.length = len;
        }
        len = in.readShort();
        this.headers = this.createHeaders(len);
        for (int i = 0; i < len; ++i) {
            DataInputStream dis;
            String hdr_name = in.readUTF();
            int hlen = in.readInt();
            byte[] headerBytes = new byte[hlen];
            in.readFully(headerBytes);
            ByteArrayInputStream bais = new ByteArrayInputStream(headerBytes);
            if (0 < this.version && this.version < Version.CURRENT_ORDINAL) {
                try {
                    dis = new VersionedDataInputStream(bais, Version.fromOrdinal(this.version, false));
                }
                catch (UnsupportedVersionException e) {
                    throw new IOException("Unexpected exception during deserialization", e);
                }
            } else {
                dis = new DataInputStream(bais);
            }
            try {
                hdr = this.readHeader(dis);
                this.headers.put(hdr_name, hdr);
                continue;
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error("Failed to deserialize a header " + hdr_name + " of length " + hlen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeader(Header value2, DataOutputStream out) throws IOException {
        try (ObjectOutput oos = null;){
            int magic_number = ClassConfigurator.getInstance(false).getMagicNumber(value2.getClass());
            if (magic_number == -1) {
                out.writeBoolean(false);
                String classname = value2.getClass().getName();
                out.writeUTF(classname);
            } else {
                out.writeBoolean(true);
                out.writeInt(magic_number);
            }
            if (value2 instanceof Streamable) {
                ((Streamable)((Object)value2)).writeTo(out);
            } else {
                Version v;
                oos = new ObjectOutputStream(out);
                if (out instanceof VersionedDataOutputStream && (v = ((VersionedDataOutputStream)out).getVersion()) != null && v != Version.CURRENT) {
                    oos = new VersionedObjectOutput(oos, v);
                }
                value2.writeExternal(oos);
                if (!nonStreamableHeaders.contains(value2.getClass())) {
                    nonStreamableHeaders.add(value2.getClass());
                    if (log.isTraceEnabled()) {
                        log.trace("encountered non-Streamable header: " + value2.getClass());
                    }
                }
            }
        }
    }

    private Header readHeader(DataInputStream in) throws IOException {
        Header hdr;
        boolean use_magic_number = in.readBoolean();
        ObjectInput ois = null;
        try {
            Class clazz;
            if (use_magic_number) {
                int magic_number = in.readInt();
                clazz = ClassConfigurator.getInstance(false).get(magic_number);
                if (clazz == null) {
                    log.error(JGroupsStrings.Message_MAGIC_NUMBER__0__IS_NOT_AVAILABLE_IN_MAGIC_MAP, magic_number);
                }
            } else {
                String classname = in.readUTF();
                clazz = ClassConfigurator.getInstance(false).get(classname);
            }
            if ((hdr = (Header)clazz.newInstance()) instanceof Streamable) {
                ((Streamable)((Object)hdr)).readFrom(in);
            } else {
                ois = new ObjectInputStream(in);
                if (in instanceof VersionedDataInputStream) {
                    ois = new VersionedObjectInput(ois, ((VersionedDataInputStream)in).getVersion());
                }
                hdr.readExternal(ois);
            }
        }
        catch (Exception ex) {
            IOException e = new IOException(JGroupsStrings.Message_FAILED_TO_READ_HEADER.toLocalizedString());
            e.initCause(ex);
            throw e;
        }
        return hdr;
    }

    private Map createHeaders(int size2) {
        return size2 > 0 ? new ConcurrentReaderHashMap(size2) : new ConcurrentReaderHashMap();
    }

    private Map createHeaders(Map m) {
        return new ConcurrentReaderHashMap(m);
    }

    private static Address canonicalAddress(Address nonCanonicalAddress) {
        return nonCanonicalAddress;
    }

    public void dumpPayload() {
        try {
            DataInputStream di = new DataInputStream(new ByteArrayInputStream(this.buf, this.offset, this.length));
            Object o = DataSerializer.readObject(di);
            log.getInternalLogWriter().warning(JGroupsStrings.Message_MESSAGEDUMPPAYLOAD__0, o);
        }
        catch (Exception e) {
            log.warn("message.dumpPayload error: " + e.getMessage());
        }
    }
}

