/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups;

import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Vector;

public class Membership
implements Cloneable {
    public static final boolean FLOATING_COORD_DISABLED = Boolean.getBoolean("gemfire.disable-floating-coordinator");
    private final LinkedList members = new LinkedList();
    protected static final GemFireTracer log = GemFireTracer.getLog(Membership.class);

    public Membership() {
    }

    public Membership(Collection initial_members) {
        if (initial_members != null) {
            this.add(initial_members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getMembers() {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            return new Vector(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Address new_member) {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            if (new_member != null && !this.members.contains(new_member)) {
                this.members.add(new_member);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Collection v) {
        if (v != null) {
            LinkedList linkedList = this.members;
            synchronized (linkedList) {
                HashSet currentMembers = new HashSet(this.members);
                for (Address addr : v) {
                    if (currentMembers.contains(addr)) continue;
                    this.members.add(addr);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Address old_member) {
        if (old_member != null) {
            LinkedList linkedList = this.members;
            synchronized (linkedList) {
                this.members.remove(old_member);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Collection v) {
        if (v != null) {
            LinkedList linkedList = this.members;
            synchronized (linkedList) {
                this.members.removeAll(v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            this.members.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Collection v) {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            this.clear();
            if (v != null) {
                this.add(v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Membership m) {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            this.clear();
            if (m != null) {
                this.add(m.getMembers());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(Collection new_mems, Collection suspects) {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            this.remove(suspects);
            this.add(new_mems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Address member) {
        if (member == null) {
            return false;
        }
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            return this.members.contains(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsExt(Address member) {
        if (member == null || !(member instanceof IpAddress)) {
            return false;
        }
        IpAddress pmbr = (IpAddress)member;
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            for (IpAddress each : this.members) {
                if (!each.equals(pmbr) || each.getBirthViewId() != pmbr.getBirthViewId()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort() {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            Collections.sort(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership copy() {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            return (Membership)this.clone();
        }
    }

    public Object clone() {
        return new Membership(this.members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            return this.members.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object elementAt(int index2) {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            return this.members.get(index2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address getCoordinator() {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            for (Address addr : this.members) {
                if (!addr.preferredForCoordinator()) continue;
                return addr;
            }
            if (this.members.size() > 0) {
                return (Address)this.members.get(0);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wouldBeNewCoordinator(Address possible) {
        Address coord = null;
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            for (Address a : this.members) {
                if (!a.preferredForCoordinator()) continue;
                if (coord == null) {
                    coord = a;
                    continue;
                }
                return a.equals(possible);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            return this.members.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOtherCoordinators(Vector suspects) {
        LinkedList linkedList = this.members;
        synchronized (linkedList) {
            for (Address a : this.members) {
                if (!a.preferredForCoordinator() || suspects.contains(a)) continue;
                return true;
            }
        }
        return false;
    }
}

