/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.ChannelClosedException;
import com.gemstone.org.jgroups.ChannelException;
import com.gemstone.org.jgroups.ChannelListener;
import com.gemstone.org.jgroups.ChannelNotConnectedException;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.Receiver;
import com.gemstone.org.jgroups.TimeoutException;
import com.gemstone.org.jgroups.Transport;
import com.gemstone.org.jgroups.UpHandler;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public abstract class Channel
implements Transport {
    public static final int BLOCK = 0;
    public static final int VIEW = 1;
    public static final int SUSPECT = 2;
    public static final int LOCAL = 3;
    public static final int GET_STATE_EVENTS = 4;
    public static final int AUTO_RECONNECT = 5;
    public static final int AUTO_GETSTATE = 6;
    protected UpHandler up_handler = null;
    protected ChannelListener channel_listener = null;
    protected Set channel_listeners = null;
    protected Receiver receiver = null;

    protected abstract GemFireTracer getLog();

    public abstract void connect(String var1) throws ChannelException, ChannelClosedException;

    public abstract void disconnect();

    public abstract void close();

    public abstract void shutdown();

    public void open() throws ChannelException {
    }

    public abstract boolean isOpen();

    public abstract boolean isConnected();

    public int getNumMessages() {
        return -1;
    }

    public String dumpQueue() {
        return "";
    }

    public abstract Map dumpStats();

    @Override
    public abstract void send(Message var1) throws ChannelNotConnectedException, ChannelClosedException;

    public abstract void send(Address var1, Address var2, Serializable var3) throws ChannelNotConnectedException, ChannelClosedException;

    public void down(Event evt) {
    }

    @Override
    public abstract Object receive(long var1) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException;

    public abstract Object peek(long var1) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException;

    public abstract View getView();

    public abstract Address getLocalAddress();

    public abstract String getChannelName();

    public void setUpHandler(UpHandler up_handler) {
        this.up_handler = up_handler;
    }

    @Deprecated
    public void setChannelListener(ChannelListener channel_listener) {
        this.addChannelListener(channel_listener);
    }

    public synchronized void addChannelListener(ChannelListener listener) {
        if (listener == null) {
            return;
        }
        if (this.channel_listeners == null) {
            this.channel_listeners = new LinkedHashSet();
        }
        this.channel_listeners.add(listener);
    }

    public synchronized void removeChannelListener(ChannelListener listener) {
        if (this.channel_listeners != null) {
            this.channel_listeners.remove(listener);
        }
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public abstract void setOpt(int var1, Object var2);

    public abstract Object getOpt(int var1);

    public abstract void blockOk();

    public abstract boolean getState(Address var1, long var2) throws ChannelNotConnectedException, ChannelClosedException;

    public abstract boolean closing();

    public abstract boolean getAllStates(Vector var1, long var2) throws ChannelNotConnectedException, ChannelClosedException;

    public abstract void returnState(byte[] var1);

    public static String option2String(int option) {
        switch (option) {
            case 0: {
                return "BLOCK";
            }
            case 1: {
                return "VIEW";
            }
            case 2: {
                return "SUSPECT";
            }
            case 3: {
                return "LOCAL";
            }
            case 4: {
                return "GET_STATE_EVENTS";
            }
            case 5: {
                return "AUTO_RECONNECT";
            }
            case 6: {
                return "AUTO_GETSTATE";
            }
        }
        return "unknown (" + option + ')';
    }

    protected void notifyChannelConnected(Channel c) {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelConnected(c);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.getLog().error(JGroupsStrings.Channel_EXCEPTION_IN_CHANNELCONNECTED_CALLBACK, t);
            }
        }
    }

    protected void notifyChannelDisconnected(Channel c) {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelDisconnected(c);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.getLog().error(JGroupsStrings.Channel_EXCEPTION_IN_CHANNELDISONNECTED_CALLBACK, t);
            }
        }
    }

    protected void notifyChannelClosed(Channel c) {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelClosed(c);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.getLog().error(JGroupsStrings.Channel_EXCEPTION_IN_CHANNELCLOSED_CALLBACK, t);
            }
        }
    }

    protected void notifyChannelShunned() {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelShunned();
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.getLog().error(JGroupsStrings.Channel_EXCEPTION_IN_CHANNELSHUNNED_CALLBACK, t);
            }
        }
    }

    protected void notifyChannelReconnected(Address addr) {
        if (this.channel_listeners == null) {
            return;
        }
        for (ChannelListener channelListener : this.channel_listeners) {
            try {
                channelListener.channelReconnected(addr);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                this.getLog().error(JGroupsStrings.Channel_EXCEPTION_IN_CHANNELRECONNECTED_CALLBACK, t);
            }
        }
    }
}

