/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.TIterator;
import com.gemstone.gnu.trove.TStatelessLongHash;
import java.util.ConcurrentModificationException;

public class TStatelessLongIterator
extends TIterator {
    private final TStatelessLongHash _hash;

    public TStatelessLongIterator(TStatelessLongHash hash) {
        super(hash);
        this._hash = hash;
    }

    public long next() {
        this.moveToNextIndex();
        return this._hash._set[this._index];
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        long[] set = this._hash._set;
        long FREE = this._hash.getFreeValue();
        int i = this._index;
        while (i-- > 0 && set[i] == FREE) {
        }
        return i;
    }
}

