/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.TIntHashingStrategy;
import com.gemstone.gnu.trove.TIntProcedure;
import com.gemstone.gnu.trove.TStatelessIntHash;
import com.gemstone.gnu.trove.TStatelessIntIterator;
import java.util.Arrays;

public class TStatelessIntHashSet
extends TStatelessIntHash {
    public TStatelessIntHashSet(int freeValue) {
        super(freeValue);
    }

    public TStatelessIntHashSet(int freeValue, int initialCapacity) {
        super(freeValue, initialCapacity);
    }

    public TStatelessIntHashSet(int freeValue, int initialCapacity, float loadFactor) {
        super(freeValue, initialCapacity, loadFactor);
    }

    public TStatelessIntHashSet(int freeValue, int[] array) {
        this(freeValue, array.length);
        this.addAll(array);
    }

    public TStatelessIntHashSet(int freeValue, TIntHashingStrategy strategy) {
        super(freeValue, strategy);
    }

    public TStatelessIntHashSet(int freeValue, int initialCapacity, TIntHashingStrategy strategy) {
        super(freeValue, initialCapacity, strategy);
    }

    public TStatelessIntHashSet(int freeValue, int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super(freeValue, initialCapacity, loadFactor, strategy);
    }

    public TStatelessIntHashSet(int freeValue, int[] array, TIntHashingStrategy strategy) {
        this(freeValue, array.length, strategy);
        this.addAll(array);
    }

    public TStatelessIntIterator iterator() {
        return new TStatelessIntIterator(this);
    }

    public boolean add(int val) {
        int index2 = this.insertionIndex(val);
        if (index2 < 0) {
            return false;
        }
        int previousState = this._set[index2];
        this._set[index2] = val;
        this.postInsertHook(previousState == this._FREE);
        return true;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldSet = this._set;
        this._set = new int[newCapacity];
        if (this._FREE != 0) {
            Arrays.fill(this._set, this._FREE);
        }
        int i = oldCapacity;
        while (i-- > 0) {
            int o = oldSet[i];
            if (o == this._FREE) continue;
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
        }
    }

    public int[] toArray() {
        int[] result = new int[this.size()];
        int[] set = this._set;
        int i = set.length;
        int j = 0;
        while (i-- > 0) {
            int o = set[i];
            if (o == this._FREE) continue;
            result[j++] = o;
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this._set, this._FREE);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TStatelessIntHashSet)) {
            return false;
        }
        final TStatelessIntHashSet that = (TStatelessIntHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TIntProcedure(){

            @Override
            public final boolean execute(int value2) {
                return that.contains(value2);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean containsAll(int[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(int[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    protected final class HashProcedure
    implements TIntProcedure {
        private int h = 0;

        protected HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(int key2) {
            this.h += TStatelessIntHashSet.this._hashingStrategy.computeHashCode(key2);
            return true;
        }
    }
}

