/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.HashFunctions;
import com.gemstone.gnu.trove.TIntHashingStrategy;
import com.gemstone.gnu.trove.TIntProcedure;
import com.gemstone.gnu.trove.TPrimitiveHash;
import java.io.Serializable;

public abstract class TIntHash
extends TPrimitiveHash
implements Serializable,
TIntHashingStrategy {
    protected transient int[] _set;
    protected TIntHashingStrategy _hashingStrategy;

    public TIntHash() {
        this._hashingStrategy = this;
    }

    public TIntHash(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TIntHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TIntHash(TIntHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TIntHash(int initialCapacity, TIntHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TIntHash(int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public Object clone() {
        TIntHash h = (TIntHash)super.clone();
        h._set = (int[])this._set.clone();
        return h;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new int[capacity];
        return capacity;
    }

    public boolean contains(int val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TIntProcedure procedure) {
        byte[] states2 = this._states;
        int[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (states2[i] != 1 || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void removeAt(int index2) {
        super.removeAt(index2);
        this._set[index2] = 0;
    }

    protected int index(int val) {
        byte[] states2 = this._states;
        int[] set = this._set;
        int length = states2.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (states2[index2] != 0 && (states2[index2] == 2 || set[index2] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while (states2[index2] != 0 && (states2[index2] == 2 || set[index2] != val));
        }
        return states2[index2] == 0 ? -1 : index2;
    }

    protected int insertionIndex(int val) {
        byte[] states2 = this._states;
        int[] set = this._set;
        int length = states2.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (states2[index2] == 0) {
            return index2;
        }
        if (states2[index2] == 1 && set[index2] == val) {
            return -index2 - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (states2[index2] != 2) {
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while (states2[index2] == 1 && set[index2] != val);
        }
        if (states2[index2] == 2) {
            int firstRemoved = index2;
            while (states2[index2] != 0 && (states2[index2] == 2 || set[index2] != val)) {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            }
            return states2[index2] == 1 ? -index2 - 1 : firstRemoved;
        }
        return states2[index2] == 1 ? -index2 - 1 : index2;
    }

    @Override
    public final int computeHashCode(int val) {
        return HashFunctions.hash(val);
    }
}

