/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.SerializationProcedure;
import com.gemstone.gnu.trove.TObjectHash;
import com.gemstone.gnu.trove.TObjectHashIterator;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.gemstone.gnu.trove.TObjectProcedure;
import com.gemstone.gnu.trove.ToObjectArrayProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class THashSet
extends TObjectHash
implements Set,
Serializable {
    private static final long serialVersionUID = 2705415913937015662L;

    public THashSet() {
    }

    public THashSet(TObjectHashingStrategy strategy) {
        super(strategy);
    }

    public THashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public THashSet(int initialCapacity, TObjectHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public THashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public THashSet(int initialCapacity, float loadFactor, TObjectHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public THashSet(Collection collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public THashSet(Collection collection, TObjectHashingStrategy strategy) {
        this(collection.size(), strategy);
        this.addAll(collection);
    }

    @Override
    public boolean add(Object obj) {
        int index2 = this.insertionIndex(obj);
        if (index2 < 0) {
            return false;
        }
        Object old = this._set[index2];
        this._set[index2] = obj;
        this.postInsertHook(old == null);
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.containsAll((Collection)that);
    }

    @Override
    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldSet = this._set;
        this._set = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldSet[i] == null || oldSet[i] == REMOVED) continue;
            Object o = oldSet[i];
            int index2 = this.insertionIndex(o);
            if (index2 < 0) {
                this.throwObjectContractViolation(this._set[-index2 - 1], o);
            }
            this._set[index2] = o;
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        this.forEach(new ToObjectArrayProcedure(result));
        return result;
    }

    @Override
    public Object[] toArray(Object[] a) {
        int size2 = this.size();
        if (a.length < size2) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size2);
        }
        this.forEach(new ToObjectArrayProcedure(a));
        Iterator it = this.iterator();
        for (int i = 0; i < size2; ++i) {
            a[i] = it.next();
        }
        if (a.length > size2) {
            a[size2] = null;
        }
        return a;
    }

    @Override
    public void clear() {
        super.clear();
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            set[i] = null;
        }
    }

    @Override
    public boolean remove(Object obj) {
        int index2 = this.index(obj);
        if (index2 >= 0) {
            this.removeAt(index2);
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new TObjectHashIterator(this);
    }

    @Override
    public boolean containsAll(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        boolean changed = false;
        int size2 = collection.size();
        this.ensureCapacity(size2);
        Iterator it = collection.iterator();
        while (size2-- > 0) {
            if (!this.add(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean changed = false;
        int size2 = collection.size();
        Iterator it = collection.iterator();
        while (size2-- > 0) {
            if (!this.remove(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection collection) {
        boolean changed = false;
        int size2 = this.size();
        Iterator it = this.iterator();
        while (size2-- > 0) {
            if (collection.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size2 = stream.readInt();
        this.setUp(size2);
        while (size2-- > 0) {
            Object val = stream.readObject();
            this.add(val);
        }
    }

    protected final class HashProcedure
    implements TObjectProcedure {
        private int h = 0;

        protected HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(Object key2) {
            this.h += THashSet.this._hashingStrategy.computeHashCode(key2);
            return true;
        }
    }
}

