/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx.internal;

import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.PdxInstanceFactory;
import com.gemstone.gemfire.pdx.PdxUnreadFields;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import com.gemstone.gemfire.pdx.internal.PdxOutputStream;
import com.gemstone.gemfire.pdx.internal.PdxType;
import com.gemstone.gemfire.pdx.internal.PdxWriterImpl;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.util.Date;

public class PdxInstanceFactoryImpl
implements PdxInstanceFactory {
    private final PdxWriterImpl writer;
    private boolean created = false;

    private PdxInstanceFactoryImpl(String name, boolean expectDomainClass) {
        PdxOutputStream os = new PdxOutputStream();
        PdxType pt = new PdxType(name, expectDomainClass);
        GemFireCacheImpl gfc = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.");
        TypeRegistry tr = gfc.getPdxRegistry();
        this.writer = new PdxWriterImpl(pt, tr, os);
    }

    public static PdxInstanceFactory newCreator(String name, boolean expectDomainClass) {
        return new PdxInstanceFactoryImpl(name, expectDomainClass);
    }

    @Override
    public PdxInstance create() {
        if (this.created) {
            throw new IllegalStateException("The create method can only be called once.");
        }
        this.created = true;
        this.writer.completeByteStreamGeneration();
        return this.writer.makePdxInstance();
    }

    @Override
    public PdxInstanceFactory writeChar(String fieldName, char value2) {
        this.writer.writeChar(fieldName, value2);
        return this;
    }

    @Override
    public PdxInstanceFactory writeBoolean(String fieldName, boolean value2) {
        this.writer.writeBoolean(fieldName, value2);
        return this;
    }

    @Override
    public PdxInstanceFactory writeByte(String fieldName, byte value2) {
        this.writer.writeByte(fieldName, value2);
        return this;
    }

    @Override
    public PdxInstanceFactory writeShort(String fieldName, short value2) {
        this.writer.writeShort(fieldName, value2);
        return this;
    }

    @Override
    public PdxInstanceFactory writeInt(String fieldName, int value2) {
        this.writer.writeInt(fieldName, value2);
        return this;
    }

    @Override
    public PdxInstanceFactory writeLong(String fieldName, long value2) {
        this.writer.writeLong(fieldName, value2);
        return this;
    }

    @Override
    public PdxInstanceFactory writeFloat(String fieldName, float value2) {
        this.writer.writeFloat(fieldName, value2);
        return this;
    }

    @Override
    public PdxInstanceFactory writeDouble(String fieldName, double value2) {
        this.writer.writeDouble(fieldName, value2);
        return this;
    }

    @Override
    public PdxInstanceFactory writeDate(String fieldName, Date date) {
        this.writer.writeDate(fieldName, date);
        return this;
    }

    @Override
    public PdxInstanceFactory writeString(String fieldName, String value2) {
        this.writer.writeString(fieldName, value2);
        return this;
    }

    @Override
    public PdxInstanceFactory writeObject(String fieldName, Object object) {
        return this.writeObject(fieldName, object, false);
    }

    @Override
    public PdxInstanceFactory writeBooleanArray(String fieldName, boolean[] array) {
        this.writer.writeBooleanArray(fieldName, array);
        return this;
    }

    @Override
    public PdxInstanceFactory writeCharArray(String fieldName, char[] array) {
        this.writer.writeCharArray(fieldName, array);
        return this;
    }

    @Override
    public PdxInstanceFactory writeByteArray(String fieldName, byte[] array) {
        this.writer.writeByteArray(fieldName, array);
        return this;
    }

    @Override
    public PdxInstanceFactory writeShortArray(String fieldName, short[] array) {
        this.writer.writeShortArray(fieldName, array);
        return this;
    }

    @Override
    public PdxInstanceFactory writeIntArray(String fieldName, int[] array) {
        this.writer.writeIntArray(fieldName, array);
        return this;
    }

    @Override
    public PdxInstanceFactory writeLongArray(String fieldName, long[] array) {
        this.writer.writeLongArray(fieldName, array);
        return this;
    }

    @Override
    public PdxInstanceFactory writeFloatArray(String fieldName, float[] array) {
        this.writer.writeFloatArray(fieldName, array);
        return this;
    }

    @Override
    public PdxInstanceFactory writeDoubleArray(String fieldName, double[] array) {
        this.writer.writeDoubleArray(fieldName, array);
        return this;
    }

    @Override
    public PdxInstanceFactory writeStringArray(String fieldName, String[] array) {
        this.writer.writeStringArray(fieldName, array);
        return this;
    }

    @Override
    public PdxInstanceFactory writeObjectArray(String fieldName, Object[] array) {
        return this.writeObjectArray(fieldName, array, false);
    }

    public PdxInstanceFactory writeUnreadFields(PdxUnreadFields unread) {
        this.writer.writeUnreadFields(unread);
        return this;
    }

    @Override
    public PdxInstanceFactory writeArrayOfByteArrays(String fieldName, byte[][] array) {
        this.writer.writeArrayOfByteArrays(fieldName, array);
        return this;
    }

    @Override
    public <CT, VT extends CT> PdxInstanceFactory writeField(String fieldName, VT fieldValue, Class<CT> fieldType) {
        return this.writeField(fieldName, fieldValue, fieldType, false);
    }

    @Override
    public PdxInstanceFactory markIdentityField(String fieldName) {
        this.writer.markIdentityField(fieldName);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PdxInstanceFactory writeObject(String fieldName, Object value2, boolean checkPortability) {
        if (InternalDataSerializer.is662SerializationEnabled()) {
            boolean alreadyInProgress = InternalDataSerializer.isPdxSerializationInProgress();
            if (!alreadyInProgress) {
                InternalDataSerializer.setPdxSerializationInProgress(true);
                try {
                    this.writer.writeObject(fieldName, value2, checkPortability);
                }
                finally {
                    InternalDataSerializer.setPdxSerializationInProgress(false);
                }
            } else {
                this.writer.writeObject(fieldName, value2, checkPortability);
            }
        } else {
            this.writer.writeObject(fieldName, value2, checkPortability);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PdxInstanceFactory writeObjectArray(String fieldName, Object[] value2, boolean checkPortability) {
        if (InternalDataSerializer.is662SerializationEnabled()) {
            boolean alreadyInProgress = InternalDataSerializer.isPdxSerializationInProgress();
            if (!alreadyInProgress) {
                InternalDataSerializer.setPdxSerializationInProgress(true);
                try {
                    this.writer.writeObjectArray(fieldName, value2, checkPortability);
                }
                finally {
                    InternalDataSerializer.setPdxSerializationInProgress(false);
                }
            } else {
                this.writer.writeObjectArray(fieldName, value2, checkPortability);
            }
        } else {
            this.writer.writeObjectArray(fieldName, value2, checkPortability);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <CT, VT extends CT> PdxInstanceFactory writeField(String fieldName, VT fieldValue, Class<CT> fieldType, boolean checkPortability) {
        if (InternalDataSerializer.is662SerializationEnabled()) {
            boolean alreadyInProgress = InternalDataSerializer.isPdxSerializationInProgress();
            if (!alreadyInProgress) {
                InternalDataSerializer.setPdxSerializationInProgress(true);
                try {
                    this.writer.writeField(fieldName, fieldValue, fieldType, checkPortability);
                }
                finally {
                    InternalDataSerializer.setPdxSerializationInProgress(false);
                }
            } else {
                this.writer.writeField(fieldName, fieldValue, fieldType, checkPortability);
            }
        } else {
            this.writer.writeField(fieldName, fieldValue, fieldType, checkPortability);
        }
        return this;
    }

    public static PdxInstance createPdxEnum(String className, String enumName, int enumOrdinal, GemFireCacheImpl gfc) {
        if (className == null) {
            throw new IllegalArgumentException("className must not be null");
        }
        if (enumName == null) {
            throw new IllegalArgumentException("enumName must not be null");
        }
        TypeRegistry tr = gfc.getPdxRegistry();
        EnumInfo ei = new EnumInfo(className, enumName, enumOrdinal);
        return ei.getPdxInstance(tr.defineEnum(ei));
    }
}

