/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.pdx.FieldType;
import com.gemstone.gemfire.pdx.PdxReader;
import com.gemstone.gemfire.pdx.PdxSerializer;
import com.gemstone.gemfire.pdx.PdxWriter;
import com.gemstone.gemfire.pdx.internal.AutoSerializableManager;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class ReflectionBasedAutoSerializer
implements PdxSerializer,
Declarable {
    private final AutoSerializableManager manager;

    public ReflectionBasedAutoSerializer() {
        this(new String[0]);
    }

    public ReflectionBasedAutoSerializer(List<String> classes) {
        this(ReflectionBasedAutoSerializer.listToArray(classes));
    }

    private static String[] listToArray(List<String> l) {
        if (l == null) {
            l = Collections.emptyList();
        }
        return l.toArray(new String[l.size()]);
    }

    public ReflectionBasedAutoSerializer(String ... patterns) {
        this(false, patterns);
    }

    public ReflectionBasedAutoSerializer(boolean checkPortability, String ... patterns) {
        this.manager = AutoSerializableManager.create(this, checkPortability, patterns);
    }

    public final void setSerializableClasses(List<String> patterns) {
        this.reconfigure(ReflectionBasedAutoSerializer.listToArray(patterns));
    }

    public final void reconfigure(String ... patterns) {
        this.reconfigure(false, patterns);
    }

    public final void reconfigure(boolean checkPortability, String ... patterns) {
        this.manager.reconfigure(checkPortability, patterns);
    }

    @Override
    public boolean toData(Object obj, PdxWriter writer) {
        return this.manager.writeData(writer, obj);
    }

    @Override
    public Object fromData(Class<?> clazz, PdxReader reader) {
        return this.manager.readData(reader, clazz);
    }

    @Override
    public void init(Properties props) {
        this.manager.init(props);
    }

    public Properties getConfig() {
        return this.manager.getConfig();
    }

    public boolean isClassAutoSerialized(Class<?> clazz) {
        return this.manager.defaultIsClassAutoSerialized(clazz);
    }

    public boolean isFieldIncluded(Field f, Class<?> clazz) {
        return this.manager.defaultIsFieldIncluded(f, clazz);
    }

    public String getFieldName(Field f, Class<?> clazz) {
        return f.getName();
    }

    public boolean isIdentityField(Field f, Class<?> clazz) {
        return this.manager.defaultIsIdentityField(f, clazz);
    }

    public FieldType getFieldType(Field f, Class<?> clazz) {
        return this.manager.defaultGetFieldType(f, clazz);
    }

    public boolean transformFieldValue(Field f, Class<?> clazz) {
        return false;
    }

    public Object writeTransform(Field f, Class<?> clazz, Object originalValue) {
        return originalValue;
    }

    public Object readTransform(Field f, Class<?> clazz, Object serializedValue) {
        return serializedValue;
    }

    public final RegionService getRegionService() {
        return this.manager.getRegionService();
    }
}

