/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.memcached;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.memcached.ConnectionHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class GemFireMemcachedServer {
    private static LogWriter logger;
    public static final String REGION_NAME = "gemcached";
    public static final String version = "0.2";
    private final String bindAddress;
    private final int serverPort;
    private final int DEFAULT_PORT = 11212;
    private ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){
        private final AtomicInteger counter = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("Gemcached-" + this.counter.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    });
    private Cache cache;
    private Thread acceptor;
    private final Protocol protocol;

    public GemFireMemcachedServer(int port) {
        this.bindAddress = "";
        this.serverPort = port <= 0 ? 11212 : port;
        this.protocol = Protocol.ASCII;
    }

    public GemFireMemcachedServer(String bindAddress, int port, Protocol protocol) {
        this.bindAddress = bindAddress;
        this.serverPort = port <= 0 ? 11212 : port;
        this.protocol = protocol;
    }

    public void start() {
        this.startGemFire();
        try {
            this.startMemcachedServer();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not start Server", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Could not start Server", e);
        }
    }

    private void startGemFire() {
        this.cache = GemFireCacheImpl.getInstance();
        if (this.cache == null) {
            CacheFactory cacheFactory = new CacheFactory();
            this.cache = cacheFactory.create();
        }
        logger = this.cache.getLogger();
    }

    private void startMemcachedServer() throws IOException, InterruptedException {
        ServerSocketChannel channel = ServerSocketChannel.open();
        final ServerSocket serverSocket = channel.socket();
        serverSocket.setReceiveBufferSize(this.getSocketBufferSize());
        serverSocket.setReuseAddress(true);
        serverSocket.bind(new InetSocketAddress(this.getBindAddress(), this.serverPort));
        if (logger.fineEnabled()) {
            logger.fine("GemFireMemcachedServer configured socket buffer size:" + this.getSocketBufferSize());
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.acceptor = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    Socket s = null;
                    try {
                        latch.countDown();
                        s = serverSocket.accept();
                        s.setKeepAlive(SocketCreator.ENABLE_TCP_KEEP_ALIVE);
                        GemFireMemcachedServer.this.handleNewClient(s);
                    }
                    catch (ClosedByInterruptException e) {
                        try {
                            serverSocket.close();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        }, "AcceptorThread");
        this.acceptor.setDaemon(true);
        this.acceptor.start();
        latch.await();
        logger.config("GemFireMemcachedServer server started on host:" + SocketCreator.getLocalHost() + " port: " + this.serverPort);
    }

    private InetAddress getBindAddress() throws UnknownHostException {
        return this.bindAddress == null || this.bindAddress.isEmpty() ? SocketCreator.getLocalHost() : InetAddress.getByName(this.bindAddress);
    }

    private int getSocketBufferSize() {
        InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
        return system.getConfig().getSocketBufferSize();
    }

    private void handleNewClient(Socket s) {
        ConnectionHandler connHandler = new ConnectionHandler(s, this.cache, this.protocol);
        this.executor.execute(connHandler);
    }

    public void shutdown() {
        if (this.acceptor != null) {
            this.acceptor.interrupt();
        }
        this.executor.shutdownNow();
        this.cache.close();
    }

    public static void main(String[] args) {
        int port = GemFireMemcachedServer.getPort(args);
        GemFireMemcachedServer server = new GemFireMemcachedServer(port);
        server.start();
        while (true) {
            try {
                while (true) {
                    System.in.read();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static int getPort(String[] args) {
        int port = 0;
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].startsWith("-port")) continue;
                String p = args[i].substring(args[i].indexOf(61));
                p = p.trim();
                port = Integer.parseInt(p);
            }
        }
        return port;
    }

    public static enum Protocol {
        ASCII,
        BINARY;

    }
}

