/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.configuration.utils;

import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlParser;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.management.internal.configuration.domain.CacheElement;
import com.gemstone.gemfire.management.internal.configuration.domain.XmlEntity;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.ValidityException;
import nu.xom.XPathContext;
import nu.xom.XPathException;
import org.apache.commons.io.FileUtils;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XmlUtils {
    private static Builder builder1;

    public static Document createDocumentFromFile(String xmlFilePath) throws IOException {
        Document doc = null;
        File xmlFile = new File(xmlFilePath);
        if (xmlFile.exists()) {
            doc = XmlUtils.createDocumentFromXml(FileUtils.readFileToString((File)xmlFile));
        }
        return doc;
    }

    public static Document createDocumentFromXml(String xmlContent) {
        return XmlUtils.createDocumentFromReader(new StringReader(xmlContent));
    }

    public static Document createDocumentFromReader(Reader reader) {
        Document doc = null;
        try {
            doc = builder1.build(reader);
        }
        catch (ValidityException e) {
            e.printStackTrace();
        }
        catch (ParsingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static Node createNode(String xmlDefintion) {
        Node node = null;
        try {
            node = builder1.build((Reader)new StringReader(xmlDefintion)).getRootElement().copy();
        }
        catch (ValidityException e) {
            e.printStackTrace();
        }
        catch (ParsingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return node;
    }

    public static String readXmlAsStringFromFile(String xmlFilePath) throws IOException {
        Document doc = null;
        doc = XmlUtils.createDocumentFromFile(xmlFilePath);
        if (doc != null) {
            return doc.toXML();
        }
        return null;
    }

    public static String prettyXml(Document doc) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Serializer serializer = new Serializer((OutputStream)out);
        serializer.setIndent(2);
        serializer.write(doc);
        return out.toString("UTF-8");
    }

    public static String prettyXml(String xmlContent) throws IOException {
        Document doc = XmlUtils.createDocumentFromXml(xmlContent);
        return XmlUtils.prettyXml(doc);
    }

    public static void deleteNode(Document doc, XmlEntity xmlEntity) throws Exception {
        Nodes nodes = XmlUtils.getNodes(doc, xmlEntity);
        if (nodes != null) {
            int length = nodes.size();
            for (int i = 0; i < length; ++i) {
                Node node = nodes.get(i);
                node.detach();
            }
        }
    }

    public static void deleteNodeOfType(Document doc, String nodeType) {
        Nodes nodes = XmlUtils.getNodesOfType(doc, nodeType);
        if (nodes != null) {
            int length = nodes.size();
            for (int i = 0; i < length; ++i) {
                Node node = nodes.get(i);
                node.detach();
            }
        }
    }

    public static Nodes getNodes(Document doc, XmlEntity xmlEntity) {
        return doc.query(xmlEntity.getSearchString(), new XPathContext(xmlEntity.getPrefix(), xmlEntity.getNamespace()));
    }

    public static Nodes getNodesOfType(Document doc, String nodeType) {
        return doc.query("//cache:" + nodeType, new XPathContext("cache", "http://schema.pivotal.io/gemfire/cache"));
    }

    public static void addNewNode(Document doc, XmlEntity xmlEntity) throws IOException {
        LinkedHashMap<String, CacheElement> elementOrderMap = CacheElement.buildElementMap(doc);
        Node newNode = XmlUtils.createNode(xmlEntity.getXmlDefinition());
        Element root = doc.getRootElement();
        int incomingElementOrder = XmlUtils.getElementOrder(elementOrderMap, xmlEntity.getNamespace(), xmlEntity.getType());
        boolean nodeAdded = false;
        int length = root.getChildCount();
        for (int i = 0; i < length; ++i) {
            Node node = root.getChild(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            String type = childElement.getLocalName();
            String namespace = childElement.getNamespaceURI();
            if (namespace.equals(xmlEntity.getNamespace()) && type.equals(xmlEntity.getType())) {
                String nameOrId = childElement.getAttributeValue("name");
                if (nameOrId == null) {
                    nameOrId = childElement.getAttributeValue("id");
                }
                if (nameOrId != null) {
                    if (!nameOrId.equals(xmlEntity.getNameOrId())) continue;
                    root.replaceChild(node, newNode);
                    nodeAdded = true;
                    break;
                }
                if (XmlUtils.isMultiple(elementOrderMap, namespace, type)) continue;
                root.replaceChild(node, newNode);
                nodeAdded = true;
                break;
            }
            if (incomingElementOrder >= XmlUtils.getElementOrder(elementOrderMap, namespace, type)) continue;
            root.insertChild(newNode, i);
            nodeAdded = true;
            break;
        }
        if (!nodeAdded) {
            root.insertChild(newNode, root.getChildCount());
        }
    }

    private static boolean isMultiple(LinkedHashMap<String, CacheElement> elementOrderMap, String namespace, String type) {
        CacheElement cacheElement;
        if ("http://schema.pivotal.io/gemfire/cache".equals(namespace) && null != (cacheElement = elementOrderMap.get(type))) {
            return cacheElement.isMultiple();
        }
        return false;
    }

    private static int getElementOrder(LinkedHashMap<String, CacheElement> elementOrderMap, String namespace, String type) {
        CacheElement cacheElement;
        if ("http://schema.pivotal.io/gemfire/cache".equals(namespace) && null != (cacheElement = elementOrderMap.get(type))) {
            return cacheElement.getOrder();
        }
        return Integer.MAX_VALUE;
    }

    public static final void changeNamespace(Node node, String oldNamespaceUri, String newNamespaceUri) {
        Nodes nodes = node.query("//*");
        for (int i = 0; i < nodes.size(); ++i) {
            Element element = (Element)nodes.get(i);
            if (!element.getNamespaceURI().equals(oldNamespaceUri)) continue;
            element.setNamespaceURI(newNamespaceUri);
        }
    }

    public static void modifyRootAttributes(Document doc, XmlEntity xmlEntity) throws IOException {
        if (xmlEntity == null || xmlEntity.getAttributes() == null) {
            return;
        }
        String type = xmlEntity.getType();
        Map<String, String> attributes = xmlEntity.getAttributes();
        Element root = doc.getRootElement();
        if (root.getLocalName().equals(type)) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attributeName = entry.getKey();
                String attributeValue = entry.getValue();
                Attribute rootAttribute = root.getAttribute(attributeName);
                if (null != rootAttribute) {
                    root.removeAttribute(rootAttribute);
                }
                Attribute newAttribute = new Attribute(attributeName, attributeValue);
                root.addAttribute(newAttribute);
            }
        }
    }

    public static Document upgradeSchema(Document document, String namespaceUri, String schemaLocation, String schemaVersion) {
        Attribute schemaLocationAttribute;
        Map<String, List<String>> schemaLocationMap;
        List<String> schemaLocations;
        String xsiPrefix;
        Element root;
        Map<String, String> namespacePrefixMap;
        String cachePrefix;
        if (StringUtils.isBlank(namespaceUri)) {
            throw new IllegalArgumentException("namespaceUri");
        }
        if (StringUtils.isBlank(schemaLocation)) {
            throw new IllegalArgumentException("schemaLocation");
        }
        if (StringUtils.isBlank(schemaVersion)) {
            throw new IllegalArgumentException("schemaVersion");
        }
        if (null != document.getDocType()) {
            document = new Document((Element)document.getRootElement().copy());
        }
        if (null == (cachePrefix = (namespacePrefixMap = XmlUtils.buildNamespacePrefixMap(root = document.getRootElement())).get(namespaceUri))) {
            cachePrefix = "";
            XmlUtils.changeNamespace((Node)root, "", namespaceUri);
            namespacePrefixMap.put(namespaceUri, cachePrefix);
        }
        if (null == (xsiPrefix = namespacePrefixMap.get("http://www.w3.org/2001/XMLSchema-instance"))) {
            xsiPrefix = "xsi";
            root.addNamespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            namespacePrefixMap.put("http://www.w3.org/2001/XMLSchema-instance", xsiPrefix);
        }
        if (null == (schemaLocations = (schemaLocationMap = XmlUtils.buildSchemaLocationMap(schemaLocationAttribute = XmlUtils.getOrAddAttribute(root, "schemaLocation", xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance"))).get(namespaceUri))) {
            schemaLocations = new ArrayList<String>();
            schemaLocationMap.put(namespaceUri, schemaLocations);
        }
        schemaLocations.clear();
        schemaLocations.add(schemaLocation);
        XmlUtils.setSchemaLocation(schemaLocationAttribute, schemaLocationMap);
        XmlUtils.setOrAddAttribute(root, "version", cachePrefix, namespaceUri, schemaVersion);
        return document;
    }

    private static final Attribute setOrAddAttribute(Element element, String localName, String prefix, String namespaceUri, String value2) {
        Attribute attribute = XmlUtils.getOrAddAttribute(element, localName, prefix, namespaceUri);
        attribute.setValue(value2);
        return attribute;
    }

    private static final Attribute getOrAddAttribute(Element element, String localName, String prefix, String namespaceUri) {
        Attribute attribute = element.getAttribute(localName, namespaceUri);
        if (null == attribute) {
            attribute = XmlUtils.createAttribute(localName, prefix, namespaceUri, "");
            element.addAttribute(attribute);
        }
        return attribute;
    }

    private static final Attribute createAttribute(String localName, String prefix, String namespaceUri, String value2) {
        if (null == prefix || prefix.isEmpty()) {
            return new Attribute(localName, value2);
        }
        return new Attribute(prefix + ":" + localName, namespaceUri, value2);
    }

    private static final Map<String, String> buildNamespacePrefixMap(Element root) {
        HashMap<String, String> namespacePrefixMap = new HashMap<String, String>();
        for (int i = 0; i < root.getNamespaceDeclarationCount(); ++i) {
            String prefix = root.getNamespacePrefix(i);
            String namespaceUri = root.getNamespaceURI(prefix);
            namespacePrefixMap.put(namespaceUri, prefix);
        }
        return namespacePrefixMap;
    }

    private static final void setSchemaLocation(Attribute schemaLocationAttribute, Map<String, List<String>> schemaLocationMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : schemaLocationMap.entrySet()) {
            for (String schemaLocation : entry.getValue()) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(entry.getKey()).append(' ').append(schemaLocation);
            }
        }
        schemaLocationAttribute.setValue(sb.toString());
    }

    public static final Map<String, List<String>> buildSchemaLocationMap(Attribute schemaLocationAttribute) {
        return XmlUtils.buildSchemaLocationMap(new HashMap<String, List<String>>(), schemaLocationAttribute);
    }

    public static final Map<String, List<String>> buildSchemaLocationMap(Map<String, List<String>> schemaLocationMap, Attribute schemaLocationAttribute) {
        if (null == schemaLocationAttribute) {
            return schemaLocationMap;
        }
        String schemaLocation = schemaLocationAttribute.getValue();
        if (null == schemaLocation || schemaLocation.isEmpty()) {
            return schemaLocationMap;
        }
        StringTokenizer st = new StringTokenizer(schemaLocation, " \n\t\r");
        while (st.hasMoreElements()) {
            String ns = st.nextToken();
            String loc = st.nextToken();
            List<String> locs = schemaLocationMap.get(ns);
            if (null == locs) {
                locs = new ArrayList<String>();
                schemaLocationMap.put(ns, locs);
            }
            if (locs.contains(loc)) continue;
            locs.add(loc);
        }
        return schemaLocationMap;
    }

    public static final Element querySingleElement(Node root, String xPath, XPathContext xPathContext) {
        Nodes nodes = root.query(xPath, xPathContext);
        if (nodes.size() > 0) {
            try {
                return (Element)nodes.get(0);
            }
            catch (ClassCastException e) {
                throw new XPathException("XPath is not an Element type.");
            }
        }
        return null;
    }

    static {
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setEntityResolver(new CacheXmlParser());
            builder1 = new Builder(xmlReader);
        }
        catch (SAXException e) {
            e.printStackTrace();
            builder1 = new Builder(true);
        }
    }
}

