/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.shell;

import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.management.cli.CliMetaData;
import com.gemstone.gemfire.management.cli.CommandProcessingException;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.CliAroundInterceptor;
import com.gemstone.gemfire.management.internal.cli.CommandRequest;
import com.gemstone.gemfire.management.internal.cli.CommandResponse;
import com.gemstone.gemfire.management.internal.cli.CommandResponseBuilder;
import com.gemstone.gemfire.management.internal.cli.GfshParseResult;
import com.gemstone.gemfire.management.internal.cli.LogWrapper;
import com.gemstone.gemfire.management.internal.cli.multistep.CLIMultiStepHelper;
import com.gemstone.gemfire.management.internal.cli.multistep.MultiStepCommand;
import com.gemstone.gemfire.management.internal.cli.result.FileResult;
import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import com.gemstone.gemfire.management.internal.cli.shell.JMXInvocationException;
import com.gemstone.gemfire.management.internal.cli.util.spring.Assert;
import com.gemstone.gemfire.management.internal.cli.util.spring.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.shell.core.ExecutionStrategy;
import org.springframework.shell.event.ParseResult;

public class GfshExecutionStrategy
implements ExecutionStrategy {
    private Class<?> mutex = GfshExecutionStrategy.class;
    private Gfsh shell;
    private LogWrapper logWrapper;

    GfshExecutionStrategy(Gfsh shell) {
        this.shell = shell;
        this.logWrapper = LogWrapper.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ParseResult parseResult) {
        Object result;
        block14: {
            result = null;
            Method method = parseResult.getMethod();
            try {
                Method reflectmethod = parseResult.getMethod();
                MultiStepCommand cmd = reflectmethod.getAnnotation(MultiStepCommand.class);
                if (cmd != null) {
                    return CLIMultiStepHelper.execCLISteps(this.logWrapper, this.shell, parseResult);
                }
                if (!this.isShellOnly(method)) {
                    if (GfshParseResult.class.isInstance(parseResult)) {
                        result = this.executeOnRemote((GfshParseResult)parseResult);
                        break block14;
                    }
                    throw new IllegalStateException("Configuration error!");
                }
                Assert.notNull(parseResult, "Parse result required");
                Class<?> clazz = this.mutex;
                synchronized (clazz) {
                    Assert.isTrue(this.isReadyForCommands(), "ProcessManagerHostedExecutionStrategy not yet ready for commands");
                    result = ReflectionUtils.invokeMethod(parseResult.getMethod(), parseResult.getInstance(), parseResult.getArguments());
                }
            }
            catch (JMXInvocationException e) {
                Gfsh.getCurrentInstance().logWarning(e.getMessage(), e);
            }
            catch (IllegalStateException e) {
                Gfsh.getCurrentInstance().logWarning(e.getMessage(), e);
            }
            catch (CommandProcessingException e) {
                Gfsh.getCurrentInstance().logWarning(e.getMessage(), null);
                Object errorData = e.getErrorData();
                if (errorData != null && errorData instanceof Throwable) {
                    this.logWrapper.warning(e.getMessage(), (Throwable)errorData);
                } else {
                    this.logWrapper.warning(e.getMessage());
                }
            }
            catch (RuntimeException e) {
                Gfsh.getCurrentInstance().logWarning("Exception occurred. " + e.getMessage(), e);
                this.logWrapper.warning("Error occurred while executing command : " + ((GfshParseResult)parseResult).getUserInput(), e);
            }
            catch (Exception e) {
                Gfsh.getCurrentInstance().logWarning("Unexpected exception occurred. " + e.getMessage(), e);
                this.logWrapper.warning("Unexpected error occurred while executing command : " + ((GfshParseResult)parseResult).getUserInput(), e);
            }
        }
        return result;
    }

    private boolean isShellOnly(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null && cliMetadata.shellOnly();
    }

    private String getInterceptor(Method method) {
        CliMetaData cliMetadata = method.getAnnotation(CliMetaData.class);
        return cliMetadata != null ? cliMetadata.interceptor() : "__NULL__";
    }

    public boolean isReadyForCommands() {
        return true;
    }

    public void terminate() {
        this.shell = null;
    }

    private Result executeOnRemote(GfshParseResult parseResult) {
        Result commandResult = null;
        Object response = null;
        if (this.shell.isConnectedAndReady()) {
            byte[][] fileData = null;
            CliAroundInterceptor interceptor = null;
            String interceptorClass = this.getInterceptor(parseResult.getMethod());
            if (!"__NULL__".equals(interceptorClass)) {
                try {
                    interceptor = (CliAroundInterceptor)ClassPathLoader.getLatest().forName(interceptorClass).newInstance();
                }
                catch (InstantiationException e) {
                    this.shell.logWarning("Configuration error", e);
                }
                catch (IllegalAccessException e) {
                    this.shell.logWarning("Configuration error", e);
                }
                catch (ClassNotFoundException e) {
                    this.shell.logWarning("Configuration error", e);
                }
                if (interceptor != null) {
                    Result preExecResult = interceptor.preExecution(parseResult);
                    if (Result.Status.ERROR.equals((Object)preExecResult.getStatus())) {
                        return preExecResult;
                    }
                    if (preExecResult instanceof FileResult) {
                        FileResult fileResult = (FileResult)preExecResult;
                        fileData = fileResult.toBytes();
                    }
                } else {
                    return ResultBuilder.createBadConfigurationErrorResult("Interceptor Configuration Error");
                }
            }
            Map<String, String> env = this.shell.getEnv();
            response = this.shell.getOperationInvoker().processCommand(new CommandRequest(parseResult, env, fileData));
            env.clear();
            if (response == null) {
                this.shell.logWarning("Response was null for: \"" + parseResult.getUserInput() + "\". (gfsh.isConnected=" + this.shell.isConnectedAndReady() + ")", null);
                commandResult = ResultBuilder.createBadResponseErrorResult(" Error occurred while executing \"" + parseResult.getUserInput() + "\" on manager. " + "Please check manager logs for error.");
            } else {
                Result postExecResult;
                String debugInfo;
                CommandResponse commandResponse;
                if (this.logWrapper.fineEnabled()) {
                    this.logWrapper.fine("Received response :: " + response);
                }
                if ((commandResponse = CommandResponseBuilder.prepareCommandResponseFromJson((String)response)).isFailedToPersist()) {
                    this.shell.printAsSevere("Failed to persist the configuration changes due to this command, Revert the command to maintain consistency.\nPlease use \"status cluster-config-service\" to determine whether Cluster configuration service is RUNNING.");
                    this.logWrapper.severe("Failed to persist the configuration changes due to this command, Revert the command to maintain consistency.\nPlease use \"status cluster-config-service\" to determine whether Cluster configuration service is RUNNING.");
                }
                if ((debugInfo = commandResponse.getDebugInfo()) != null && !debugInfo.trim().isEmpty()) {
                    debugInfo = debugInfo.replaceAll("\n\n\n", "\n");
                    debugInfo = debugInfo.replaceAll("\n\n", "\n");
                    debugInfo = debugInfo.replaceAll("\n", "\n[From Manager : " + commandResponse.getSender() + "]");
                    debugInfo = "[From Manager : " + commandResponse.getSender() + "]" + debugInfo;
                    LogWrapper.getInstance().info(debugInfo);
                }
                commandResult = ResultBuilder.fromJson((String)response);
                if (interceptor != null && (postExecResult = interceptor.postExecution(parseResult, commandResult)) != null) {
                    if (Result.Status.ERROR.equals((Object)postExecResult.getStatus())) {
                        if (this.logWrapper.infoEnabled()) {
                            this.logWrapper.info("Post execution Result :: " + ResultBuilder.resultAsString(postExecResult));
                        }
                    } else if (this.logWrapper.fineEnabled()) {
                        this.logWrapper.fine("Post execution Result :: " + ResultBuilder.resultAsString(postExecResult));
                    }
                    commandResult = postExecResult;
                }
            }
        } else {
            this.shell.logWarning("Can't execute a remote command without connection. Use 'connect' first to connect.", null);
            this.logWrapper.info("Can't execute a remote command \"" + parseResult.getUserInput() + "\" without connection. Use 'connect' first to connect to GemFire.");
        }
        return commandResult;
    }
}

