/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.shell;

import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.util.IOUtils;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import java.io.File;
import java.util.logging.Level;

public class GfshConfig {
    private static final String LOG_DIR_PROPERTY = "gfsh.log-dir";
    private static final String LOG_LEVEL_PROPERTY = "gfsh.log-level";
    private static final String LOG_FILE_SIZE_LIMIT_PROPERTY = "gfsh.log-file-size-limit";
    private static final String LOG_DISK_SPACE_LIMIT_PROPERTY = "gfsh.log-disk-space-limit";
    private static final File HISTORY_FILE = new File(GfshConfig.getHomeGemFireDirectory(), ".gfsh.history");
    private static final int MAX_HISTORY_SIZE = 500;
    private static final Level DEFAULT_LOGLEVEL = Level.OFF;
    private static final int DEFAULT_LOGFILE_SIZE_LIMIT = 0xA00000;
    private static final int DEFAULT_LOGFILE_DISK_USAGE = 0xA00000;
    private static final String DEFAULT_PROMPT = "{0}gfsh{1}>";
    private String historyFileName;
    private String defaultPrompt;
    private int historySize;
    private String logDir;
    private Level logLevel;
    private int logFileSizeLimit;
    private int logFileDiskLimit;

    public GfshConfig() {
        this(HISTORY_FILE.getAbsolutePath(), DEFAULT_PROMPT, 500, null, null, null, null);
    }

    public GfshConfig(String historyFileName, String defaultPrompt, int historySize, String logDir, Level logLevel, Integer logLimit, Integer logCount) {
        this.historyFileName = historyFileName;
        this.defaultPrompt = defaultPrompt;
        this.historySize = historySize;
        this.logDir = logDir == null ? System.getProperty(LOG_DIR_PROPERTY, ".") : logDir;
        this.logLevel = logLevel == null ? GfshConfig.getLogLevel(System.getProperty(LOG_LEVEL_PROPERTY, DEFAULT_LOGLEVEL.getName())) : logLevel;
        this.logFileSizeLimit = logLimit == null ? GfshConfig.getParsedOrDefault(System.getProperty(LOG_FILE_SIZE_LIMIT_PROPERTY), LOG_FILE_SIZE_LIMIT_PROPERTY, 0xA00000) : logLimit;
        this.logFileDiskLimit = logCount == null ? GfshConfig.getParsedOrDefault(System.getProperty(LOG_DISK_SPACE_LIMIT_PROPERTY), LOG_DISK_SPACE_LIMIT_PROPERTY, 0xA00000) : logCount;
    }

    public String getHistoryFileName() {
        return this.historyFileName;
    }

    public String getDefaultPrompt() {
        return this.defaultPrompt;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public String getLogFilePath() {
        return IOUtils.tryGetCanonicalPathElseGetAbsolutePath(new File(this.logDir, "gfsh-%u_%g.log"));
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public int getLogFileSizeLimit() {
        return this.logFileSizeLimit;
    }

    protected int getLogFileDiskLimit() {
        return this.logFileDiskLimit;
    }

    public int getLogFileCount() {
        int logCount;
        try {
            logCount = this.getLogFileSizeLimit() / this.getLogFileDiskLimit();
            logCount = logCount >= 1 ? logCount : 1;
        }
        catch (ArithmeticException e) {
            logCount = 1;
        }
        return logCount;
    }

    public boolean isLoggingEnabled() {
        return !Level.OFF.equals(this.getLogLevel());
    }

    private String getLoggerConfig() {
        StringBuilder builder = new StringBuilder();
        builder.append("log-file=" + this.getLogFilePath()).append(Gfsh.LINE_SEPARATOR);
        builder.append("log-level=" + this.getLogLevel().getName()).append(Gfsh.LINE_SEPARATOR);
        builder.append("log-file-size-limit=" + this.getLogFileSizeLimit()).append(Gfsh.LINE_SEPARATOR);
        builder.append("log-disk-space-limit=" + this.getLogFileDiskLimit()).append(Gfsh.LINE_SEPARATOR);
        builder.append("log-count=" + this.getLogFileCount()).append(Gfsh.LINE_SEPARATOR);
        return builder.toString();
    }

    public boolean isTestConfig() {
        return false;
    }

    public boolean isANSISupported() {
        return !Boolean.getBoolean("gfsh.disable.color");
    }

    private static Level getLogLevel(String logLevelString) {
        try {
            String logLevelAsString;
            String string = logLevelAsString = StringUtils.isBlank(logLevelString) ? "" : logLevelString.trim();
            if ("NONE".equalsIgnoreCase(logLevelAsString)) {
                logLevelAsString = Level.OFF.getName();
            }
            if ("ERROR".equalsIgnoreCase(logLevelAsString)) {
                logLevelAsString = Level.WARNING.getName();
            }
            return Level.parse(logLevelAsString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            return DEFAULT_LOGLEVEL;
        }
    }

    private static String getHomeGemFireDirectory() {
        String userHome = System.getProperty("user.home");
        String homeDirPath = userHome + "/.gemfire";
        File alternateDir = new File(homeDirPath);
        if (!alternateDir.exists() && !alternateDir.mkdirs()) {
            homeDirPath = ".";
        }
        return homeDirPath;
    }

    private static int getParsedOrDefault(String numberString, String parseValueFor, int defaultValue) {
        if (numberString == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(numberString);
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid value \"" + numberString + "\" specified for: \"" + parseValueFor + "\". Using default value: \"" + defaultValue + "\".");
            return defaultValue;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" [historyFileName=");
        builder.append(this.getHistoryFileName());
        builder.append(", historySize=");
        builder.append(this.getHistorySize());
        builder.append(", loggerConfig={");
        builder.append(this.getLoggerConfig()).append("}");
        builder.append(", isANSISupported=");
        builder.append(this.isANSISupported());
        builder.append("]");
        return builder.toString();
    }
}

