/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.result;

import com.gemstone.gemfire.management.internal.cli.json.GfJsonArray;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonException;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonObject;
import com.gemstone.gemfire.management.internal.cli.result.AbstractResultData;
import com.gemstone.gemfire.management.internal.cli.result.ResultDataException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TabularResultData
extends AbstractResultData {
    TabularResultData() {
    }

    TabularResultData(GfJsonObject gfJsonObject) {
        super(gfJsonObject);
    }

    public TabularResultData accumulate(String accumulateFor, Object value2) {
        try {
            this.contentObject.accumulate(accumulateFor, value2);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return this;
    }

    public GfJsonArray getHeaders() {
        try {
            return this.contentObject.names();
        }
        catch (GfJsonException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public GfJsonObject getGfJsonObject() {
        return this.gfJsonObject;
    }

    @Override
    public String getType() {
        return "table";
    }

    @Override
    public TabularResultData setHeader(String headerText) {
        return (TabularResultData)super.setHeader(headerText);
    }

    @Override
    public TabularResultData setFooter(String footerText) {
        return (TabularResultData)super.setFooter(footerText);
    }

    @Override
    public String getHeader() {
        return this.gfJsonObject.getString("header");
    }

    @Override
    public String getFooter() {
        return this.gfJsonObject.getString("footer");
    }

    public Map<String, String> retrieveDataByValueInColumn(String columnName, String valueToSearch) {
        Map<String, String> foundValues = Collections.emptyMap();
        try {
            GfJsonArray jsonArray = this.contentObject.getJSONArray(columnName);
            int size2 = jsonArray.size();
            int foundIndex = -1;
            for (int i = 0; i < size2; ++i) {
                Object object = jsonArray.get(i);
                if (object == null || !object.equals(valueToSearch)) continue;
                foundIndex = i;
                break;
            }
            if (foundIndex != -1) {
                foundValues = new LinkedHashMap<String, String>();
                Iterator<String> iterator = this.contentObject.keys();
                while (iterator.hasNext()) {
                    String storedColumnNames = iterator.next();
                    GfJsonArray storedColumnValues = this.contentObject.getJSONArray(storedColumnNames);
                    foundValues.put(storedColumnNames, String.valueOf(storedColumnValues.get(foundIndex)));
                }
            }
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return foundValues;
    }

    public List<Map<String, String>> retrieveAllDataByValueInColumn(String columnName, String valueToSearch) {
        ArrayList<Map<String, String>> foundValuesList = new ArrayList<Map<String, String>>();
        try {
            GfJsonArray jsonArray = this.contentObject.getJSONArray(columnName);
            int size2 = jsonArray.size();
            for (int i = 0; i < size2; ++i) {
                Object object = jsonArray.get(i);
                if (object == null || !object.equals(valueToSearch)) continue;
                LinkedHashMap<String, String> foundValues = new LinkedHashMap<String, String>();
                Iterator<String> iterator = this.contentObject.keys();
                while (iterator.hasNext()) {
                    String storedColumnNames = iterator.next();
                    GfJsonArray storedColumnValues = this.contentObject.getJSONArray(storedColumnNames);
                    foundValues.put(storedColumnNames, String.valueOf(storedColumnValues.get(i)));
                }
                foundValuesList.add(foundValues);
            }
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return foundValuesList;
    }

    public List<String> retrieveAllValues(String columnName) {
        ArrayList<String> values = new ArrayList<String>();
        try {
            GfJsonArray jsonArray = this.contentObject.getJSONArray(columnName);
            int size2 = jsonArray.size();
            for (int i = 0; i < size2; ++i) {
                values.add(String.valueOf(jsonArray.get(i)));
            }
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return values;
    }
}

