/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.parser;

import com.gemstone.gemfire.management.internal.cli.parser.Parameter;
import com.gemstone.gemfire.management.internal.cli.parser.preprocessor.PreprocessorUtils;
import java.util.ArrayList;
import java.util.List;

public class Option
extends Parameter {
    private static final String NULL = "__NULL__";
    private static final char SHORT_OPTION_DEFAULT = '\u0000';
    private char shortOption;
    private String longOption;
    private List<String> synonyms;
    private List<String> aggregate = new ArrayList<String>();
    private String specifiedDefaultValue;
    private boolean withRequiredArgs;
    private String valueSeparator;

    public Option() {
    }

    public Option(char shortOption) {
        this(shortOption, null, null);
    }

    public Option(char shortOption, List<String> synonyms) {
        this(shortOption, null, synonyms);
    }

    public Option(String longOption) {
        this('\u0000', longOption, null);
    }

    public Option(String longOption, List<String> synonyms) {
        this('\u0000', longOption, synonyms);
    }

    public Option(char shortOption, String longOption) {
        this(shortOption, longOption, null);
    }

    public Option(char shortOption, String longOption, List<String> synonyms) {
        this.shortOption = shortOption;
        this.longOption = longOption;
        this.synonyms = synonyms;
        if (shortOption != '\u0000') {
            this.aggregate.add("" + shortOption);
        }
        if (longOption != null) {
            this.aggregate.add(longOption);
        }
        if (synonyms != null) {
            this.aggregate.addAll(synonyms);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(Option.class.getSimpleName()).append("[longOption=" + this.longOption).append(",help=" + this.help).append(",required=" + this.required + "]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 41;
        int result = 1;
        result = 41 * result + (this.longOption == null ? 0 : this.longOption.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Option option = (Option)obj;
        return !(this.longOption == null ? option.getLongOption() != null : !this.longOption.equals(option.getLongOption()));
    }

    public final List<String> getAggregate() {
        return this.aggregate;
    }

    public char getShortOption() {
        return this.shortOption;
    }

    public boolean setShortOption(char shortOption) {
        if (shortOption != '\u0000') {
            int index2 = this.aggregate.indexOf("" + this.shortOption);
            if (index2 != -1) {
                return false;
            }
            this.shortOption = shortOption;
            this.aggregate.add("" + shortOption);
            return true;
        }
        return false;
    }

    public String getLongOption() {
        return this.longOption;
    }

    public boolean setLongOption(String longOption) {
        if (!(longOption = longOption.trim()).equals("") && this.longOption == null) {
            int index2 = this.aggregate.indexOf(longOption);
            if (index2 != -1) {
                return false;
            }
            this.longOption = longOption;
            this.aggregate.add(longOption);
            return true;
        }
        return false;
    }

    public List<String> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(List<String> synonyms) {
        this.synonyms = new ArrayList<String>();
        for (String string : synonyms) {
            if (string.equals("")) continue;
            this.synonyms.add(string);
        }
        if (this.synonyms.size() > 0) {
            this.aggregate.addAll(this.synonyms);
        }
    }

    public boolean isWithRequiredArgs() {
        return this.withRequiredArgs;
    }

    public void setWithRequiredArgs(boolean withRequiredArgs) {
        this.withRequiredArgs = withRequiredArgs;
    }

    public String[] getStringArray() {
        String[] stringArray = new String[this.aggregate.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.aggregate.get(i);
        }
        return stringArray;
    }

    public String getSpecifiedDefaultValue() {
        if (this.specifiedDefaultValue.equals(NULL)) {
            return null;
        }
        return this.specifiedDefaultValue;
    }

    public void setSpecifiedDefaultValue(String specifiedDefaultValue) {
        this.specifiedDefaultValue = PreprocessorUtils.trim(specifiedDefaultValue).getString();
    }

    public String getValueSeparator() {
        return this.valueSeparator;
    }

    public void setValueSeparator(String valueSeparator) {
        this.valueSeparator = valueSeparator;
    }
}

