/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.json;

import com.gemstone.gemfire.management.internal.cli.json.GfJsonArray;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonException;
import com.gemstone.org.json.JSONArray;
import com.gemstone.org.json.JSONException;
import com.gemstone.org.json.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class GfJsonObject {
    public static final Object NULL = JSONObject.NULL;
    private JSONObject jsonObject;

    public GfJsonObject() {
        this.jsonObject = new JSONObject();
    }

    public GfJsonObject(Object bean, boolean checkCyclicDep) {
        if (checkCyclicDep) {
            JSONObject.cyclicDepChkEnabled.set(true);
            JSONObject.cyclicDependencySet.set(new HashSet());
        }
        this.jsonObject = bean instanceof JSONObject ? (JSONObject)bean : new JSONObject(bean);
        if (checkCyclicDep) {
            JSONObject.cyclicDepChkEnabled.set(false);
            JSONObject.cyclicDependencySet.set(null);
        }
    }

    public GfJsonObject(GfJsonObject gfJsonObject) {
        this.jsonObject = gfJsonObject.jsonObject;
    }

    public GfJsonObject(Map<?, ?> map) {
        this.jsonObject = new JSONObject(map);
    }

    public GfJsonObject(Object bean) {
        this.jsonObject = bean instanceof JSONObject ? (JSONObject)bean : new JSONObject(bean);
    }

    public GfJsonObject(Object bean, String[] paramNames) {
        this.jsonObject = new JSONObject(bean, paramNames);
    }

    public GfJsonObject(String source) throws GfJsonException {
        try {
            this.jsonObject = new JSONObject(source);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
    }

    public GfJsonObject accumulate(String key2, Object value2) throws GfJsonException {
        try {
            if (this.jsonObject.has(key2)) {
                this.jsonObject.append(key2, value2);
            } else {
                this.jsonObject.put(key2, new JSONArray().put(value2));
            }
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject accumulateAsJSONObject(String key2, Object value2) throws GfJsonException {
        JSONObject val = new JSONObject(value2);
        try {
            if (this.jsonObject.has(key2)) {
                this.jsonObject.append(key2, val);
            } else {
                this.jsonObject.put(key2, new JSONArray().put(val));
            }
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject append(String key2, Object value2) throws GfJsonException {
        try {
            this.jsonObject.append(key2, value2);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public Object get(String key2) {
        return this.jsonObject.opt(key2);
    }

    public String getString(String key2) {
        return this.jsonObject.optString(key2);
    }

    public int getInt(String key2) {
        return this.jsonObject.optInt(key2);
    }

    public long getLong(String key2) {
        return this.jsonObject.optLong(key2);
    }

    public double getDouble(String key2) {
        return this.jsonObject.optDouble(key2);
    }

    public boolean getBoolean(String key2) {
        return this.jsonObject.optBoolean(key2);
    }

    public GfJsonObject getJSONObject(String key2) {
        Object opt = this.jsonObject.opt(key2);
        if (opt instanceof GfJsonObject) {
            return (GfJsonObject)opt;
        }
        return new GfJsonObject(opt);
    }

    public JSONObject getInternalJsonObject() {
        return this.jsonObject;
    }

    public GfJsonArray getJSONArray(String key2) throws GfJsonException {
        JSONArray jsonArray = this.jsonObject.optJSONArray(key2);
        if (jsonArray == null) {
            return null;
        }
        return new GfJsonArray(jsonArray);
    }

    public GfJsonArray names() throws GfJsonException {
        GfJsonArray gfJsonArray = new GfJsonArray();
        JSONArray names = this.jsonObject.names();
        if (names != null) {
            gfJsonArray = new GfJsonArray(names);
        }
        return gfJsonArray;
    }

    public GfJsonObject put(String key2, Object value2) throws GfJsonException {
        try {
            this.jsonObject.put(key2, GfJsonObject.extractInternalForGfJsonOrReturnSame(value2));
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject putAsJSONObject(String key2, Object value2) throws GfJsonException {
        try {
            Object internalJsonObj = GfJsonObject.extractInternalForGfJsonOrReturnSame(value2);
            if (internalJsonObj == value2) {
                GfJsonObject jsonObj = new GfJsonObject(value2);
                internalJsonObj = jsonObj.getInternalJsonObject();
            }
            this.jsonObject.put(key2, internalJsonObj);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject putOnce(String key2, Object value2) throws GfJsonException {
        try {
            this.jsonObject.putOnce(key2, value2);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject putOpt(String key2, Object value2) throws GfJsonException {
        try {
            this.jsonObject.putOpt(key2, GfJsonObject.extractInternalForGfJsonOrReturnSame(value2));
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject put(String key2, Collection<?> value2) throws GfJsonException {
        try {
            this.jsonObject.putOpt(key2, value2);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject putJSONArray(String key2, GfJsonArray value2) throws GfJsonException {
        try {
            this.jsonObject.putOpt(key2, value2.getInternalJsonArray());
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonObject put(String key2, Map<?, ?> value2) throws GfJsonException {
        try {
            this.jsonObject.put(key2, value2);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public static String quote(String string) {
        return JSONObject.quote(string);
    }

    public Object remove(String key2) {
        return this.jsonObject.remove(key2);
    }

    public boolean has(String key2) {
        return this.jsonObject.has(key2);
    }

    public Iterator<String> keys() {
        return this.jsonObject.keys();
    }

    public int size() {
        return this.jsonObject.length();
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    public String getType() {
        return this.jsonObject.optString("type-class");
    }

    public String toIndentedString(int indentFactor) throws GfJsonException {
        try {
            return this.jsonObject.toString(indentFactor);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
    }

    private static Object extractInternalForGfJsonOrReturnSame(Object value2) {
        Object returnedValue = value2;
        if (value2 instanceof GfJsonObject) {
            returnedValue = ((GfJsonObject)value2).getInternalJsonObject();
        } else if (value2 instanceof GfJsonArray) {
            returnedValue = ((GfJsonArray)value2).getInternalJsonArray();
        } else if (value2 == null) {
            returnedValue = NULL;
        }
        return returnedValue;
    }

    public static GfJsonObject getGfJsonErrorObject(String errorMessage) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        errorMap.put("error", errorMessage);
        return new GfJsonObject(errorMap);
    }

    public static boolean isJSONKind(Object object) {
        return object instanceof JSONObject;
    }
}

