/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.json;

import com.gemstone.gemfire.management.internal.cli.LogWrapper;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonException;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonObject;
import com.gemstone.org.json.JSONArray;
import com.gemstone.org.json.JSONException;
import java.util.Collection;
import java.util.Map;

public class GfJsonArray {
    private JSONArray jsonArray;

    public GfJsonArray() {
        this.jsonArray = new JSONArray();
    }

    public GfJsonArray(Object array) throws GfJsonException {
        try {
            this.jsonArray = array instanceof JSONArray ? (JSONArray)array : new JSONArray(array);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
    }

    public GfJsonArray(String source) throws GfJsonException {
        try {
            this.jsonArray = new JSONArray(source);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
    }

    public Object get(int index2) throws GfJsonException {
        try {
            return this.jsonArray.get(index2);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
    }

    public GfJsonObject getJSONObject(int index2) throws GfJsonException {
        try {
            return new GfJsonObject(this.jsonArray.getJSONObject(index2));
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
    }

    public GfJsonArray put(Object value2) {
        this.jsonArray.put(GfJsonArray.extractInternalForGfJsonOrReturnSame(value2));
        return this;
    }

    public GfJsonArray put(int index2, Object value2) throws GfJsonException {
        try {
            this.jsonArray.put(index2, GfJsonArray.extractInternalForGfJsonOrReturnSame(value2));
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonArray put(Collection<?> value2) {
        this.jsonArray.put(value2);
        return this;
    }

    public GfJsonArray put(int index2, Collection<?> value2) throws GfJsonException {
        try {
            this.jsonArray.put(index2, value2);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonArray put(Map<?, ?> value2) {
        this.jsonArray.put(value2);
        return this;
    }

    public GfJsonArray put(int index2, Map<?, ?> value2) throws GfJsonException {
        try {
            this.jsonArray.put(index2, value2);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public int size() {
        return this.jsonArray.length();
    }

    public String toString() {
        return this.jsonArray.toString();
    }

    public String toIndentedString(int indentFactor) throws GfJsonException {
        try {
            return this.jsonArray.toString(indentFactor);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
    }

    public static byte[] toByteArray(GfJsonArray jsonArray) throws GfJsonException {
        byte[] byteArray = null;
        if (jsonArray != null) {
            int length = jsonArray.size();
            byteArray = new byte[length];
            for (int i = 0; i < length; ++i) {
                try {
                    byteArray[i] = Byte.valueOf(String.valueOf(jsonArray.get(i)));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw e;
                }
                catch (GfJsonException e) {
                    throw new GfJsonException(e.getMessage());
                }
            }
        }
        return byteArray;
    }

    public static String[] toStringArray(GfJsonArray jsonArray) {
        String[] stringArray = null;
        if (jsonArray != null) {
            int length = jsonArray.size();
            stringArray = new String[length];
            for (int i = 0; i < length; ++i) {
                try {
                    stringArray[i] = String.valueOf(jsonArray.get(i));
                    continue;
                }
                catch (GfJsonException e) {
                    LogWrapper.getInstance().info("", e);
                    stringArray = null;
                }
            }
        }
        return stringArray;
    }

    public JSONArray getInternalJsonArray() {
        return this.jsonArray;
    }

    private static Object extractInternalForGfJsonOrReturnSame(Object value2) {
        Object returnedValue = value2;
        if (value2 instanceof GfJsonObject) {
            returnedValue = ((GfJsonObject)value2).getInternalJsonObject();
        } else if (value2 instanceof GfJsonArray) {
            returnedValue = ((GfJsonArray)value2).getInternalJsonArray();
        } else if (value2 == null) {
            returnedValue = GfJsonObject.NULL;
        }
        return returnedValue;
    }
}

