/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.JarClassLoader;
import com.gemstone.gemfire.internal.JarDeployer;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.logging.log4j.Logger;

public class UndeployFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = UndeployFunction.class.getName();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            Object[] args = (Object[])context.getArguments();
            String jarFilenameList = (String)args[0];
            Cache cache = CacheFactory.getAnyInstance();
            JarDeployer jarDeployer = new JarDeployer(((GemFireCacheImpl)cache).getDistributedSystem().getConfig().getDeployWorkingDir());
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            String[] undeployedJars = new String[]{};
            if (jarFilenameList == null || jarFilenameList.equals("")) {
                List<JarClassLoader> jarClassLoaders = jarDeployer.findJarClassLoaders();
                undeployedJars = new String[jarClassLoaders.size() * 2];
                int index2 = 0;
                for (JarClassLoader jarClassLoader : jarClassLoaders) {
                    undeployedJars[index2++] = jarClassLoader.getJarName();
                    try {
                        undeployedJars[index2++] = jarDeployer.undeploy(jarClassLoader.getJarName());
                    }
                    catch (IllegalArgumentException iaex) {
                        undeployedJars[index2++] = iaex.getMessage();
                    }
                }
            } else {
                ArrayList<String> undeployedList = new ArrayList<String>();
                StringTokenizer jarTokenizer = new StringTokenizer(jarFilenameList, ",");
                while (jarTokenizer.hasMoreTokens()) {
                    String jarFilename = jarTokenizer.nextToken().trim();
                    try {
                        undeployedList.add(jarFilename);
                        undeployedList.add(jarDeployer.undeploy(jarFilename));
                    }
                    catch (IllegalArgumentException iaex) {
                        undeployedList.add(iaex.getMessage());
                    }
                }
                undeployedJars = undeployedList.toArray(undeployedJars);
            }
            CliFunctionResult result = new CliFunctionResult(memberId, (Serializable[])undeployedJars);
            context.getResultSender().lastResult(result);
        }
        catch (CacheClosedException cce) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult(result);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error("Could not undeploy JAR file: {}", th.getMessage(), th);
            CliFunctionResult result = new CliFunctionResult(memberId, th, null);
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

