/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.configuration.domain.XmlEntity;

public class RegionDestroyFunction
implements Function,
InternalEntity {
    private static final long serialVersionUID = 9172773671865750685L;
    public static final RegionDestroyFunction INSTANCE = new RegionDestroyFunction();
    private static final String ID = RegionDestroyFunction.class.getName();

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public void execute(FunctionContext context) {
        String regionPath = null;
        try {
            Object arguments;
            String functionId = context.getFunctionId();
            if (this.getId().equals(functionId) && (arguments = context.getArguments()) != null) {
                regionPath = (String)arguments;
                Cache cache = CacheFactory.getAnyInstance();
                Region region = cache.getRegion(regionPath);
                region.destroyRegion();
                String regionName = regionPath.startsWith("/") ? regionPath.substring(1) : regionPath;
                XmlEntity xmlEntity = new XmlEntity("region", "name", regionName);
                context.getResultSender().lastResult(new CliFunctionResult("", xmlEntity, regionPath));
            }
            context.getResultSender().lastResult(new CliFunctionResult("", false, "FAILURE"));
        }
        catch (IllegalStateException e) {
            context.getResultSender().lastResult(new CliFunctionResult("", e, null));
        }
        catch (Exception ex) {
            context.getResultSender().lastResult(new CliFunctionResult("", new RuntimeException(CliStrings.format("Error while destroying region {0}. Reason: {1}", regionPath, ex.getMessage())), null));
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

