/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.commands.CreateAlterDestroyRegionCommands;
import com.gemstone.gemfire.management.internal.cli.exceptions.CreateSubregionException;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.cli.functions.RegionFunctionArgs;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.util.RegionPath;
import com.gemstone.gemfire.management.internal.configuration.domain.XmlEntity;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class RegionCreateFunction
extends FunctionAdapter
implements InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 8746830191680509335L;
    private static final String ID = RegionCreateFunction.class.getName();
    public static RegionCreateFunction INSTANCE = new RegionCreateFunction();

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public void execute(FunctionContext context) {
        Region region;
        ResultSender<CliFunctionResult> resultSender = context.getResultSender();
        Cache cache = CacheFactory.getAnyInstance();
        String memberNameOrId = CliUtil.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        RegionFunctionArgs regionCreateArgs = (RegionFunctionArgs)context.getArguments();
        if (regionCreateArgs.isSkipIfExists().booleanValue() && (region = cache.getRegion(regionCreateArgs.getRegionPath())) != null) {
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, true, CliStrings.format("Skipping \"{0}\". Region \"{1}\" already exists.", memberNameOrId, regionCreateArgs.getRegionPath())));
            return;
        }
        try {
            Region<?, ?> createdRegion = RegionCreateFunction.createRegion(cache, regionCreateArgs);
            XmlEntity xmlEntity = new XmlEntity("region", "name", createdRegion.getName());
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, xmlEntity, CliStrings.format("Region \"{0}\" created on \"{1}\"", createdRegion.getFullPath(), memberNameOrId)));
        }
        catch (IllegalStateException e) {
            String exceptionMsg = e.getMessage();
            String localizedString = LocalizedStrings.DiskStore_IS_USED_IN_NONPERSISTENT_REGION.toLocalizedString();
            if (localizedString.equals(e.getMessage())) {
                exceptionMsg = exceptionMsg + " " + CliStrings.format("Use one of these shortcuts: {0}", new Object[]{String.valueOf(CreateAlterDestroyRegionCommands.PERSISTENT_OVERFLOW_SHORTCUTS)});
            }
            resultSender.lastResult(this.handleException(memberNameOrId, exceptionMsg, null));
        }
        catch (IllegalArgumentException e) {
            resultSender.lastResult(this.handleException(memberNameOrId, e.getMessage(), e));
        }
        catch (RegionExistsException e) {
            String exceptionMsg = CliStrings.format("Region with path \"{0}\" already exists on \"{1}\"", regionCreateArgs.getRegionPath(), memberNameOrId);
            resultSender.lastResult(this.handleException(memberNameOrId, exceptionMsg, e));
        }
        catch (CreateSubregionException e) {
            resultSender.lastResult(this.handleException(memberNameOrId, e.getMessage(), e));
        }
        catch (Exception e) {
            String exceptionMsg = e.getMessage();
            if (exceptionMsg == null) {
                exceptionMsg = CliUtil.stackTraceAsString(e);
            }
            resultSender.lastResult(this.handleException(memberNameOrId, exceptionMsg, e));
        }
    }

    private CliFunctionResult handleException(String memberNameOrId, String exceptionMsg, Exception e) {
        if (e != null && logger.isDebugEnabled()) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        if (exceptionMsg != null) {
            return new CliFunctionResult(memberNameOrId, false, exceptionMsg);
        }
        return new CliFunctionResult(memberNameOrId);
    }

    public static <K, V> Region<?, ?> createRegion(Cache cache, RegionFunctionArgs regionCreateArgs) {
        String cacheWriter;
        String cacheLoader;
        Set<String> cacheListeners;
        Set<String> asyncEventQueueIds;
        Set<String> gatewaySenderIds;
        String diskStore;
        RegionFunctionArgs.ExpirationAttrs regionExpirationTTL;
        RegionFunctionArgs.ExpirationAttrs regionExpirationIdleTime;
        RegionFunctionArgs.ExpirationAttrs entryExpirationTTL;
        RegionFunctionArgs.ExpirationAttrs entryExpirationIdleTime;
        Region createdRegion = null;
        String regionPath = regionCreateArgs.getRegionPath();
        RegionShortcut regionShortcut = regionCreateArgs.getRegionShortcut();
        String useAttributesFrom = regionCreateArgs.getUseAttributesFrom();
        RegionPath regionPathData = new RegionPath(regionPath);
        String parentRegionPath = regionPathData.getParent();
        Region parentRegion = null;
        if (parentRegionPath != null && !"/".equals(parentRegionPath)) {
            parentRegion = cache.getRegion(parentRegionPath);
            if (parentRegion == null) {
                throw new IllegalArgumentException(CliStrings.format("Parent region for \"{0}\" doesn't exist. ", new Object[]{regionPath}));
            }
            if (parentRegion.getAttributes().getPartitionAttributes() != null) {
                throw new CreateSubregionException(CliStrings.format("\"{0}\" is a Partitioned Region and cannot have Subregions.", (Object)parentRegion.getFullPath()));
            }
        }
        if (regionShortcut == null && useAttributesFrom == null) {
            throw new IllegalArgumentException("One of \"type\" or \"template-region\" is required.");
        }
        boolean isPartitioned = false;
        RegionFactory<K, K> factory = null;
        RegionAttributes regionAttributes = null;
        if (regionShortcut != null) {
            regionAttributes = cache.getRegionAttributes(regionShortcut.toString());
            if (logger.isDebugEnabled()) {
                logger.debug("Using shortcut {} for {} region attributes : {}", new Object[]{regionShortcut, regionPath, regionAttributes});
            }
            if (regionAttributes == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Shortcut {} doesn't have attributes in {}", new Object[]{regionShortcut, cache.listRegionAttributes()});
                }
                throw new IllegalStateException(CliStrings.format("Could not load Region Attributes for a valid type={0}. Please check logs for any errors.", (Object)regionShortcut));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Using Manager's region attributes for {}", regionPath);
            }
            regionAttributes = regionCreateArgs.getRegionAttributes();
            if (logger.isDebugEnabled()) {
                logger.debug("Using Attributes : {}", regionAttributes);
            }
        }
        isPartitioned = regionAttributes.getPartitionAttributes() != null;
        factory = cache.createRegionFactory(regionAttributes);
        if (!isPartitioned && regionCreateArgs.hasPartitionAttributes()) {
            throw new IllegalArgumentException(CliStrings.format("Parameter(s) \"{0}\" can be used only for creating a Partitioned Region.", (Object)regionCreateArgs.getPartitionArgs().getUserSpecifiedPartitionAttributes()));
        }
        if (isPartitioned) {
            PartitionAttributes partitionAttributes = RegionCreateFunction.extractPartitionAttributes(cache, regionAttributes, regionCreateArgs);
            DataPolicy originalDataPolicy = regionAttributes.getDataPolicy();
            factory.setPartitionAttributes(partitionAttributes);
            factory.setDataPolicy(originalDataPolicy);
        }
        String keyConstraint = regionCreateArgs.getKeyConstraint();
        String valueConstraint = regionCreateArgs.getValueConstraint();
        if (keyConstraint != null && !keyConstraint.isEmpty()) {
            Class<K> keyConstraintClass = RegionCreateFunction.forName(keyConstraint, "key-constraint");
            factory.setKeyConstraint(keyConstraintClass);
        }
        if (valueConstraint != null && !valueConstraint.isEmpty()) {
            Class<K> valueConstraintClass = RegionCreateFunction.forName(valueConstraint, "value-constraint");
            factory.setValueConstraint(valueConstraintClass);
        }
        if ((entryExpirationIdleTime = regionCreateArgs.getEntryExpirationIdleTime()) != null) {
            factory.setEntryIdleTimeout(entryExpirationIdleTime.convertToExpirationAttributes());
        }
        if ((entryExpirationTTL = regionCreateArgs.getEntryExpirationTTL()) != null) {
            factory.setEntryTimeToLive(entryExpirationTTL.convertToExpirationAttributes());
        }
        if ((regionExpirationIdleTime = regionCreateArgs.getRegionExpirationIdleTime()) != null) {
            factory.setEntryIdleTimeout(regionExpirationIdleTime.convertToExpirationAttributes());
        }
        if ((regionExpirationTTL = regionCreateArgs.getRegionExpirationTTL()) != null) {
            factory.setEntryTimeToLive(regionExpirationTTL.convertToExpirationAttributes());
        }
        if ((diskStore = regionCreateArgs.getDiskStore()) != null && !diskStore.isEmpty()) {
            factory.setDiskStoreName(diskStore);
        }
        if (regionCreateArgs.isSetDiskSynchronous().booleanValue()) {
            factory.setDiskSynchronous(regionCreateArgs.isDiskSynchronous());
        }
        if (regionCreateArgs.isSetStatisticsEnabled().booleanValue()) {
            factory.setStatisticsEnabled(regionCreateArgs.isStatisticsEnabled());
        }
        if (regionCreateArgs.isSetEnableAsyncConflation().booleanValue()) {
            factory.setEnableAsyncConflation(regionCreateArgs.isEnableAsyncConflation());
        }
        if (regionCreateArgs.isSetEnableSubscriptionConflation().booleanValue()) {
            factory.setEnableSubscriptionConflation(regionCreateArgs.isEnableSubscriptionConflation());
        }
        if ((gatewaySenderIds = regionCreateArgs.getGatewaySenderIds()) != null && !gatewaySenderIds.isEmpty()) {
            for (String gatewaySenderId : gatewaySenderIds) {
                factory.addGatewaySenderId(gatewaySenderId);
            }
        }
        if ((asyncEventQueueIds = regionCreateArgs.getAsyncEventQueueIds()) != null && !asyncEventQueueIds.isEmpty()) {
            for (String asyncEventQueueId : asyncEventQueueIds) {
                factory.addAsyncEventQueueId(asyncEventQueueId);
            }
        }
        if (regionCreateArgs.isSetConcurrencyChecksEnabled().booleanValue()) {
            factory.setConcurrencyChecksEnabled(regionCreateArgs.isConcurrencyChecksEnabled());
        }
        if (regionCreateArgs.isSetConcurrencyLevel().booleanValue()) {
            factory.setConcurrencyLevel(regionCreateArgs.getConcurrencyLevel());
        }
        if (regionCreateArgs.isSetCloningEnabled().booleanValue()) {
            factory.setCloningEnabled(regionCreateArgs.isCloningEnabled());
        }
        if ((cacheListeners = regionCreateArgs.getCacheListeners()) != null && !cacheListeners.isEmpty()) {
            for (String cacheListener : cacheListeners) {
                Class<K> cacheListenerKlass = RegionCreateFunction.forName(cacheListener, "cache-listener");
                factory.addCacheListener((CacheListener)RegionCreateFunction.newInstance(cacheListenerKlass, "cache-listener"));
            }
        }
        if (regionCreateArgs.isSetCompressor()) {
            Class<K> compressorKlass = RegionCreateFunction.forName(regionCreateArgs.getCompressor(), "compressor");
            factory.setCompressor((Compressor)RegionCreateFunction.newInstance(compressorKlass, "compressor"));
        }
        if ((cacheLoader = regionCreateArgs.getCacheLoader()) != null) {
            Class<K> cacheLoaderKlass = RegionCreateFunction.forName(cacheLoader, "cache-loader");
            factory.setCacheLoader((CacheLoader)RegionCreateFunction.newInstance(cacheLoaderKlass, "cache-loader"));
        }
        if ((cacheWriter = regionCreateArgs.getCacheWriter()) != null) {
            Class<K> cacheWriterKlass = RegionCreateFunction.forName(cacheWriter, "cache-writer");
            factory.setCacheWriter((CacheWriter)RegionCreateFunction.newInstance(cacheWriterKlass, "cache-writer"));
        }
        String regionName = regionPathData.getName();
        createdRegion = parentRegion != null ? factory.createSubregion(parentRegion, regionName) : factory.create(regionName);
        return createdRegion;
    }

    private static <K, V> PartitionAttributes<K, V> extractPartitionAttributes(Cache cache, RegionAttributes<K, V> regionAttributes, RegionFunctionArgs regionCreateArgs) {
        RegionFunctionArgs.PartitionArgs partitionArgs = regionCreateArgs.getPartitionArgs();
        PartitionAttributesFactory prAttrFactory = null;
        PartitionAttributes partitionAttributes = regionAttributes.getPartitionAttributes();
        prAttrFactory = partitionAttributes != null ? new PartitionAttributesFactory(partitionAttributes) : new PartitionAttributesFactory();
        String colocatedWith = partitionArgs.getPrColocatedWith();
        if (colocatedWith != null) {
            Region colocatedWithRegion = cache.getRegion(colocatedWith);
            if (colocatedWithRegion == null) {
                throw new IllegalArgumentException(CliStrings.format("colocated-with \"{0}\" does not exists.", (Object)colocatedWith));
            }
            if (!colocatedWithRegion.getAttributes().getDataPolicy().withPartitioning()) {
                throw new IllegalArgumentException(CliStrings.format("colocated-with \"{0}\" is not a Partitioned Region.", (Object)colocatedWith));
            }
            prAttrFactory.setColocatedWith(colocatedWith);
        }
        if (partitionArgs.isSetPRLocalMaxMemory().booleanValue()) {
            prAttrFactory.setLocalMaxMemory(partitionArgs.getPrLocalMaxMemory());
        }
        if (partitionArgs.isSetPRTotalMaxMemory().booleanValue()) {
            prAttrFactory.setTotalMaxMemory(partitionArgs.getPrTotalMaxMemory());
        }
        if (partitionArgs.isSetPRTotalNumBuckets().booleanValue()) {
            prAttrFactory.setTotalNumBuckets(partitionArgs.getPrTotalNumBuckets());
        }
        if (partitionArgs.isSetPRRedundantCopies().booleanValue()) {
            prAttrFactory.setRedundantCopies(partitionArgs.getPrRedundantCopies());
        }
        if (partitionArgs.isSetPRRecoveryDelay().booleanValue()) {
            prAttrFactory.setRecoveryDelay(partitionArgs.getPrRecoveryDelay());
        }
        if (partitionArgs.isSetPRStartupRecoveryDelay().booleanValue()) {
            prAttrFactory.setStartupRecoveryDelay(partitionArgs.getPrStartupRecoveryDelay());
        }
        return prAttrFactory.create();
    }

    private static <K> Class<K> forName(String classToLoadName, String neededFor) {
        Class<?> loadedClass = null;
        try {
            ClassPathLoader classPathLoader = ClassPathLoader.getLatest();
            if (classToLoadName != null && !classToLoadName.isEmpty()) {
                loadedClass = classPathLoader.forName(classToLoadName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(CliStrings.format("Could not find class \"{0}\" specified for \"{1}\".", classToLoadName, neededFor), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(CliStrings.format("Class \"{0}\" specified for \"{1}\" is not of an expected type.", classToLoadName, neededFor), e);
        }
        return loadedClass;
    }

    private static <K> K newInstance(Class<K> klass, String neededFor) {
        K instance = null;
        try {
            instance = klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CliStrings.format("Could not instantiate class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CliStrings.format("Could not access class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        return instance;
    }

    @Override
    public String getId() {
        return ID;
    }
}

