/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.cli.functions.RegionFunctionArgs;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.util.RegionPath;
import com.gemstone.gemfire.management.internal.configuration.domain.XmlEntity;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class RegionAlterFunction
extends FunctionAdapter
implements InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = -4846425364943216425L;

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public void execute(FunctionContext context) {
        ResultSender<CliFunctionResult> resultSender = context.getResultSender();
        Cache cache = CacheFactory.getAnyInstance();
        String memberNameOrId = CliUtil.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        RegionFunctionArgs regionAlterArgs = (RegionFunctionArgs)context.getArguments();
        try {
            Region<?, ?> alteredRegion = this.alterRegion(cache, regionAlterArgs);
            XmlEntity xmlEntity = new XmlEntity("region", "name", alteredRegion.getName());
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, xmlEntity, CliStrings.format("Region \"{0}\" altered on \"{1}\"", alteredRegion.getFullPath(), memberNameOrId)));
        }
        catch (IllegalStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, false, e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, false, e.getMessage()));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error(th.getMessage(), th);
            String exceptionMsg = th.getMessage();
            if (exceptionMsg == null) {
                exceptionMsg = CliUtil.stackTraceAsString(th);
            }
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, false, exceptionMsg));
        }
    }

    private <K, V> Region<?, ?> alterRegion(Cache cache, RegionFunctionArgs regionAlterArgs) {
        String cacheWriter;
        String cacheLoader;
        Set<String> newCacheListenerNames;
        Set<String> newAsyncEventQueueIds;
        Set<String> newGatewaySenderIds;
        RegionFunctionArgs.ExpirationAttrs newRegionExpirationTTL;
        RegionFunctionArgs.ExpirationAttrs newRegionExpirationIdleTime;
        RegionFunctionArgs.ExpirationAttrs newEntryExpirationTTL;
        RegionFunctionArgs.ExpirationAttrs newEntryExpirationIdleTime;
        String regionPathString = regionAlterArgs.getRegionPath();
        RegionPath regionPath = new RegionPath(regionPathString);
        AbstractRegion region = (AbstractRegion)cache.getRegion(regionPathString);
        if (region == null) {
            throw new IllegalArgumentException(CliStrings.format("Region doesn't exist: {0}", new Object[]{regionPath}));
        }
        AttributesMutator mutator = region.getAttributesMutator();
        if (regionAlterArgs.isCloningEnabled() != null) {
            mutator.setCloningEnabled(regionAlterArgs.isCloningEnabled());
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cloning");
            }
        }
        if (regionAlterArgs.getEvictionMax() != null) {
            mutator.getEvictionAttributesMutator().setMaximum(regionAlterArgs.getEvictionMax());
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - eviction attributes max");
            }
        }
        if ((newEntryExpirationIdleTime = regionAlterArgs.getEntryExpirationIdleTime()) != null) {
            mutator.setEntryIdleTimeout(this.parseExpirationAttributes(newEntryExpirationIdleTime, region.getEntryIdleTimeout()));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - entry idle timeout");
            }
        }
        if ((newEntryExpirationTTL = regionAlterArgs.getEntryExpirationTTL()) != null) {
            mutator.setEntryTimeToLive(this.parseExpirationAttributes(newEntryExpirationTTL, region.getEntryTimeToLive()));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - entry TTL");
            }
        }
        if ((newRegionExpirationIdleTime = regionAlterArgs.getRegionExpirationIdleTime()) != null) {
            mutator.setRegionIdleTimeout(this.parseExpirationAttributes(newRegionExpirationIdleTime, region.getRegionIdleTimeout()));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - region idle timeout");
            }
        }
        if ((newRegionExpirationTTL = regionAlterArgs.getRegionExpirationTTL()) != null) {
            mutator.setRegionTimeToLive(this.parseExpirationAttributes(newRegionExpirationTTL, region.getRegionTimeToLive()));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - region TTL");
            }
        }
        if ((newGatewaySenderIds = regionAlterArgs.getGatewaySenderIds()) != null) {
            Set<String> oldGatewaySenderIds = region.getGatewaySenderIds();
            if (!oldGatewaySenderIds.isEmpty()) {
                for (String gatewaySenderId : oldGatewaySenderIds) {
                    if (newGatewaySenderIds.contains(gatewaySenderId)) continue;
                    mutator.removeGatewaySenderId(gatewaySenderId);
                }
            }
            for (String gatewaySenderId : newGatewaySenderIds) {
                if (oldGatewaySenderIds.contains(gatewaySenderId)) continue;
                mutator.addGatewaySenderId(gatewaySenderId);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - gateway sender IDs");
            }
        }
        if ((newAsyncEventQueueIds = regionAlterArgs.getAsyncEventQueueIds()) != null) {
            Set<String> oldAsyncEventQueueIds = region.getAsyncEventQueueIds();
            if (!oldAsyncEventQueueIds.isEmpty()) {
                for (String asyncEventQueueId : oldAsyncEventQueueIds) {
                    if (newAsyncEventQueueIds.contains(asyncEventQueueId)) continue;
                    mutator.removeAsyncEventQueueId(asyncEventQueueId);
                }
            }
            for (String asyncEventQueueId : newAsyncEventQueueIds) {
                if (oldAsyncEventQueueIds.contains(asyncEventQueueId)) continue;
                mutator.addAsyncEventQueueId(asyncEventQueueId);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - async event queue IDs");
            }
        }
        if ((newCacheListenerNames = regionAlterArgs.getCacheListeners()) != null) {
            CacheListener[] oldCacheListeners;
            for (CacheListener oldCacheListener : oldCacheListeners = region.getCacheListeners()) {
                if (newCacheListenerNames.contains(oldCacheListener.getClass().getName())) continue;
                mutator.removeCacheListener(oldCacheListener);
            }
            for (String newCacheListenerName : newCacheListenerNames) {
                boolean nameFound = false;
                for (CacheListener oldCacheListener : oldCacheListeners) {
                    if (!oldCacheListener.getClass().getName().equals(newCacheListenerName)) continue;
                    nameFound = true;
                    break;
                }
                if (nameFound) continue;
                Class<K> cacheListenerKlass = RegionAlterFunction.forName(newCacheListenerName, "cache-listener");
                mutator.addCacheListener((CacheListener)RegionAlterFunction.newInstance(cacheListenerKlass, "cache-listener"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache listeners");
            }
        }
        if ((cacheLoader = regionAlterArgs.getCacheLoader()) != null) {
            if (cacheLoader.isEmpty()) {
                mutator.setCacheLoader(null);
            } else {
                Class<K> cacheLoaderKlass = RegionAlterFunction.forName(cacheLoader, "cache-loader");
                mutator.setCacheLoader((CacheLoader)RegionAlterFunction.newInstance(cacheLoaderKlass, "cache-loader"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache loader");
            }
        }
        if ((cacheWriter = regionAlterArgs.getCacheWriter()) != null) {
            if (cacheWriter.isEmpty()) {
                mutator.setCacheWriter(null);
            } else {
                Class<K> cacheWriterKlass = RegionAlterFunction.forName(cacheWriter, "cache-writer");
                mutator.setCacheWriter((CacheWriter)RegionAlterFunction.newInstance(cacheWriterKlass, "cache-writer"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache writer");
            }
        }
        return region;
    }

    private ExpirationAttributes parseExpirationAttributes(RegionFunctionArgs.ExpirationAttrs newExpirationAttrs, ExpirationAttributes oldExpirationAttributes) {
        ExpirationAction action = oldExpirationAttributes.getAction();
        int timeout = oldExpirationAttributes.getTimeout();
        if (newExpirationAttrs.getTime() != null) {
            timeout = newExpirationAttrs.getTime();
        }
        if (newExpirationAttrs.getAction() != null) {
            action = newExpirationAttrs.getAction();
        }
        return new ExpirationAttributes(timeout, action);
    }

    private static <K> Class<K> forName(String classToLoadName, String neededFor) {
        Class<?> loadedClass = null;
        try {
            ClassPathLoader classPathLoader = ClassPathLoader.getLatest();
            if (classToLoadName != null && !classToLoadName.isEmpty()) {
                loadedClass = classPathLoader.forName(classToLoadName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(CliStrings.format("Could not find class \"{0}\" specified for \"{1}\".", classToLoadName, neededFor), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(CliStrings.format("Class \"{0}\" specified for \"{1}\" is not of an expected type.", classToLoadName, neededFor), e);
        }
        return loadedClass;
    }

    private static <K> K newInstance(Class<K> klass, String neededFor) {
        K instance = null;
        try {
            instance = klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CliStrings.format("Could not instantiate class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CliStrings.format("Could not access class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        return instance;
    }

    @Override
    public String getId() {
        return RegionAlterFunction.class.getName();
    }
}

