/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.InternalCache;
import com.gemstone.gemfire.management.internal.cli.domain.DiskStoreDetails;
import java.util.HashSet;
import java.util.Properties;

public class ListDiskStoresFunction
extends FunctionAdapter
implements InternalEntity {
    public void init(Properties props) {
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    protected Cache getCache() {
        return CacheFactory.getAnyInstance();
    }

    @Override
    public void execute(FunctionContext context) {
        HashSet<DiskStoreDetails> memberDiskStores = new HashSet<DiskStoreDetails>();
        try {
            Cache cache = this.getCache();
            if (cache instanceof InternalCache) {
                InternalCache gemfireCache = (InternalCache)cache;
                DistributedMember member = gemfireCache.getMyId();
                for (DiskStore diskStore : gemfireCache.listDiskStoresIncludingRegionOwned()) {
                    memberDiskStores.add(new DiskStoreDetails(diskStore.getDiskStoreUUID(), diskStore.getName(), member.getId(), member.getName()));
                }
            }
            context.getResultSender().lastResult(memberDiskStores);
        }
        catch (Exception e) {
            context.getResultSender().sendException(e);
        }
    }
}

