/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.SharedConfiguration;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.configuration.utils.ZipUtils;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class ImportSharedConfigurationArtifactsFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FunctionContext context) {
        Object[] args = (Object[])context.getArguments();
        String zipFileName = (String)args[0];
        byte[] zipFileData = (byte[])args[1];
        InternalLocator locator = InternalLocator.getLocator();
        String memberName = locator.getDistributedSystem().getName();
        if (locator.isSharedConfigurationRunning()) {
            File zippedSharedConfiguration = new File(zipFileName);
            try {
                SharedConfiguration sc = locator.getSharedConfiguration();
                sc.renameExistingSharedConfigDirectory();
                sc.clearSharedConfiguration();
                FileUtils.writeByteArrayToFile((File)zippedSharedConfiguration, (byte[])zipFileData);
                ZipUtils.unzip(zipFileName, sc.getSharedConfigurationDirPath());
                CliFunctionResult cliFunctionResult = new CliFunctionResult(memberName, true, "Cluster configuration artifacts successfully copied");
                context.getResultSender().lastResult(cliFunctionResult);
            }
            catch (Exception e) {
                CliFunctionResult result = new CliFunctionResult(memberName, e, CliUtil.stackTraceAsString(e));
                context.getResultSender().lastResult(result);
            }
            finally {
                FileUtils.deleteQuietly((File)zippedSharedConfiguration);
            }
        } else {
            CliFunctionResult cliFunctionResult = new CliFunctionResult(memberName, false, "Cluster configuration service is enabled but has not started yet.");
            context.getResultSender().lastResult(cliFunctionResult);
        }
    }

    @Override
    public String getId() {
        return ImportSharedConfigurationArtifactsFunction.class.getName();
    }
}

