/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.management.internal.cli.domain.RegionDescriptionPerMember;

public class GetRegionDescriptionFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String regionPath = (String)context.getArguments();
        try {
            Cache cache = CacheFactory.getAnyInstance();
            Region region = cache.getRegion(regionPath);
            if (region != null) {
                String memberName = cache.getDistributedSystem().getDistributedMember().getName();
                RegionDescriptionPerMember regionDescription = new RegionDescriptionPerMember(region, memberName);
                context.getResultSender().lastResult(regionDescription);
            } else {
                context.getResultSender().lastResult(null);
            }
        }
        catch (CacheClosedException e) {
            context.getResultSender().sendException(e);
        }
        catch (Exception e) {
            context.getResultSender().sendException(e);
        }
    }

    @Override
    public String getId() {
        return GetRegionDescriptionFunction.class.toString();
    }
}

