/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import java.util.HashMap;

public class GarbageCollectionFunction
implements Function,
InternalEntity {
    public static final String ID = GarbageCollectionFunction.class.getName();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        StringBuilder str1 = new StringBuilder();
        HashMap<String, String> resultMap = null;
        try {
            Cache cache = CacheFactory.getAnyInstance();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            long freeMemoeryBeforeGC = Runtime.getRuntime().freeMemory();
            long totalMemoryBeforeGC = Runtime.getRuntime().totalMemory();
            long timeBeforeGC = System.currentTimeMillis();
            Runtime.getRuntime().gc();
            long freeMemoeryAfterGC = Runtime.getRuntime().freeMemory();
            long totalMemoryAfterGC = Runtime.getRuntime().totalMemory();
            long timeAfterGC = System.currentTimeMillis();
            long megaBytes = 131072L;
            resultMap = new HashMap<String, String>();
            resultMap.put("MemberId", member.getId());
            resultMap.put("HeapSizeBeforeGC", String.valueOf((totalMemoryBeforeGC - freeMemoeryBeforeGC) / megaBytes));
            resultMap.put("HeapSizeAfterGC", String.valueOf((totalMemoryAfterGC - freeMemoeryAfterGC) / megaBytes));
            resultMap.put("TimeSpentInGC", String.valueOf(timeAfterGC - timeBeforeGC));
        }
        catch (Exception ex) {
            str1.append("Exception in GC:" + ex.getMessage() + CliUtil.stackTraceAsString(ex));
            context.getResultSender().lastResult(str1.toString());
        }
        context.getResultSender().lastResult(resultMap);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

