/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.snapshot.RegionSnapshotService;
import com.gemstone.gemfire.cache.snapshot.SnapshotOptions;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import java.io.File;

public class ExportDataFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String[] args = (String[])context.getArguments();
        String regionName = args[0];
        String fileName = args[1];
        try {
            Cache cache = CacheFactory.getAnyInstance();
            Region region = cache.getRegion(regionName);
            String hostName = cache.getDistributedSystem().getDistributedMember().getHost();
            if (region == null) {
                throw new IllegalArgumentException(CliStrings.format("Region : {0} not found", (Object)regionName));
            }
            RegionSnapshotService snapshotService = region.getSnapshotService();
            File exportFile = new File(fileName);
            snapshotService.save(exportFile, SnapshotOptions.SnapshotFormat.GEMFIRE);
            String successMessage = CliStrings.format("Data succesfully exported from region : {0} to file : {1} on host : {2}", regionName, exportFile.getCanonicalPath(), hostName);
            context.getResultSender().lastResult(successMessage);
        }
        catch (Exception e) {
            context.getResultSender().sendException(e);
        }
    }

    @Override
    public String getId() {
        return ExportDataFunction.class.getName();
    }
}

