/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionConfigImpl;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.ConfigSource;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class ExportConfigFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = ExportConfigFunction.class.getName();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            Cache cache = CacheFactory.getAnyInstance();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            StringWriter xmlWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(xmlWriter);
            CacheXmlGenerator.generate(cache, printWriter, true, false, false);
            printWriter.close();
            DistributionConfigImpl config = (DistributionConfigImpl)((InternalDistributedSystem)cache.getDistributedSystem()).getConfig();
            StringBuffer propStringBuf = new StringBuffer();
            String lineSeparator = System.getProperty("line.separator");
            for (Map.Entry<String, String> entry : config.getConfigPropsFromSource(ConfigSource.runtime()).entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) continue;
                propStringBuf.append((Object)entry.getKey()).append("=").append((Object)entry.getValue()).append(lineSeparator);
            }
            for (Map.Entry<String, String> entry : config.getConfigPropsFromSource(ConfigSource.api()).entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) continue;
                propStringBuf.append((Object)entry.getKey()).append("=").append((Object)entry.getValue()).append(lineSeparator);
            }
            for (Map.Entry<String, String> entry : config.getConfigPropsDefinedUsingFiles().entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) continue;
                propStringBuf.append((Object)entry.getKey()).append("=").append((Object)entry.getValue()).append(lineSeparator);
            }
            for (Map.Entry<String, String> entry : config.getConfigPropsFromSource(ConfigSource.launcher()).entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) continue;
                propStringBuf.append((Object)entry.getKey()).append("=").append((Object)entry.getValue()).append(lineSeparator);
            }
            CliFunctionResult result = new CliFunctionResult(memberId, (Serializable[])new String[]{xmlWriter.toString(), propStringBuf.toString()});
            context.getResultSender().lastResult(result);
        }
        catch (CacheClosedException cce) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult(result);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error("Could not export config {}", th.getMessage(), th);
            CliFunctionResult result = new CliFunctionResult(memberId, th, null);
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

