/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.management.internal.cli.domain.IndexInfo;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.configuration.domain.XmlEntity;
import java.util.List;

public class DestroyIndexFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        IndexInfo indexInfo = (IndexInfo)context.getArguments();
        String memberId = null;
        try {
            Cache cache = CacheFactory.getAnyInstance();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            QueryService queryService = cache.getQueryService();
            String indexName = indexInfo.getIndexName();
            String regionPath = indexInfo.getRegionPath();
            XmlEntity xmlEntity = new XmlEntity("region", "name", regionPath, "index", "name", indexName);
            if (regionPath != null && !regionPath.isEmpty()) {
                Region region = cache.getRegion(regionPath);
                if (region != null) {
                    if (indexName == null || indexName.isEmpty()) {
                        queryService.removeIndexes(region);
                        context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity));
                    } else {
                        Index index2 = queryService.getIndex(region, indexName);
                        if (index2 != null) {
                            queryService.removeIndex(index2);
                            context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity));
                        } else {
                            context.getResultSender().lastResult(new CliFunctionResult(memberId, false, CliStrings.format("Index named \"{0}\" not found", (Object)indexName)));
                        }
                    }
                } else {
                    context.getResultSender().lastResult(new CliFunctionResult(memberId, false, CliStrings.format("Region \"{0}\" not found", (Object)regionPath)));
                }
            } else if (indexName == null || indexName.isEmpty()) {
                queryService.removeIndexes();
                context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity));
            } else if (this.removeIndexByName(indexName, queryService)) {
                context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity));
            } else {
                context.getResultSender().lastResult(new CliFunctionResult(memberId, false, CliStrings.format("Index named \"{0}\" not found", (Object)indexName)));
            }
        }
        catch (CacheClosedException e) {
            context.getResultSender().lastResult(new CliFunctionResult(memberId, e, e.getMessage()));
        }
        catch (Exception e) {
            context.getResultSender().lastResult(new CliFunctionResult(memberId, e, e.getMessage()));
        }
    }

    private boolean removeIndexByName(String name, QueryService queryService) {
        List indexes = (List)queryService.getIndexes();
        boolean removed = false;
        if (indexes != null) {
            for (Index index2 : indexes) {
                if (!index2.getName().equals(name)) continue;
                queryService.removeIndex(index2);
                removed = true;
            }
        }
        return removed;
    }

    @Override
    public String getId() {
        return DestroyIndexFunction.class.getName();
    }
}

