/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.cli.functions.CreateDiskStoreFunction;
import com.gemstone.gemfire.management.internal.configuration.domain.XmlEntity;
import org.apache.logging.log4j.Logger;

public class DestroyDiskStoreFunction
extends FunctionAdapter
implements InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            CliFunctionResult result;
            DiskStore diskStore;
            Object[] args = (Object[])context.getArguments();
            String diskStoreName = (String)args[0];
            GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
            InternalDistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            if ((diskStore = cache.findDiskStore(diskStoreName)) != null) {
                XmlEntity xmlEntity = new XmlEntity("disk-store", "name", diskStoreName);
                diskStore.destroy();
                result = new CliFunctionResult(memberId, xmlEntity, "Success");
            } else {
                result = new CliFunctionResult(memberId, false, "Disk store not found on this member");
            }
            context.getResultSender().lastResult(result);
        }
        catch (IllegalStateException isex) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, isex.getMessage());
            context.getResultSender().lastResult(result);
        }
        catch (CacheClosedException cce) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult(result);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error("Could not destroy disk store: {}", th.getMessage(), th);
            CliFunctionResult result = new CliFunctionResult(memberId, th, null);
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return CreateDiskStoreFunction.class.getName();
    }
}

