/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayEventSubstitutionFilter;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.cli.functions.CreateDiskStoreFunction;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.configuration.domain.XmlEntity;
import com.gemstone.joptsimple.internal.Strings;
import java.util.HashMap;
import java.util.Properties;
import org.apache.logging.log4j.Logger;

public class CreateAsyncEventQueueFunction
extends FunctionAdapter
implements InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            Object[] args = (Object[])context.getArguments();
            String asyncEventQueueId = (String)args[0];
            boolean isParallel = (Boolean)args[1];
            boolean enableBatchConflation = (Boolean)args[2];
            int batchSize = (Integer)args[3];
            int batchTimeInterval = (Integer)args[4];
            boolean persistent = (Boolean)args[5];
            String diskStoreName = (String)args[6];
            boolean diskSynchronous = (Boolean)args[7];
            int maxQueueMemory = (Integer)args[8];
            int dispatcherThreads = (Integer)args[9];
            String orderPolicy = (String)args[10];
            String[] gatewayEventFilters = (String[])args[11];
            String gatewaySubstitutionListener = (String)args[12];
            String listenerClassName = (String)args[13];
            Properties listenerProperties = (Properties)args[14];
            GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
            InternalDistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            AsyncEventQueueFactory asyncEventQueueFactory = cache.createAsyncEventQueueFactory();
            asyncEventQueueFactory.setParallel(isParallel);
            asyncEventQueueFactory.setBatchConflationEnabled(enableBatchConflation);
            asyncEventQueueFactory.setBatchSize(batchSize);
            asyncEventQueueFactory.setBatchTimeInterval(batchTimeInterval);
            asyncEventQueueFactory.setPersistent(persistent);
            asyncEventQueueFactory.setDiskStoreName(diskStoreName);
            asyncEventQueueFactory.setDiskSynchronous(diskSynchronous);
            asyncEventQueueFactory.setMaximumQueueMemory(maxQueueMemory);
            asyncEventQueueFactory.setDispatcherThreads(dispatcherThreads);
            asyncEventQueueFactory.setOrderPolicy(Gateway.OrderPolicy.valueOf(orderPolicy));
            if (gatewayEventFilters != null) {
                for (String gatewayEventFilter : gatewayEventFilters) {
                    Class<?> gatewayEventFilterKlass = this.forName(gatewayEventFilter, "gateway-event-filter");
                    asyncEventQueueFactory.addGatewayEventFilter((GatewayEventFilter)CreateAsyncEventQueueFunction.newInstance(gatewayEventFilterKlass, "gateway-event-filter"));
                }
            }
            if (gatewaySubstitutionListener != null) {
                Class<?> gatewayEventSubstitutionListenerKlass = this.forName(gatewaySubstitutionListener, "gateway-event-substitution-listener");
                asyncEventQueueFactory.setGatewayEventSubstitutionListener((GatewayEventSubstitutionFilter)CreateAsyncEventQueueFunction.newInstance(gatewayEventSubstitutionListenerKlass, "gateway-event-substitution-listener"));
            }
            Class<?> listenerClass = InternalDataSerializer.getCachedClass(listenerClassName);
            Object listenerInstance = listenerClass.newInstance();
            if (listenerProperties != null && !listenerProperties.isEmpty()) {
                if (!(listenerInstance instanceof Declarable)) {
                    throw new IllegalArgumentException("Listener properties were provided, but the listener specified does not implement Declarable.");
                }
                ((Declarable)listenerInstance).init(listenerProperties);
                HashMap<Declarable, Properties> declarablesMap = new HashMap<Declarable, Properties>();
                declarablesMap.put((Declarable)listenerInstance, listenerProperties);
                cache.addDeclarableProperties(declarablesMap);
            }
            asyncEventQueueFactory.create(asyncEventQueueId, (AsyncEventListener)listenerInstance);
            XmlEntity xmlEntity = new XmlEntity("async-event-queue", "id", asyncEventQueueId);
            context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity, "Success"));
        }
        catch (CacheClosedException cce) {
            context.getResultSender().lastResult(new CliFunctionResult(memberId, false, null));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error("Could not create async event queue: {}", th.getMessage(), th);
            context.getResultSender().lastResult(new CliFunctionResult(memberId, th, null));
        }
    }

    private Class<?> forName(String className, String neededFor) {
        if (Strings.isNullOrEmpty(className)) {
            return null;
        }
        try {
            return ClassPathLoader.getLatest().forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(CliStrings.format("Could not find class \"{0}\" specified for \"{1}\".", className, neededFor), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(CliStrings.format("Class \"{0}\" specified for \"{1}\" is not of an expected type.", className, neededFor), e);
        }
    }

    private static Object newInstance(Class<?> klass, String neededFor) {
        try {
            return klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CliStrings.format("Could not instantiate class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CliStrings.format("Could not access class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
    }

    @Override
    public String getId() {
        return CreateDiskStoreFunction.class.getName();
    }
}

