/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.AcceptorImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import java.io.Serializable;
import java.util.Collection;

public class ContunuousQueryFunction
implements Function,
InternalEntity {
    public static final String ID = ContunuousQueryFunction.class.getName();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        try {
            CacheClientNotifier cacheClientNotifier;
            AcceptorImpl acceptorImpl;
            BridgeServerImpl server;
            String clientID = (String)context.getArguments();
            GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
            if (cache.getCacheServers().size() > 0 && (server = (BridgeServerImpl)cache.getCacheServers().iterator().next()) != null && (acceptorImpl = server.getAcceptor()) != null && (cacheClientNotifier = acceptorImpl.getCacheClientNotifier()) != null) {
                Collection<CacheClientProxy> cacheClientProxySet = cacheClientNotifier.getClientProxies();
                ClientInfo clientInfo = null;
                boolean foundClientinCCP = false;
                for (CacheClientProxy ccp : cacheClientProxySet) {
                    String clientIdFromProxy;
                    if (ccp == null || (clientIdFromProxy = ccp.getProxyID().getDSMembership()) == null || !clientIdFromProxy.equals(clientID)) continue;
                    foundClientinCCP = true;
                    String durableId = ccp.getProxyID().getDurableId();
                    boolean isPrimary = ccp.isPrimary();
                    clientInfo = new ClientInfo(durableId != null && durableId.length() > 0 ? "Yes" : "No", isPrimary ? cache.getDistributedSystem().getDistributedMember().getId() : "", !isPrimary ? cache.getDistributedSystem().getDistributedMember().getId() : "");
                    break;
                }
                if (!foundClientinCCP) {
                    ServerConnection[] serverConnections;
                    for (ServerConnection conn : serverConnections = acceptorImpl.getAllServerConnectionList()) {
                        ClientProxyMembershipID cliIdFrmProxy = conn.getProxyID();
                        if (!clientID.equals(cliIdFrmProxy.getDSMembership())) continue;
                        String durableId = cliIdFrmProxy.getDurableId();
                        clientInfo = new ClientInfo(durableId != null && durableId.length() > 0 ? "Yes" : "No", "N.A.", "N.A.");
                    }
                }
                context.getResultSender().lastResult(clientInfo);
            }
        }
        catch (Exception e) {
            context.getResultSender().lastResult("Exception in ContunuousQueryFunction =" + e.getMessage());
        }
        context.getResultSender().lastResult(null);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }

    public class ClientInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String isDurable;
        public String primaryServer;
        public String secondaryServer;

        public ClientInfo(String IsClientDurable, String primaryServerId, String secondaryServerId) {
            this.isDurable = IsClientDurable;
            this.primaryServer = primaryServerId;
            this.secondaryServer = secondaryServerId;
        }

        public String toString() {
            return "ClientInfo [isDurable=" + this.isDurable + ", primaryServer=" + this.primaryServer + ", secondaryServer=" + this.secondaryServer + "]";
        }
    }
}

