/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.domain.MemberResult;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;

public class CloseDurableClientFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FunctionContext context) {
        String durableClientId = (String)context.getArguments();
        Cache cache = CliUtil.getCacheIfExists();
        String memberNameOrId = CliUtil.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        MemberResult memberResult = new MemberResult(memberNameOrId);
        try {
            CacheClientNotifier cacheClientNotifier = CacheClientNotifier.getInstance();
            if (cacheClientNotifier != null) {
                CacheClientProxy ccp = cacheClientNotifier.getClientProxy(durableClientId);
                if (ccp != null) {
                    boolean isClosed = cacheClientNotifier.closeDurableClientProxy(durableClientId);
                    if (isClosed) {
                        memberResult.setSuccessMessage(CliStrings.format("Closed the durable client : \"{0}\".", (Object)durableClientId));
                    } else {
                        memberResult.setErrorMessage(CliStrings.format("No client found with client-id : {0}", (Object)durableClientId));
                    }
                } else {
                    memberResult.setErrorMessage(CliStrings.format("No client found with client-id : {0}", (Object)durableClientId));
                }
            } else {
                memberResult.setErrorMessage("No client found on this server");
            }
        }
        catch (Exception e) {
            memberResult.setExceptionMessage(e.getMessage());
        }
        finally {
            context.getResultSender().lastResult(memberResult);
        }
    }

    @Override
    public String getId() {
        return CloseDurableClientFunction.class.getName();
    }
}

