/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.domain;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.management.internal.cli.domain.EvictionAttributesInfo;
import com.gemstone.gemfire.management.internal.cli.domain.FixedPartitionAttributesInfo;
import com.gemstone.gemfire.management.internal.cli.domain.PartitionAttributesInfo;
import com.gemstone.gemfire.management.internal.cli.domain.RegionAttributesInfo;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RegionDescriptionPerMember
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int size = 0;
    private RegionAttributesInfo regionAttributesInfo;
    private String hostingMember;
    private String name;
    private boolean isAccessor = false;

    public RegionDescriptionPerMember(Region<?, ?> region, String hostingMember) {
        this.regionAttributesInfo = new RegionAttributesInfo(region.getAttributes());
        this.hostingMember = hostingMember;
        this.size = region.size();
        this.name = region.getFullPath().substring(1);
        if (this.regionAttributesInfo.getDataPolicy().equals(DataPolicy.EMPTY) && this.regionAttributesInfo.getScope().equals(Scope.DISTRIBUTED_ACK)) {
            this.setAccessor(true);
        }
        if (this.regionAttributesInfo.getPartitionAttributesInfo() != null && this.regionAttributesInfo.getPartitionAttributesInfo().getLocalMaxMemory() == 0) {
            this.setAccessor(true);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RegionDescriptionPerMember) {
            RegionDescriptionPerMember regionDesc = (RegionDescriptionPerMember)obj;
            return this.name.equals(regionDesc.getName()) && this.getScope().equals(regionDesc.getScope()) && this.getDataPolicy().equals(regionDesc.getDataPolicy()) && this.isAccessor == regionDesc.isAccessor;
        }
        return true;
    }

    public int hashCode() {
        return 42;
    }

    public String getHostingMember() {
        return this.hostingMember;
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public Scope getScope() {
        return this.regionAttributesInfo.getScope();
    }

    public DataPolicy getDataPolicy() {
        return this.regionAttributesInfo.getDataPolicy();
    }

    public Map<String, String> getNonDefaultRegionAttributes() {
        this.regionAttributesInfo.getNonDefaultAttributes().put("size", Integer.toString(this.size));
        return this.regionAttributesInfo.getNonDefaultAttributes();
    }

    public Map<String, String> getNonDefaultEvictionAttributes() {
        EvictionAttributesInfo eaInfo = this.regionAttributesInfo.getEvictionAttributesInfo();
        if (eaInfo != null) {
            return eaInfo.getNonDefaultAttributes();
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getNonDefaultPartitionAttributes() {
        PartitionAttributesInfo paInfo = this.regionAttributesInfo.getPartitionAttributesInfo();
        if (paInfo != null) {
            return paInfo.getNonDefaultAttributes();
        }
        return Collections.emptyMap();
    }

    public List<FixedPartitionAttributesInfo> getFixedPartitionAttributes() {
        PartitionAttributesInfo paInfo = this.regionAttributesInfo.getPartitionAttributesInfo();
        List<FixedPartitionAttributesInfo> fpa = null;
        if (paInfo != null) {
            fpa = paInfo.getFixedPartitionAttributesInfo();
        }
        return fpa;
    }

    public boolean isAccessor() {
        return this.isAccessor;
    }

    public void setAccessor(boolean isAccessor) {
        this.isAccessor = isAccessor;
    }
}

