/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.converters;

import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class MemberGroupConverter
implements Converter<String> {
    public boolean supports(Class<?> type, String optionContext) {
        return String.class.equals(type) && "converter.hint.member.groups".equals(optionContext);
    }

    public String convertFromText(String value2, Class<?> targetType, String optionContext) {
        return value2;
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        if (String.class.equals(targetType) && "converter.hint.member.groups".equals(optionContext)) {
            String[] memberGroupNames;
            for (String memberGroupName : memberGroupNames = this.getMemberGroupNames()) {
                completions.add(new Completion(memberGroupName));
            }
        }
        return !completions.isEmpty();
    }

    public Set<String> getMemberGroups() {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        TreeSet<String> memberGroups = new TreeSet<String>();
        if (gfsh != null && gfsh.isConnectedAndReady()) {
            String[] memberGroupsArray = gfsh.getOperationInvoker().getDistributedSystemMXBean().listGroups();
            memberGroups.addAll(Arrays.asList(memberGroupsArray));
        }
        return memberGroups;
    }

    private String[] getMemberGroupNames() {
        Set<String> memberGroups = this.getMemberGroups();
        return memberGroups.toArray(new String[memberGroups.size()]);
    }
}

