/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.converters;

import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class GatewaySenderIdConverter
implements Converter<String> {
    public boolean supports(Class<?> type, String optionContext) {
        return String.class.equals(type) && "converter.hint.gateway.senderid".equals(optionContext);
    }

    public String convertFromText(String value2, Class<?> targetType, String optionContext) {
        return value2;
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        if (String.class.equals(targetType) && "converter.hint.gateway.senderid".equals(optionContext)) {
            Set<String> gatewaySenderIds = this.getGatewaySenderIds();
            for (String gatewaySenderId : gatewaySenderIds) {
                completions.add(new Completion(gatewaySenderId));
            }
        }
        return !completions.isEmpty();
    }

    public Set<String> getGatewaySenderIds() {
        String[] gatewaySenderIdArray;
        Set<String> gatewaySenderIds = Collections.emptySet();
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null && gfsh.isConnectedAndReady() && (gatewaySenderIdArray = (String[])gfsh.getOperationInvoker().invoke("GemFire:service=System,type=Distributed", "listGatwaySenders", new Object[0], new String[0])) != null && gatewaySenderIdArray.length != 0) {
            gatewaySenderIds = new TreeSet<String>(Arrays.asList(gatewaySenderIdArray));
        }
        return gatewaySenderIds;
    }
}

