/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.management.cli.CliMetaData;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.LogWrapper;
import com.gemstone.gemfire.management.internal.cli.domain.FixedPartitionAttributesInfo;
import com.gemstone.gemfire.management.internal.cli.domain.RegionDescription;
import com.gemstone.gemfire.management.internal.cli.domain.RegionDescriptionPerMember;
import com.gemstone.gemfire.management.internal.cli.domain.RegionInformation;
import com.gemstone.gemfire.management.internal.cli.functions.GetRegionDescriptionFunction;
import com.gemstone.gemfire.management.internal.cli.functions.GetRegionsFunction;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.result.CommandResultException;
import com.gemstone.gemfire.management.internal.cli.result.CompositeResultData;
import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class RegionCommands
implements CommandMarker {
    private static final GetRegionsFunction getRegionsFunction = new GetRegionsFunction();
    private static final GetRegionDescriptionFunction getRegionDescription = new GetRegionDescriptionFunction();

    private Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }

    @CliCommand(value={"list regions"}, help="Display regions of a member or members.")
    @CliMetaData(shellOnly=false, relatedTopic={"Region"})
    public Result listRegion(@CliOption(key={"group"}, optionContext="converter.hint.member.groups", help="Group of members for which regions will be displayed.") String group, @CliOption(key={"member"}, optionContext="converter.hint.member.idOrName", help="Name/Id of the member for which regions will be displayed.") String memberNameOrId) {
        Result result = null;
        try {
            Set<DistributedMember> targetMembers;
            LinkedHashSet<RegionInformation> regionInfoSet = new LinkedHashSet<RegionInformation>();
            ResultCollector<?, ?> rc = null;
            try {
                targetMembers = CliUtil.findAllMatchingMembers(group, memberNameOrId);
            }
            catch (CommandResultException crex) {
                return crex.getResult();
            }
            TabularResultData resultData = ResultBuilder.createTabularResultData();
            rc = CliUtil.executeFunction((Function)getRegionsFunction, null, targetMembers);
            ArrayList resultList = (ArrayList)rc.getResult();
            if (resultList != null) {
                for (Object resultObj : resultList) {
                    Object[] resultObjectArray;
                    if (resultObj == null || !(resultObj instanceof Object[])) continue;
                    for (Object regionInfo : resultObjectArray = (Object[])resultObj) {
                        if (!(regionInfo instanceof RegionInformation)) continue;
                        regionInfoSet.add((RegionInformation)regionInfo);
                    }
                }
                TreeSet<String> regionNames = new TreeSet<String>();
                for (RegionInformation regionInfo : regionInfoSet) {
                    regionNames.add(regionInfo.getName());
                    Set<String> subRegionNames = regionInfo.getSubRegionNames();
                    for (String subRegionName : subRegionNames) {
                        regionNames.add(subRegionName);
                    }
                }
                for (String regionName : regionNames) {
                    resultData.accumulate("List of regions", regionName);
                }
                result = !regionNames.isEmpty() ? ResultBuilder.buildResult(resultData) : ResultBuilder.createInfoResult("No Regions Found");
            }
        }
        catch (FunctionInvocationTargetException e) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not execute \" {0} \", please try again ", (Object)"list regions"));
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult("Error occurred while fetching list of regions. : " + e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"describe region"}, help="Display the attributes and key information of a region.")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Configuration"})
    public Result describeRegion(@CliOption(key={"name"}, optionContext="converter.hint.region.path", help="Name/Path of the region to be described.", mandatory=true) String regionName) {
        Result result = null;
        try {
            if (regionName == null || regionName.isEmpty()) {
                return ResultBuilder.createUserErrorResult("Please provide a region name");
            }
            if (regionName.equals("/")) {
                return ResultBuilder.createUserErrorResult("Invalid region name");
            }
            Cache cache = CacheFactory.getAnyInstance();
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)getRegionDescription, (Object)regionName, CliUtil.getAllMembers(cache));
            List resultList = (List)rc.getResult();
            Object[] results = resultList.toArray();
            ArrayList<RegionDescription> regionDescriptionList = new ArrayList<RegionDescription>();
            for (int i = 0; i < results.length; ++i) {
                if (results[i] instanceof RegionDescriptionPerMember) {
                    RegionDescriptionPerMember regionDescPerMember = (RegionDescriptionPerMember)results[i];
                    if (regionDescPerMember == null) continue;
                    RegionDescription regionDescription = new RegionDescription();
                    regionDescription.add(regionDescPerMember);
                    for (int j = i + 1; j < results.length; ++j) {
                        RegionDescriptionPerMember preyRegionDescPerMember;
                        if (results[j] == null || !(results[j] instanceof RegionDescriptionPerMember) || !regionDescription.add(preyRegionDescPerMember = (RegionDescriptionPerMember)results[j])) continue;
                        results[j] = null;
                    }
                    regionDescriptionList.add(regionDescription);
                    continue;
                }
                if (!(results[i] instanceof Throwable)) continue;
                Throwable t = (Throwable)results[i];
                LogWrapper.getInstance().info(t.getMessage(), t);
            }
            if (regionDescriptionList.isEmpty()) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Region : {0} not found", (Object)regionName));
            }
            CompositeResultData crd = ResultBuilder.createCompositeResultData();
            for (RegionDescription regionDescription : regionDescriptionList) {
                if (regionDescription.isPartition()) {
                    regionDescription.getCndRegionAttributes().remove("scope");
                } else {
                    String scope = regionDescription.getCndRegionAttributes().get("scope");
                    if (scope != null) {
                        scope = scope.toLowerCase().replace('_', '-');
                        regionDescription.getCndRegionAttributes().put("scope", scope);
                    }
                }
                CompositeResultData.SectionResultData regionSection = crd.addSection();
                regionSection.addSeparator('-');
                regionSection.addData("Name", regionDescription.getName());
                String dataPolicy = regionDescription.getDataPolicy().toString().toLowerCase().replace('_', ' ');
                regionSection.addData("Data Policy", dataPolicy);
                String memberType = "";
                memberType = regionDescription.isAccessor() ? "Accessor Members" : "Hosting Members";
                regionSection.addData(memberType, CliUtil.convertStringSetToString(regionDescription.getHostingMembers(), '\n'));
                regionSection.addSeparator('.');
                TabularResultData commonNonDefaultAttrTable = regionSection.addSection().addTable();
                commonNonDefaultAttrTable.setHeader(CliStrings.format("Non-Default Attributes Shared By {0}  ", (Object)memberType));
                Map<String, String> cndRegionAttrsMap = regionDescription.getCndRegionAttributes();
                Map<String, String> cndEvictionAttrsMap = regionDescription.getCndEvictionAttributes();
                Map<String, String> cndPartitionAttrsMap = regionDescription.getCndPartitionAttributes();
                this.writeCommonAttributesToTable(commonNonDefaultAttrTable, "Region", cndRegionAttrsMap);
                this.writeCommonAttributesToTable(commonNonDefaultAttrTable, "Eviction", cndEvictionAttrsMap);
                this.writeCommonAttributesToTable(commonNonDefaultAttrTable, "Partition", cndPartitionAttrsMap);
                Map<String, RegionDescriptionPerMember> regDescPerMemberMap = regionDescription.getRegionDescriptionPerMemberMap();
                Set<String> members = regDescPerMemberMap.keySet();
                TabularResultData table = regionSection.addSection().addTable();
                boolean setHeader = false;
                for (String member : members) {
                    RegionDescriptionPerMember regDescPerMem = regDescPerMemberMap.get(member);
                    Map<String, String> ndRa = regDescPerMem.getNonDefaultRegionAttributes();
                    Map<String, String> ndEa = regDescPerMem.getNonDefaultEvictionAttributes();
                    Map<String, String> ndPa = regDescPerMem.getNonDefaultPartitionAttributes();
                    ndRa.keySet().removeAll(cndRegionAttrsMap.keySet());
                    ndEa.keySet().removeAll(cndEvictionAttrsMap.keySet());
                    ndPa.keySet().removeAll(cndPartitionAttrsMap.keySet());
                    if (regionDescription.isPartition() && ndRa.get("scope") != null) {
                        ndRa.remove("scope");
                    }
                    List<FixedPartitionAttributesInfo> fpaList = regDescPerMem.getFixedPartitionAttributes();
                    if (ndRa.isEmpty() && ndEa.isEmpty() && ndPa.isEmpty() && fpaList == null) continue;
                    setHeader = true;
                    boolean memberNameAdded = false;
                    memberNameAdded = this.writeAttributesToTable(table, "Region", ndRa, member, memberNameAdded);
                    memberNameAdded = this.writeAttributesToTable(table, "Eviction", ndEa, member, memberNameAdded);
                    memberNameAdded = this.writeAttributesToTable(table, "Partition", ndPa, member, memberNameAdded);
                    this.writeFixedPartitionAttributesToTable(table, "", fpaList, member, memberNameAdded);
                }
                if (!setHeader) continue;
                table.setHeader(CliStrings.format("Non-Default Attributes Specific To The {0} ", (Object)memberType));
            }
            result = ResultBuilder.buildResult(crd);
        }
        catch (FunctionInvocationTargetException e) {
            result = ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not execute \" {0} \", please try again ", (Object)"describe region"));
        }
        catch (Exception e) {
            String errorMessage = CliStrings.format("Exception : {0} , Message : {1}", e.getClass().getName(), e.getMessage());
            result = ResultBuilder.createGemFireErrorResult(errorMessage);
        }
        return result;
    }

    private void writeCommonAttributesToTable(TabularResultData table, String attributeType, Map<String, String> attributesMap) {
        if (!attributesMap.isEmpty()) {
            Set<String> attributes = attributesMap.keySet();
            boolean isTypeAdded = false;
            String blank = "";
            for (String attributeName : attributes) {
                String type;
                String attributeValue = attributesMap.get(attributeName);
                if (!isTypeAdded) {
                    type = attributeType;
                    isTypeAdded = true;
                } else {
                    type = "";
                }
                this.writeCommonAttributeToTable(table, type, attributeName, attributeValue);
            }
        }
    }

    private boolean writeFixedPartitionAttributesToTable(TabularResultData table, String attributeType, List<FixedPartitionAttributesInfo> fpaList, String member, boolean isMemberNameAdded) {
        if (fpaList != null) {
            boolean isTypeAdded = false;
            String blank = "";
            for (FixedPartitionAttributesInfo fpa : fpaList) {
                String memName;
                String type;
                StringBuilder fpaBuilder = new StringBuilder();
                fpaBuilder.append(fpa.getPartitionName());
                fpaBuilder.append(',');
                if (fpa.isPrimary()) {
                    fpaBuilder.append("Primary");
                } else {
                    fpaBuilder.append("Secondary");
                }
                fpaBuilder.append(',');
                fpaBuilder.append(fpa.getNumBuckets());
                if (!isTypeAdded) {
                    type = attributeType;
                    isTypeAdded = true;
                } else {
                    type = "";
                }
                if (!isMemberNameAdded) {
                    memName = member;
                    isMemberNameAdded = true;
                } else {
                    memName = "";
                }
                this.writeAttributeToTable(table, memName, type, "Fixed Partition", fpaBuilder.toString());
            }
        }
        return isMemberNameAdded;
    }

    private boolean writeAttributesToTable(TabularResultData table, String attributeType, Map<String, String> attributesMap, String member, boolean isMemberNameAdded) {
        if (!attributesMap.isEmpty()) {
            Set<String> attributes = attributesMap.keySet();
            boolean isTypeAdded = false;
            String blank = "";
            for (String attributeName : attributes) {
                String memName;
                String type;
                String attributeValue = attributesMap.get(attributeName);
                if (!isTypeAdded) {
                    type = attributeType;
                    isTypeAdded = true;
                } else {
                    type = "";
                }
                if (!isMemberNameAdded) {
                    memName = member;
                    isMemberNameAdded = true;
                } else {
                    memName = "";
                }
                this.writeAttributeToTable(table, memName, type, attributeName, attributeValue);
            }
        }
        return isMemberNameAdded;
    }

    public void writeAttributeToTable(TabularResultData table, String member, String attributeType, String attributeName, String attributeValue) {
        String blank = "";
        if (attributeValue != null) {
            String[] attributeValues = attributeValue.split(",");
            boolean isFirstValue = true;
            for (String value2 : attributeValues) {
                if (isFirstValue) {
                    table.accumulate("Member", member);
                    table.accumulate("Type", attributeType);
                    table.accumulate("Name", attributeName);
                    table.accumulate("Value", value2);
                    isFirstValue = false;
                    continue;
                }
                table.accumulate("Member", "");
                table.accumulate("Type", "");
                table.accumulate("Name", "");
                table.accumulate("Value", value2);
            }
        }
    }

    private void writeCommonAttributeToTable(TabularResultData table, String attributeType, String attributeName, String attributeValue) {
        String blank = "";
        if (attributeValue != null) {
            String[] attributeValues = attributeValue.split(",");
            boolean isFirstValue = true;
            for (String value2 : attributeValues) {
                if (isFirstValue) {
                    isFirstValue = false;
                    table.accumulate("Type", attributeType);
                    table.accumulate("Name", attributeName);
                    table.accumulate("Value", value2);
                    continue;
                }
                table.accumulate("Type", "");
                table.accumulate("Name", "");
                table.accumulate("Value", value2);
            }
        }
    }

    public void addChildSection(CompositeResultData.SectionResultData parentSection, Map<String, String> map, String header) {
        if (!map.isEmpty()) {
            Set<String> attributes = map.keySet();
            CompositeResultData.SectionResultData section = parentSection.addSection();
            section.setHeader(header);
            for (String attribute : attributes) {
                section.addData(attribute, map.get(attribute));
            }
        }
    }

    @CliAvailabilityIndicator(value={"list regions", "describe region"})
    public boolean isRegionCommandAvailable() {
        boolean isAvailable = true;
        if (CliUtil.isGfshVM()) {
            isAvailable = this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
        }
        return isAvailable;
    }
}

