/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.management.cli.CliMetaData;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.commands.AbstractCommandsSupport;
import com.gemstone.gemfire.management.internal.cli.domain.DurableCqNamesResult;
import com.gemstone.gemfire.management.internal.cli.domain.MemberResult;
import com.gemstone.gemfire.management.internal.cli.domain.SubscriptionQueueSizeResult;
import com.gemstone.gemfire.management.internal.cli.functions.CloseDurableClientFunction;
import com.gemstone.gemfire.management.internal.cli.functions.CloseDurableCqFunction;
import com.gemstone.gemfire.management.internal.cli.functions.GetSubscriptionQueueSizeFunction;
import com.gemstone.gemfire.management.internal.cli.functions.ListDurableCqNamesFunction;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.result.CommandResultException;
import com.gemstone.gemfire.management.internal.cli.result.ErrorResultData;
import com.gemstone.gemfire.management.internal.cli.result.InfoResultData;
import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DurableClientCommands
extends AbstractCommandsSupport {
    private static final ListDurableCqNamesFunction listDurableCqNamesFunction = new ListDurableCqNamesFunction();
    private static final CloseDurableClientFunction closeDurableClientFunction = new CloseDurableClientFunction();
    private static final CloseDurableCqFunction closeDurableCqFunction = new CloseDurableCqFunction();
    private static final GetSubscriptionQueueSizeFunction countDurableCqEvents = new GetSubscriptionQueueSizeFunction();

    @CliCommand(value={"list durable-cqs"}, help="List durable client cqs associated with the specified durable client id.")
    @CliMetaData(shellOnly=false)
    public Result listDurableClientCqs(@CliOption(key={"durable-client-id"}, mandatory=true, help="The id used to identify the durable client") String durableClientId, @CliOption(key={"member"}, help="Name/Id of the member for which the durable client is registered and durable cqs will be displayed.", optionContext="converter.hint.member.idOrName") String memberNameOrId, @CliOption(key={"group"}, help="Group of members for which the durable client is registered and durable cqs will be displayed.", optionContext="converter.hint.member.groups") String group) {
        Result result = null;
        try {
            Set<DistributedMember> targetMembers;
            boolean noResults = true;
            try {
                targetMembers = CliUtil.findAllMatchingMembers(group, memberNameOrId);
            }
            catch (CommandResultException e) {
                return e.getResult();
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)new ListDurableCqNamesFunction(), (Object)durableClientId, targetMembers);
            List results = (List)rc.getResult();
            TreeMap<String, List<String>> memberCqNamesMap = new TreeMap<String, List<String>>();
            HashMap<String, List<String>> errorMessageNodes = new HashMap<String, List<String>>();
            HashMap<String, List<String>> exceptionMessageNodes = new HashMap<String, List<String>>();
            for (DurableCqNamesResult memberResult : results) {
                if (memberResult == null) continue;
                if (memberResult.isSuccessful()) {
                    memberCqNamesMap.put(memberResult.getMemberNameOrId(), memberResult.getCqNamesList());
                    continue;
                }
                if (memberResult.isOpPossible()) {
                    this.groupByMessage(memberResult.getExceptionMessage(), memberResult.getMemberNameOrId(), exceptionMessageNodes);
                    continue;
                }
                this.groupByMessage(memberResult.getErrorMessage(), memberResult.getMemberNameOrId(), errorMessageNodes);
            }
            if (!memberCqNamesMap.isEmpty()) {
                TabularResultData table = ResultBuilder.createTabularResultData();
                Set members = memberCqNamesMap.keySet();
                for (String member : members) {
                    boolean isFirst = true;
                    List cqNames = (List)memberCqNamesMap.get(member);
                    for (String cqName : cqNames) {
                        if (isFirst) {
                            isFirst = false;
                            table.accumulate("member", member);
                        } else {
                            table.accumulate("member", "");
                        }
                        table.accumulate("durable-cq-name", cqName);
                    }
                }
                result = ResultBuilder.buildResult(table);
            } else {
                String errorHeader = CliStrings.format("Unable to list durable-cqs for durable-client-id : \"{0}\" due to following reasons.", (Object)durableClientId);
                result = ResultBuilder.buildResult(this.buildFailureData(null, exceptionMessageNodes, errorMessageNodes, errorHeader));
            }
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"show subscription-queue-size"}, help="Shows the number of events in the subscription queue.  If a cq name is provided, counts the number of events in the subscription queue for the specified cq.")
    @CliMetaData(shellOnly=false)
    public Result countDurableCqEvents(@CliOption(key={"durable-client-id"}, mandatory=true, help="The id used to identify the durable client.") String durableClientId, @CliOption(key={"durable-cq-name"}, mandatory=false, help="The name that identifies the cq.") String cqName, @CliOption(key={"member"}, mandatory=false, help="Name/Id of the member for which the subscription events are to be counted.", optionContext="converter.hint.member.idOrName") String memberNameOrId, @CliOption(key={"group"}, mandatory=false, help="Group of members for which the subscription queue events are to be counted.", optionContext="converter.hint.member.groups") String group) {
        Result result = null;
        try {
            Set<DistributedMember> targetMembers;
            try {
                targetMembers = CliUtil.findAllMatchingMembers(group, memberNameOrId);
            }
            catch (CommandResultException e) {
                return e.getResult();
            }
            String[] params = new String[]{durableClientId, cqName};
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)new GetSubscriptionQueueSizeFunction(), (Object)params, targetMembers);
            List funcResults = (List)rc.getResult();
            String queueSizeColumnName = cqName != null && !cqName.isEmpty() ? CliStrings.format("subcription-queue-size for durable-client : \"{0}\".", (Object)cqName) : CliStrings.format("subcription-queue-size for durable-client : \"{0}\".", (Object)durableClientId);
            result = this.buildTableResultForQueueSize(funcResults, queueSizeColumnName);
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"close durable-client"}, help="Attempts to close the durable client, the client must be disconnected.")
    @CliMetaData(shellOnly=false)
    public Result closeDurableClient(@CliOption(key={"durable-client-id"}, mandatory=true, help="The id used to identify the durable client.") String durableClientId, @CliOption(key={"member"}, mandatory=false, help="Name/Id of the member for which the durable client is to be closed.", optionContext="converter.hint.member.idOrName") String memberNameOrId, @CliOption(key={"group"}, mandatory=false, help="Group of members for which the subscription queue events are to be counted.", optionContext="converter.hint.member.groups") String group) {
        Result result = null;
        try {
            Set<DistributedMember> targetMembers;
            try {
                targetMembers = CliUtil.findAllMatchingMembers(group, memberNameOrId);
            }
            catch (CommandResultException e) {
                return e.getResult();
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)new CloseDurableClientFunction(), (Object)durableClientId, targetMembers);
            List results = (List)rc.getResult();
            String failureHeader = CliStrings.format("Unable to close the durable client : \"{0}\" due to following reasons.", (Object)durableClientId);
            String successHeader = CliStrings.format("Closed the durable client : \"{0}\".", (Object)durableClientId);
            result = this.buildResult(results, successHeader, failureHeader);
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"close durable-cq"}, help="Closes the durable cq registered by the durable client and drain events held for the durable cq from the subscription queue.")
    @CliMetaData(shellOnly=false)
    public Result closeDurableCqs(@CliOption(key={"durable-client-id"}, mandatory=true, help="The id of the durable client") String durableClientId, @CliOption(key={"durable-cq-name"}, mandatory=true, help="Name of the cq to be closed.") String cqName, @CliOption(key={"member"}, mandatory=false, help="Name/Id of the member for which the durable client is registered and the cq to be closed.", optionContext="converter.hint.member.idOrName") String memberNameOrId, @CliOption(key={"group"}, mandatory=false, help="Group of members for which the durable client is registered and the cq to be closed.", optionContext="converter.hint.member.groups") String group) {
        Result result = null;
        try {
            Set<DistributedMember> targetMembers;
            try {
                targetMembers = CliUtil.findAllMatchingMembers(group, memberNameOrId);
            }
            catch (CommandResultException e) {
                return e.getResult();
            }
            String[] params = new String[]{durableClientId, cqName};
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)new CloseDurableCqFunction(), (Object)params, targetMembers);
            List results = (List)rc.getResult();
            String failureHeader = CliStrings.format("Could not close the durable-cq : \"{0}\" for the durable-client-id : \"{1}\" due to following reasons.", cqName, durableClientId);
            String successHeader = CliStrings.format("Closed the durable cq : \"{0}\" for the durable client : \"{1}\".", cqName, durableClientId);
            result = this.buildResult(results, successHeader, failureHeader);
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult(e.getMessage());
        }
        return result;
    }

    private Result buildResult(List<MemberResult> results, String successHeader, String failureHeader) {
        Result result = null;
        boolean failure = true;
        boolean partialFailure = false;
        HashMap<String, List<String>> errorMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> successMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> exceptionMap = new HashMap<String, List<String>>();
        for (MemberResult memberResult : results) {
            if (memberResult.isSuccessful()) {
                failure = false;
                this.groupByMessage(memberResult.getSuccessMessage(), memberResult.getMemberNameOrId(), successMap);
                continue;
            }
            if (memberResult.isOpPossible()) {
                partialFailure = true;
                this.groupByMessage(memberResult.getExceptionMessage(), memberResult.getMemberNameOrId(), exceptionMap);
                continue;
            }
            this.groupByMessage(memberResult.getErrorMessage(), memberResult.getMemberNameOrId(), errorMap);
        }
        result = !failure && !partialFailure ? ResultBuilder.buildResult(this.buildSuccessData(successMap)) : ResultBuilder.buildResult(this.buildFailureData(successMap, exceptionMap, errorMap, failureHeader));
        return result;
    }

    private Result buildTableResultForQueueSize(List<SubscriptionQueueSizeResult> results, String queueSizeColumnName) {
        Result result = null;
        boolean failure = true;
        HashMap<String, List<String>> failureMap = new HashMap<String, List<String>>();
        TreeMap<String, Long> memberQueueSizeTable = new TreeMap<String, Long>();
        for (SubscriptionQueueSizeResult memberResult : results) {
            if (memberResult.isSuccessful()) {
                failure = false;
                memberResult.getSubscriptionQueueSize();
                memberQueueSizeTable.put(memberResult.getMemberNameOrId(), memberResult.getSubscriptionQueueSize());
                continue;
            }
            this.groupByMessage(memberResult.getErrorMessage(), memberResult.getMemberNameOrId(), failureMap);
        }
        if (!failure) {
            TabularResultData table = ResultBuilder.createTabularResultData();
            Set members = memberQueueSizeTable.keySet();
            for (String member : members) {
                long queueSize = (Long)memberQueueSizeTable.get(member);
                table.accumulate("member", member);
                table.accumulate(queueSizeColumnName, queueSize);
            }
            result = ResultBuilder.buildResult(table);
        } else {
            ErrorResultData erd = ResultBuilder.createErrorResultData();
            this.buildErrorResult(erd, failureMap);
            result = ResultBuilder.buildResult(erd);
        }
        return result;
    }

    private void groupByMessage(String message, String memberNameOrId, Map<String, List<String>> map) {
        List<String> members = map.get(message);
        if (members == null) {
            members = new LinkedList<String>();
        }
        members.add(memberNameOrId);
        map.put(message, members);
    }

    private InfoResultData buildSuccessData(Map<String, List<String>> successMap) {
        InfoResultData ird = ResultBuilder.createInfoResultData();
        Set<String> successMessages = successMap.keySet();
        for (String successMessage : successMessages) {
            ird.addLine(CliStrings.format("{0} on following members.", (Object)successMessage));
            List<String> successfullMembers = successMap.get(successMessage);
            int num = 0;
            for (String member : successfullMembers) {
                ird.addLine("" + ++num + "." + member);
            }
            ird.addLine("\n");
        }
        return ird;
    }

    private ErrorResultData buildFailureData(Map<String, List<String>> successMap, Map<String, List<String>> exceptionMap, Map<String, List<String>> errorMap, String errorHeader) {
        ErrorResultData erd = ResultBuilder.createErrorResultData();
        this.buildErrorResult(erd, successMap);
        erd.addLine("\n");
        erd.addLine(errorHeader);
        this.buildErrorResult(erd, exceptionMap);
        this.buildErrorResult(erd, errorMap);
        return erd;
    }

    private void buildErrorResult(ErrorResultData erd, Map<String, List<String>> resultMap) {
        if (resultMap != null && !resultMap.isEmpty()) {
            Set<String> messages = resultMap.keySet();
            for (String message : messages) {
                erd.addLine("\n");
                erd.addLine(message);
                erd.addLine("Occurred on members");
                List<String> members = resultMap.get(message);
                int num = 0;
                for (String member : members) {
                    erd.addLine("" + ++num + "." + member);
                }
            }
        }
    }

    @CliAvailabilityIndicator(value={"list durable-cqs", "close durable-client", "close durable-cq", "show subscription-queue-size"})
    public boolean durableCommandsAvailable() {
        boolean isAvailable = true;
        if (CliUtil.isGfshVM()) {
            isAvailable = this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
        }
        return isAvailable;
    }
}

