/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.CommandResponseWriter;
import com.gemstone.gemfire.management.internal.cli.remote.CommandExecutionContext;
import com.gemstone.gemfire.management.internal.cli.shell.GfshConfig;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.BreakIterator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogWrapper {
    private static Object INSTANCE_LOCK = new Object();
    private static LogWrapper INSTANCE = null;
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());

    private LogWrapper() {
        Cache cache = CliUtil.getCacheIfExists();
        if (cache != null && !cache.isClosed()) {
            this.logger.addHandler(cache.getLogger().getHandler());
            CommandResponseWriterHandler handler = new CommandResponseWriterHandler();
            handler.setFilter(new Filter(){

                @Override
                public boolean isLoggable(LogRecord record) {
                    return record.getLevel().intValue() >= Level.FINE.intValue();
                }
            });
            handler.setLevel(Level.FINE);
            this.logger.addHandler(handler);
        }
        this.logger.setUseParentHandlers(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogWrapper getInstance() {
        if (INSTANCE == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new LogWrapper();
                }
            }
        }
        return INSTANCE;
    }

    public void configure(GfshConfig config) {
        if (config.isLoggingEnabled()) {
            try {
                FileHandler fileHandler = new FileHandler(config.getLogFilePath(), config.getLogFileSizeLimit(), config.getLogFileCount(), true);
                fileHandler.setFormatter(new GemFireFormatter());
                fileHandler.setLevel(config.getLogLevel());
                this.logger.addHandler(fileHandler);
                this.logger.setLevel(config.getLogLevel());
            }
            catch (SecurityException e) {
                LogWrapper.addDefaultConsoleHandler(this.logger, e.getMessage(), config.getLogFilePath());
            }
            catch (IOException e) {
                LogWrapper.addDefaultConsoleHandler(this.logger, e.getMessage(), config.getLogFilePath());
            }
        }
    }

    private static void addDefaultConsoleHandler(Logger logger, String errorMessage, String logFilePath) {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new GemFireFormatter());
        logger.addHandler(consoleHandler);
        System.err.println("ERROR: Could not log to file: " + logFilePath + ". Reason: " + errorMessage);
        System.err.println("Logs will be written on Console.");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            if (INSTANCE != null) {
                Logger innerLogger = LogWrapper.INSTANCE.logger;
                LogWrapper.cleanupLogger(innerLogger);
            }
            INSTANCE = null;
        }
    }

    private static void cleanupLogger(Logger logger) {
        if (logger != null) {
            Handler[] handlers;
            for (Handler handler : handlers = logger.getHandlers()) {
                handler.close();
                logger.removeHandler(handler);
            }
        }
    }

    protected void finalize() throws Throwable {
        LogWrapper.cleanupLogger(this.logger);
        this.logger = null;
    }

    public void setParentFor(Logger otherLogger) {
        if (otherLogger.getParent() != this.logger) {
            otherLogger.setParent(this.logger);
        }
    }

    public void setLogLevel(Level newLevel) {
        if (this.logger.getLevel() != newLevel) {
            this.logger.setLevel(newLevel);
        }
    }

    public Level getLogLevel() {
        return this.logger.getLevel();
    }

    Logger getLogger() {
        return this.logger;
    }

    public boolean severeEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public void severe(String message) {
        if (this.severeEnabled()) {
            this.logger.severe(message);
        }
    }

    public void severe(String message, Throwable t) {
        if (this.severeEnabled()) {
            this.logger.log(Level.SEVERE, message, t);
        }
    }

    public boolean warningEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void warning(String message) {
        if (this.warningEnabled()) {
            this.logger.warning(message);
        }
    }

    public void warning(String message, Throwable t) {
        if (this.warningEnabled()) {
            this.logger.log(Level.WARNING, message, t);
        }
    }

    public boolean infoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public void info(String message) {
        if (this.infoEnabled()) {
            this.logger.info(message);
        }
    }

    public void info(String message, Throwable t) {
        if (this.infoEnabled()) {
            this.logger.log(Level.INFO, message, t);
        }
    }

    public boolean configEnabled() {
        return this.logger.isLoggable(Level.CONFIG);
    }

    public void config(String message) {
        if (this.configEnabled()) {
            this.logger.config(message);
        }
    }

    public void config(String message, Throwable t) {
        if (this.configEnabled()) {
            this.logger.log(Level.CONFIG, message, t);
        }
    }

    public boolean fineEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public void fine(String message) {
        if (this.fineEnabled()) {
            this.logger.fine(message);
        }
    }

    public void fine(String message, Throwable t) {
        if (this.fineEnabled()) {
            this.logger.log(Level.FINE, message, t);
        }
    }

    public boolean finerEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    public void finer(String message) {
        if (this.finerEnabled()) {
            this.logger.finer(message);
        }
    }

    public void finer(String message, Throwable t) {
        if (this.finerEnabled()) {
            this.logger.log(Level.FINER, message, t);
        }
    }

    public boolean finestEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    public void finest(String message) {
        if (this.finestEnabled()) {
            this.logger.finest(message);
        }
    }

    public void finest(String message, Throwable t) {
        if (this.finestEnabled()) {
            this.logger.log(Level.FINEST, message, t);
        }
    }

    static class CommandResponseWriterHandler
    extends Handler {
        public CommandResponseWriterHandler() {
            this.setFormatter(new GemFireFormatter());
        }

        @Override
        public void publish(LogRecord record) {
            CommandResponseWriter responseWriter = CommandExecutionContext.getAndCreateIfAbsentCommandResponseWriter();
            responseWriter.println(this.getFormatter().format(record));
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    static class GemFireFormatter
    extends Formatter {
        private static final String FORMAT = "yyyy/MM/dd HH:mm:ss.SSS z";
        private SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS z");

        GemFireFormatter() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            pw.print('[');
            pw.print(record.getLevel().getName().toLowerCase());
            pw.print(' ');
            pw.print(this.formatDate(new Date(record.getMillis())));
            String threadName = Thread.currentThread().getName();
            if (threadName != null) {
                pw.print(' ');
                pw.print(threadName);
            }
            pw.print(" tid=0x");
            pw.print(Long.toHexString(Thread.currentThread().getId()));
            pw.print("] ");
            pw.print("(msgTID=");
            pw.print(record.getThreadID());
            pw.print(" msgSN=");
            pw.print(record.getSequenceNumber());
            pw.print(") ");
            String msg = record.getMessage();
            if (msg != null) {
                try {
                    this.formatText(pw, msg, 40);
                }
                catch (RuntimeException e) {
                    pw.println(msg);
                    pw.println(LocalizedStrings.GemFireFormatter_IGNORING_THE_FOLLOWING_EXCEPTION.toLocalizedString());
                    e.printStackTrace(pw);
                }
            } else {
                pw.println();
            }
            if (record.getThrown() != null) {
                record.getThrown().printStackTrace(pw);
            }
            pw.close();
            try {
                sw.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            String result = sw.toString();
            return result;
        }

        private void formatText(PrintWriter writer, String target, int initialLength) {
            BreakIterator boundary = BreakIterator.getLineInstance();
            boundary.setText(target);
            int start = boundary.first();
            int end = boundary.next();
            int lineLength = initialLength;
            while (end != -1) {
                char endChar = target.charAt(end - 1);
                while (!Character.isWhitespace(endChar)) {
                    int lastEnd = end;
                    end = boundary.next();
                    if (end == -1) {
                        end = lastEnd;
                        break;
                    }
                    endChar = target.charAt(end - 1);
                }
                int wordEnd = end;
                if (endChar == '\n') {
                    if (--wordEnd > 0 && target.charAt(wordEnd - 1) == '\r') {
                        --wordEnd;
                    }
                } else if (endChar == '\t') {
                    lineLength += 7;
                }
                String word = target.substring(start, wordEnd);
                lineLength += word.length();
                writer.print(word);
                if (endChar == '\n' || endChar == '\r') {
                    writer.println();
                    writer.print("  ");
                    lineLength = 2;
                }
                start = end;
                end = boundary.next();
            }
            if (lineLength != 0) {
                writer.println();
            }
        }

        private String formatDate(Date date) {
            return this.sdf.format(date);
        }
    }
}

